/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrEnumConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetterCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.psi2ir.intermediate.RematerializableValueKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J0\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u001e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ2\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002JB\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J(\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J6\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/CallGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "addParametersToCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "call", "Lorg/jetbrains/kotlin/psi2ir/intermediate/CallBuilder;", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateCall", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "generateCallWithArgumentReordering", "resultType", "generateDelegatingConstructorCall", "generateEnumConstructorSuperCall", "generateFunctionCall", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateGetVariable", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "typeArguments", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "generatePropertyGetterCall", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateValueReference", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "ir.psi2ir"})
public final class CallGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generateCall(int startOffset, int endOffset, @NotNull CallBuilder call2, @Nullable IrStatementOrigin origin) {
        CallableDescriptor descriptor2;
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        CallableDescriptor callableDescriptor = descriptor2 = call2.getDescriptor();
        return callableDescriptor instanceof PropertyDescriptor ? this.generatePropertyGetterCall((PropertyDescriptor)descriptor2, startOffset, endOffset, call2) : (callableDescriptor instanceof FunctionDescriptor ? this.generateFunctionCall((FunctionDescriptor)descriptor2, startOffset, endOffset, origin, call2) : call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)((Function2)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, startOffset, endOffset, descriptor2, call2, origin){
            final /* synthetic */ CallGenerator this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ CallBuilder $call;
            final /* synthetic */ IrStatementOrigin $origin;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue $noName_0, @Nullable IntermediateValue $noName_1) {
                return this.this$0.generateValueReference(this.$startOffset, this.$endOffset, this.$descriptor, this.$call.getOriginal(), this.$origin);
            }
            {
                this.this$0 = callGenerator;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$descriptor = callableDescriptor;
                this.$call = callBuilder;
                this.$origin = irStatementOrigin;
                super(2);
            }
        })));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IrExpression generateCall$default(CallGenerator callGenerator, int n, int n2, CallBuilder callBuilder, IrStatementOrigin irStatementOrigin, int n3, Object object) {
        if ((n3 & 8) != 0) {
            irStatementOrigin = null;
        }
        return callGenerator.generateCall(n, n2, callBuilder, irStatementOrigin);
    }

    @NotNull
    public final IrExpression generateValueReference(int startOffset, int endOffset, @NotNull DeclarationDescriptor descriptor2, @Nullable ResolvedCall<?> resolvedCall2, @Nullable IrStatementOrigin origin) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof FakeCallableDescriptorForObject) {
            irExpression = this.generateValueReference(startOffset, endOffset, ((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor(), resolvedCall2, origin);
        } else if (declarationDescriptor instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            if (classDescriptor == null) {
                Intrinsics.throwNpe();
            }
            irExpression = this.generateValueReference(startOffset, endOffset, classDescriptor, null, origin);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            KotlinType kotlinType = DescriptorUtilsKt.getClassValueType((ClassDescriptor)descriptor2);
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            KotlinType classValueType = kotlinType;
            irExpression = ArgumentsGenerationUtilsKt.generateSingletonReference(this.getStatementGenerator(), (ClassDescriptor)descriptor2, startOffset, endOffset, classValueType);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            StatementGenerator statementGenerator = this.getStatementGenerator();
            ResolvedCall<?> resolvedCall3 = resolvedCall2;
            if (resolvedCall3 == null) {
                Intrinsics.throwNpe();
            }
            irExpression = CallGenerator.generateCall$default(this, startOffset, endOffset, ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator, resolvedCall3), null, 8, null);
        } else if (declarationDescriptor instanceof SyntheticFieldDescriptor) {
            IntermediateValue receiver = ArgumentsGenerationUtilsKt.generateBackingFieldReceiver(this.getStatementGenerator(), startOffset, endOffset, resolvedCall2, (SyntheticFieldDescriptor)descriptor2);
            IrFieldSymbol field2 = this.getStatementGenerator().getContext().getSymbolTable().referenceField(((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor());
            IntermediateValue intermediateValue = receiver;
            irExpression = new IrGetFieldImpl(startOffset, endOffset, field2, intermediateValue != null ? intermediateValue.load() : null, null, null, 48, null);
        } else if (declarationDescriptor instanceof VariableDescriptor) {
            irExpression = this.generateGetVariable(startOffset, endOffset, (VariableDescriptor)descriptor2, ArgumentsGenerationUtilsKt.getTypeArguments(resolvedCall2), origin);
        } else {
            String string = "Unexpected callable descriptor: " + descriptor2 + ' ' + descriptor2.getClass().getSimpleName();
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return irExpression;
    }

    private final IrExpression generateGetVariable(int startOffset, int endOffset, VariableDescriptor descriptor2, Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments2, IrStatementOrigin origin) {
        IrExpression irExpression;
        if (descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated()) {
            LocalVariableAccessorDescriptor.Getter getter = ((LocalVariableDescriptor)descriptor2).getGetter();
            if (getter == null) {
                Intrinsics.throwNpe();
            }
            LocalVariableAccessorDescriptor.Getter getterDescriptor = getter;
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            SimpleFunctionDescriptor simpleFunctionDescriptor = getterDescriptor.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"getterDescriptor.original");
            IrFunctionSymbol getterSymbol = symbolTable.referenceFunction(simpleFunctionDescriptor);
            KotlinType kotlinType = ((LocalVariableDescriptor)descriptor2).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.type");
            LocalVariableAccessorDescriptor.Getter getter2 = getterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)getter2, (String)"getterDescriptor");
            FunctionDescriptor functionDescriptor2 = getter2;
            IrStatementOrigin irStatementOrigin = origin;
            if (irStatementOrigin == null) {
                irStatementOrigin = IrStatementOrigin.GET_LOCAL_PROPERTY.INSTANCE;
            }
            irExpression = new IrCallImpl(startOffset, endOffset, kotlinType, getterSymbol, functionDescriptor2, typeArguments2, irStatementOrigin, null, 128, null);
        } else {
            irExpression = new IrGetValueImpl(startOffset, endOffset, this.getContext().getSymbolTable().referenceValue(descriptor2), origin);
        }
        return irExpression;
    }

    static /* bridge */ /* synthetic */ IrExpression generateGetVariable$default(CallGenerator callGenerator, int n, int n2, VariableDescriptor variableDescriptor, Map map2, IrStatementOrigin irStatementOrigin, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            irStatementOrigin = null;
        }
        return callGenerator.generateGetVariable(n, n2, variableDescriptor, map2, irStatementOrigin);
    }

    @NotNull
    public final IrExpression generateDelegatingConstructorCall(int startOffset, int endOffset, @NotNull CallBuilder call2) {
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        return call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)((Function2)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, call2, startOffset, endOffset){
            final /* synthetic */ CallGenerator this$0;
            final /* synthetic */ CallBuilder $call;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiver, @Nullable IntermediateValue extensionReceiver) {
                CallableDescriptor callableDescriptor = this.$call.getDescriptor();
                if (!(callableDescriptor instanceof ClassConstructorDescriptor)) {
                    callableDescriptor = null;
                }
                ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)callableDescriptor;
                if (classConstructorDescriptor == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Class constructor expected: " + this.$call.getDescriptor())));
                }
                ClassConstructorDescriptor descriptor2 = classConstructorDescriptor;
                IrConstructorSymbol constructorSymbol = this.this$0.getContext().getSymbolTable().referenceConstructor(descriptor2.getOriginal());
                IrDelegatingConstructorCallImpl irCall = new IrDelegatingConstructorCallImpl(this.$startOffset, this.$endOffset, constructorSymbol, descriptor2, ArgumentsGenerationUtilsKt.getTypeArguments(this.$call.getOriginal()));
                IntermediateValue intermediateValue = dispatchReceiver;
                irCall.setDispatchReceiver(intermediateValue != null ? intermediateValue.load() : null);
                IntermediateValue intermediateValue2 = extensionReceiver;
                irCall.setExtensionReceiver(intermediateValue2 != null ? intermediateValue2.load() : null);
                IrFunctionAccessExpression irFunctionAccessExpression = irCall;
                SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(descriptor2).getUnitType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"descriptor.builtIns.unitType");
                return CallGenerator.access$addParametersToCall(this.this$0, this.$startOffset, this.$endOffset, this.$call, irFunctionAccessExpression, simpleType2);
            }
            {
                this.this$0 = callGenerator;
                this.$call = callBuilder;
                this.$startOffset = n;
                this.$endOffset = n2;
                super(2);
            }
        }));
    }

    @NotNull
    public final IrExpression generateEnumConstructorSuperCall(int startOffset, int endOffset, @NotNull CallBuilder call2) {
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        CallableDescriptor constructorDescriptor = call2.getDescriptor();
        if (!(constructorDescriptor instanceof ClassConstructorDescriptor)) {
            throw (Throwable)((Object)new AssertionError((Object)("Constructor expected: " + constructorDescriptor)));
        }
        ClassDescriptor classDescriptor = ((ClassConstructorDescriptor)constructorDescriptor).getContainingDeclaration();
        if (Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) ^ true) {
            throw (Throwable)((Object)new AssertionError((Object)("Enum class constructor expected: " + classDescriptor)));
        }
        return call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)((Function2)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, constructorDescriptor, startOffset, endOffset, call2){
            final /* synthetic */ CallGenerator this$0;
            final /* synthetic */ CallableDescriptor $constructorDescriptor;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ CallBuilder $call;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiver, @Nullable IntermediateValue extensionReceiver) {
                if (dispatchReceiver != null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Dispatch receiver should be null: " + dispatchReceiver)));
                }
                if (extensionReceiver != null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Extension receiver should be null: " + extensionReceiver)));
                }
                IrConstructorSymbol constructorSymbol = this.this$0.getContext().getSymbolTable().referenceConstructor((ClassConstructorDescriptor)this.$constructorDescriptor);
                IrEnumConstructorCallImpl irCall = new IrEnumConstructorCallImpl(this.$startOffset, this.$endOffset, constructorSymbol);
                IrFunctionAccessExpression irFunctionAccessExpression = irCall;
                KotlinType kotlinType = ((ClassConstructorDescriptor)this.$constructorDescriptor).getReturnType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"constructorDescriptor.returnType");
                return CallGenerator.access$addParametersToCall(this.this$0, this.$startOffset, this.$endOffset, this.$call, irFunctionAccessExpression, kotlinType);
            }
            {
                this.this$0 = callGenerator;
                this.$constructorDescriptor = callableDescriptor;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$call = callBuilder;
                super(2);
            }
        }));
    }

    private final IrExpression generatePropertyGetterCall(PropertyDescriptor descriptor2, int startOffset, int endOffset, CallBuilder call2) {
        return call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)((Function2)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, call2, descriptor2, startOffset, endOffset){
            final /* synthetic */ CallGenerator this$0;
            final /* synthetic */ CallBuilder $call;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiverValue, @Nullable IntermediateValue extensionReceiverValue) {
                IrExpression irExpression;
                IrClassSymbol irClassSymbol;
                ClassDescriptor classDescriptor = this.$call.getSuperQualifier();
                if (classDescriptor != null) {
                    ClassDescriptor classDescriptor2;
                    ClassDescriptor it = classDescriptor2 = classDescriptor;
                    irClassSymbol = this.this$0.getContext().getSymbolTable().referenceClass(it);
                } else {
                    irClassSymbol = null;
                }
                IrClassSymbol superQualifierSymbol = irClassSymbol;
                PropertyGetterDescriptor getterDescriptor = this.$descriptor.getGetter();
                if (getterDescriptor != null) {
                    SymbolTable symbolTable = this.this$0.getContext().getSymbolTable();
                    PropertyGetterDescriptor propertyGetterDescriptor = getterDescriptor.getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor, (String)"getterDescriptor.original");
                    IrFunctionSymbol getterSymbol = symbolTable.referenceFunction(propertyGetterDescriptor);
                    IntermediateValue intermediateValue = dispatchReceiverValue;
                    IntermediateValue intermediateValue2 = extensionReceiverValue;
                    irExpression = new IrGetterCallImpl(this.$startOffset, this.$endOffset, getterSymbol, (FunctionDescriptor)getterDescriptor, ArgumentsGenerationUtilsKt.getTypeArguments(this.$call.getOriginal()), intermediateValue != null ? intermediateValue.load() : null, intermediateValue2 != null ? intermediateValue2.load() : null, IrStatementOrigin.GET_PROPERTY.INSTANCE, superQualifierSymbol);
                } else {
                    IrFieldSymbol fieldSymbol = this.this$0.getContext().getSymbolTable().referenceField(this.$descriptor);
                    IntermediateValue intermediateValue = dispatchReceiverValue;
                    irExpression = new IrGetFieldImpl(this.$startOffset, this.$endOffset, fieldSymbol, intermediateValue != null ? intermediateValue.load() : null, (IrStatementOrigin)IrStatementOrigin.GET_PROPERTY.INSTANCE, superQualifierSymbol);
                }
                return irExpression;
            }
            {
                this.this$0 = callGenerator;
                this.$call = callBuilder;
                this.$descriptor = propertyDescriptor;
                this.$startOffset = n;
                this.$endOffset = n2;
                super(2);
            }
        }));
    }

    private final IrExpression generateFunctionCall(FunctionDescriptor functionDescriptor2, int startOffset, int endOffset, IrStatementOrigin origin, CallBuilder call2) {
        return call2.getCallReceiver().call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)((Function2)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, functionDescriptor2, call2, startOffset, endOffset, origin){
            final /* synthetic */ CallGenerator this$0;
            final /* synthetic */ FunctionDescriptor $functionDescriptor;
            final /* synthetic */ CallBuilder $call;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ IrStatementOrigin $origin;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiverValue, @Nullable IntermediateValue extensionReceiverValue) {
                IrClassSymbol irClassSymbol;
                KotlinType kotlinType = this.$functionDescriptor.getReturnType();
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType returnType2 = kotlinType;
                SymbolTable symbolTable = this.this$0.getContext().getSymbolTable();
                FunctionDescriptor functionDescriptor2 = this.$functionDescriptor.getOriginal();
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor.original");
                IrFunctionSymbol functionSymbol = symbolTable.referenceFunction(functionDescriptor2);
                ClassDescriptor classDescriptor = this.$call.getSuperQualifier();
                if (classDescriptor != null) {
                    ClassDescriptor classDescriptor2;
                    ClassDescriptor it = classDescriptor2 = classDescriptor;
                    irClassSymbol = this.this$0.getContext().getSymbolTable().referenceClass(it);
                } else {
                    irClassSymbol = null;
                }
                IrClassSymbol superQualifierSymbol = irClassSymbol;
                KotlinType kotlinType2 = returnType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"returnType");
                IrCallImpl irCall = new IrCallImpl(this.$startOffset, this.$endOffset, kotlinType2, functionSymbol, this.$functionDescriptor, ArgumentsGenerationUtilsKt.getTypeArguments(this.$call.getOriginal()), this.$origin, superQualifierSymbol);
                IntermediateValue intermediateValue = dispatchReceiverValue;
                irCall.setDispatchReceiver(intermediateValue != null ? intermediateValue.load() : null);
                IntermediateValue intermediateValue2 = extensionReceiverValue;
                irCall.setExtensionReceiver(intermediateValue2 != null ? intermediateValue2.load() : null);
                return CallGenerator.access$addParametersToCall(this.this$0, this.$startOffset, this.$endOffset, this.$call, irCall, returnType2);
            }
            {
                this.this$0 = callGenerator;
                this.$functionDescriptor = functionDescriptor2;
                this.$call = callBuilder;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$origin = irStatementOrigin;
                super(2);
            }
        }));
    }

    private final IrExpression addParametersToCall(int startOffset, int endOffset, CallBuilder call2, IrFunctionAccessExpression irCall, KotlinType returnType2) {
        IrExpression irExpression;
        if (CallBuilderKt.isValueArgumentReorderingRequired(call2)) {
            irExpression = this.generateCallWithArgumentReordering(irCall, startOffset, endOffset, call2, returnType2);
        } else {
            List<IrExpression> valueArguments2 = CallBuilderKt.getValueArgumentsInParameterOrder(call2);
            for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)valueArguments2)) {
                int index2 = indexedValue.component1();
                IrExpression valueArgument = (IrExpression)indexedValue.component2();
                irCall.putValueArgument(index2, valueArgument);
            }
            irExpression = irCall;
        }
        return irExpression;
    }

    private final IrExpression generateCallWithArgumentReordering(IrFunctionAccessExpression irCall, int startOffset, int endOffset, CallBuilder call2, KotlinType resultType) {
        Object irArgumentValue;
        ValueParameterDescriptor valueParameterDescriptor;
        Map map2;
        ResolvedCall<?> resolvedCall2 = call2.getOriginal();
        Collection<ResolvedValueArgument> valueArgumentsInEvaluationOrder = resolvedCall2.getValueArguments().values();
        List<ValueParameterDescriptor> valueParameters = resolvedCall2.getResultingDescriptor().getValueParameters();
        IrBlockImpl irBlock = new IrBlockImpl(startOffset, endOffset, resultType, IrStatementOrigin.ARGUMENTS_REORDERING_FOR_CALL.INSTANCE);
        HashMap valueArgumentsToValueParameters = new HashMap();
        List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)list2)) {
            int index2 = indexedValue.component1();
            ResolvedValueArgument valueArgument = (ResolvedValueArgument)indexedValue.component2();
            ValueParameterDescriptor valueParameter = valueParameters.get(index2);
            Map map3 = valueArgumentsToValueParameters;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"valueArgument");
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameter, (String)"valueParameter");
            map3.put(map2, valueParameterDescriptor);
        }
        HashMap irArgumentValues = new HashMap();
        for (ResolvedValueArgument valueArgument : valueArgumentsInEvaluationOrder) {
            IrExpression irArgument;
            ValueParameterDescriptor valueParameter;
            Object v = valueArgumentsToValueParameters.get(valueArgument);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            ValueParameterDescriptor valueParameterDescriptor2 = valueParameter = (ValueParameterDescriptor)v;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor2, (String)"valueParameter");
            if (call2.getValueArgument(valueParameterDescriptor2) == null) {
                continue;
            }
            irArgumentValue = RematerializableValueKt.createTemporaryVariableInBlock(this.getScope(), irArgument, irBlock, valueParameter.getName().asString());
            map2 = irArgumentValues;
            valueParameterDescriptor = valueParameter;
            Object object = irArgumentValue;
            map2.put(valueParameterDescriptor, object);
        }
        List<ResolvedValueArgument> list3 = resolvedCall2.getValueArgumentsByIndex();
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        Iterable $receiver$iv = list3;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            int n = index$iv++;
            irArgumentValue = (ResolvedValueArgument)item$iv;
            int index3 = n;
            ValueParameterDescriptor valueParameter = valueParameters.get(index3);
            IntermediateValue intermediateValue = (IntermediateValue)irArgumentValues.get(valueParameter);
            irCall.putValueArgument(index3, intermediateValue != null ? intermediateValue.load() : null);
        }
        irBlock.getStatements().add(irCall);
        return irBlock;
    }

    public CallGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$addParametersToCall(CallGenerator $this, int startOffset, int endOffset, @NotNull CallBuilder call2, @NotNull IrFunctionAccessExpression irCall, @NotNull KotlinType returnType2) {
        return $this.addParametersToCall(startOffset, endOffset, call2, irCall, returnType2);
    }
}

