/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.ChangeManagement;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.transparent.CCaseConfig;
import net.sourceforge.transparent.CCaseSharedConfig;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.ChangeManagement.CCaseContentRevision;
import net.sourceforge.transparent.ChangeManagement.CCaseWriteableAndUnversionedCollector;
import net.sourceforge.transparent.ContentRevisionFactory;
import net.sourceforge.transparent.DescribeMultipleProcessor;
import net.sourceforge.transparent.Status;
import net.sourceforge.transparent.StatusMultipleProcessor;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCaseChangeProvider
implements ChangeProvider {
    public static final Key<Object> ourVersionedKey = new Key("CCASE_VERSIONED");
    @NonNls
    private static final String REMINDER_TITLE = "Reminder";
    @NonNls
    private static final String REMINDER_TEXT = "Project started with ClearCase configured to be in the Offline mode.";
    @NonNls
    private static final String COLLECT_MSG = "Collecting writable files";
    @NonNls
    private static final String SEARCHNEW_MSG = "Searching New";
    @NonNls
    private static final String ESTABLISH_CONNECTION_FAIL_SIG = "Unable to establish connection to snapshot view";
    @NonNls
    private static final String UNABLE_OPEN_VIEW_SSIG = "Unable to open snapshot view";
    @NonNls
    private static final String FAIL_2_CONNECT_MSG = "Failed to connect to ClearCase Server: ";
    @NonNls
    private static final String FAIL_2_CONNECT_TITLE = "Server Connection Problem";
    @NonNls
    private static final String FAIL_2_START_MSG = "Failed to start Cleartool. Please check ClearCase installation or current View's settings";
    @NonNls
    private static final String FAIL_2_START_VIEW_MSG = "Failed to start Cleartool. Please check module's View settings";
    @NonNls
    private static final String LIST_CHECKOUTS_CMD = "lsco";
    @NonNls
    private static final String CURR_USER_ONLY_SWITCH = "-me";
    @NonNls
    private static final String CURR_VIEW_ONLY_SWITCH = "-cview";
    @NonNls
    private static final String SHORT_SWITCH = "-short";
    @NonNls
    private static final String RECURSE_SWITCH = "-recurse";
    private static final int MAX_FILES_FOR_ITERATIVE_STATUS = 200;
    private static final Logger LOG = Logger.getInstance((String)"#net.sourceforge.transparent.ChangeManagement.CCaseChangeProvider");
    private final Project project;
    private final CCaseViewsManager myViewManager;
    private final TransparentVcs host;
    private CCaseConfig config;
    private CCaseSharedConfig mySharedConfig;
    private ProgressIndicator progress;
    private boolean isBatchUpdate;
    private boolean isFirstShow;
    private final HashSet<String> filesWritable = new HashSet();
    private final HashSet<String> filesNew = new HashSet();
    private final HashSet<String> filesChanged = new HashSet();
    private final HashSet<String> filesHijacked = new HashSet();
    private final HashSet<String> filesIgnored = new HashSet();
    private final HashSet<String> filesMerge = new HashSet();
    private final HashSet<String> filesLocallyDeleted = new HashSet();
    private final ChangeListManager myChangeListManager;
    private TreeSet<VirtualFile> myDirs;

    public CCaseChangeProvider(Project project, TransparentVcs hostVcs) {
        this.project = project;
        this.myViewManager = CCaseViewsManager.getInstance(project);
        this.host = hostVcs;
        this.isFirstShow = true;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.project);
        this.myDirs = new TreeSet(FilePathComparator.getInstance());
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return false;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progressIndicator, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyScope", "net/sourceforge/transparent/ChangeManagement/CCaseChangeProvider", "getChanges"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "net/sourceforge/transparent/ChangeManagement/CCaseChangeProvider", "getChanges"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "net/sourceforge/transparent/ChangeManagement/CCaseChangeProvider", "getChanges"));
        }
        if (addGate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addGate", "net/sourceforge/transparent/ChangeManagement/CCaseChangeProvider", "getChanges"));
        }
        this.myDirs.clear();
        if (this.project.isDisposed()) {
            return;
        }
        CCaseChangeProvider.logChangesContent(dirtyScope);
        if (ProjectLevelVcsManager.getInstance((Project)this.project).getDirectoryMappings((AbstractVcs)this.host).size() == 0) {
            return;
        }
        this.config = this.host.getConfig();
        this.mySharedConfig = CCaseSharedConfig.getInstance(this.project);
        this.progress = progressIndicator;
        this.isBatchUpdate = this.isBatchUpdate(dirtyScope);
        this.showOptionalReminder();
        this.initInternals();
        this.isFirstShow = false;
        try {
            this.iterateOverRecursiveFolders(dirtyScope);
            this.iterateOverDirtyDirectories(dirtyScope);
            this.iterateOverDirtyFiles(dirtyScope);
            if (!this.config.isOffline()) {
                if (this.isBatchUpdate && this.config.synchActivitiesOnRefresh) {
                    this.myViewManager.extractViewActivities();
                    this.myViewManager.synchActivities2ChangeLists(addGate);
                }
                this.computeStatuses(dirtyScope);
            } else {
                this.restoreStatusesFromCached();
            }
            this.processStatusExceptions();
            this.getUnversioned();
            this.addCheckedOutFolders();
            if (this.mySharedConfig.isUseUcmModel()) {
                this.setActivityInfoOnChangedFiles();
            }
            this.addLocallyDeletedFiles(builder);
            this.addAddedFiles(builder);
            this.addChangedFiles(builder);
            this.addRemovedFiles(builder);
            this.addIgnoredFiles(builder);
            this.addMergeConflictFiles(builder);
        }
        catch (ClearCaseException e) {
            String excMessage = e.getMessage();
            excMessage = excMessage == null ? "" : excMessage;
            String message = FAIL_2_CONNECT_MSG + excMessage;
            if (TransparentVcs.isServerDownMessage(excMessage)) {
                message = message + "\n\nSwitching to the offline mode";
                this.config.setOfflineMode(true);
            } else if (excMessage.contains(UNABLE_OPEN_VIEW_SSIG) || excMessage.contains(ESTABLISH_CONNECTION_FAIL_SIG)) {
                message = FAIL_2_START_VIEW_MSG + excMessage;
            }
            String msg = message;
            LOG.info((Throwable)e);
            throw new VcsException(msg);
        }
        catch (RuntimeException e) {
            String message = "Failed to start Cleartool. Please check ClearCase installation or current View's settings: " + e.getMessage();
            LOG.info((Throwable)e);
            throw new VcsException(message);
        }
        finally {
            TransparentVcs.LOG.debug("-- EndChangeProvider| New: " + this.filesNew.size() + ", modified: " + this.filesChanged.size() + ", hijacked:" + this.filesHijacked.size() + ", ignored: " + this.filesIgnored.size());
        }
    }

    private void addCheckedOutFolders() {
        HashSet<String> checkedOutFolders = new HashSet<String>(this.host.getCheckedOutFolders());
        for (String dir : checkedOutFolders) {
            Status status;
            if (this.host.renamedFolders.containsKey(dir) || this.host.renamedFolders.containsValue(dir)) continue;
            File file = new File(dir);
            Status status2 = status = file.exists() ? this.host.getStatus(file) : null;
            if (Status.HIJACKED.equals(status) || Status.CHECKED_OUT.equals(status)) {
                this.filesChanged.add(dir);
                continue;
            }
            this.host.undoCheckout(dir);
        }
    }

    private void getUnversioned() {
        for (VirtualFile dir : this.myDirs) {
            if (this.host.renamedFolders.containsKey(dir.getPath())) continue;
            Status status = this.host.getStatus(dir);
            if (Status.NOT_AN_ELEMENT.equals(status)) {
                this.filesNew.add(dir.getPath());
                dir.putUserData(ourVersionedKey, null);
                continue;
            }
            dir.putUserData(ourVersionedKey, (Object)Boolean.TRUE);
            if (!Status.HIJACKED.equals(status) && !Status.CHECKED_OUT.equals(status)) continue;
            this.filesChanged.add(dir.getPath());
            this.host.checkedOutFolders.add(dir.getPath());
        }
    }

    private void showOptionalReminder() {
        if (this.isBatchUpdate && this.isFirstShow && this.config.isOffline()) {
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showWarningDialog((Project)this.project, (String)REMINDER_TEXT, (String)REMINDER_TITLE), null, (Project)this.project);
        }
    }

    private void iterateOverRecursiveFolders(VcsDirtyScope dirtyScope) {
        for (FilePath path : dirtyScope.getRecursivelyDirtyDirectories()) {
            LOG.debug("-- ChangeProvider - Iterating over [content] root: " + path.getPath());
            if (this.progress != null) {
                this.progress.setText(COLLECT_MSG);
            }
            this.collectWritableFiles(path);
            LOG.debug("-- ChangeProvider - Total: " + this.filesWritable.size() + " writable files after the last root.");
            if (this.progress == null) continue;
            this.progress.setText(SEARCHNEW_MSG);
        }
    }

    private void iterateOverDirtyDirectories(VcsDirtyScope dirtyScope) {
        for (FilePath path : dirtyScope.getDirtyFiles()) {
            String fileName = path.getPath();
            VirtualFile file = path.getVirtualFile();
            if (!path.isDirectory() || file == null) continue;
            if (this.host.isFileIgnored(file)) {
                this.filesIgnored.add(fileName);
                continue;
            }
            String refName = this.host.discoverOldName(fileName);
            if (!this.host.fileExistsInVcs(refName)) {
                this.filesNew.add(fileName);
                continue;
            }
            if (refName.equals(fileName) || this.isUnderRenamedFolder(fileName)) continue;
            this.filesChanged.add(fileName);
        }
    }

    private void iterateOverDirtyFiles(VcsDirtyScope scope) {
        for (FilePath path : scope.getDirtyFiles()) {
            String fileName = path.getPath();
            VirtualFile file = path.getVirtualFile();
            if (this.host.isFileIgnored(file)) {
                this.filesIgnored.add(fileName);
                continue;
            }
            if (file == null || !file.isWritable() || !CCaseChangeProvider.isProperNotification(path)) continue;
            this.filesWritable.add(fileName);
        }
    }

    private void collectWritableFiles(FilePath filePath) {
        CCaseWriteableAndUnversionedCollector collector = new CCaseWriteableAndUnversionedCollector(this.project, this.host);
        collector.collectWritableFiles(filePath);
        this.filesIgnored.addAll(collector.getFilesIgnored());
        this.filesWritable.addAll(collector.getFilesWritable());
        this.myDirs.addAll(collector.getDirs());
    }

    private void computeStatuses(VcsDirtyScope dirtyScope) {
        LOG.debug("---ChangeProvider - " + this.filesIgnored.size() + " ignored files accumulated so far.");
        if (this.filesWritable.size() < 200) {
            this.analyzeWritableFiles(this.filesWritable);
        } else {
            Collection roots = dirtyScope.getAffectedContentRoots();
            List pathsAsString = ContainerUtil.map((Collection)roots, VirtualFile::getPath);
            StatusMultipleProcessor processor = new StatusMultipleProcessor(pathsAsString);
            processor.setRecursive(true);
            processor.setViewOnly(true);
            processor.execute();
            this.processViewStatusResults(processor);
        }
    }

    private void processViewStatusResults(StatusMultipleProcessor processor) {
        for (String path : processor.getUnversioned()) {
            this.filesNew.add(path);
        }
        for (String path : processor.getCheckoutFiles()) {
            if (this.host.renamedFiles.containsValue(path) || this.host.renamedFolders.containsValue(path)) continue;
            this.filesChanged.add(path);
        }
        for (String path : processor.getHijackedFiles()) {
            String oldName;
            if (path.equals(oldName = this.host.discoverOldName(path))) {
                this.filesHijacked.add(path);
                continue;
            }
            this.filesChanged.add(path);
        }
        for (String path : processor.getLocallyDeleted()) {
            String newName = this.host.discoverNewName(path);
            if (!this.host.renamedFiles.containsKey(newName)) {
                if (!path.equals(newName)) {
                    File newFile = new File(newName);
                    if (!newFile.exists() || !newFile.canWrite()) continue;
                    this.filesChanged.add(newName);
                    continue;
                }
                if (this.host.renamedFolders.containsValue(newName)) continue;
                this.filesLocallyDeleted.add(path);
                continue;
            }
            this.filesChanged.add(newName);
        }
    }

    private void analyzeWritableFiles(HashSet<String> writables) {
        if (writables.size() == 0) {
            return;
        }
        List<String> writableFiles = this.filterOutMarkedFiles(writables);
        ArrayList<String> refNames = new ArrayList<String>();
        for (String file : writableFiles) {
            String legalName = this.host.discoverOldName(file).replace('\\', '/');
            refNames.add(legalName);
        }
        LOG.debug("ChangeProvider - Analyzing writables in batch mode using CLEARTOOL on " + writables.size() + " files.");
        StatusMultipleProcessor processor = new StatusMultipleProcessor(refNames);
        processor.execute();
        LOG.debug("ChangeProvider - \"CLEARTOOL LS\" batch command finished.");
        this.processViewStatusResults(processor);
    }

    private List<String> filterOutMarkedFiles(HashSet<String> list) {
        ArrayList<String> files = new ArrayList<String>();
        for (String path : list) {
            VirtualFile file = VcsUtil.getVirtualFile((String)path);
            if (file.getUserData(TransparentVcs.SUCCESSFUL_CHECKOUT) != null) {
                file.putUserData(TransparentVcs.SUCCESSFUL_CHECKOUT, null);
                this.filesChanged.add(file.getPath());
                continue;
            }
            if (file.getUserData(TransparentVcs.MERGE_CONFLICT) != null) {
                this.filesMerge.add(file.getPath());
                continue;
            }
            files.add(path);
        }
        return files;
    }

    private void processStatusExceptions() {
        Iterator<String> it = this.filesChanged.iterator();
        while (it.hasNext()) {
            String fileName = it.next();
            if (!this.host.isNewOverRenamed(fileName)) continue;
            it.remove();
            this.filesNew.add(fileName);
        }
    }

    private void restoreStatusesFromCached() {
        for (String fileName : this.filesWritable) {
            if (this.host.containsModified(fileName)) {
                this.filesChanged.add(fileName);
                continue;
            }
            if (this.host.containsNew(fileName)) {
                this.filesNew.add(fileName);
                continue;
            }
            this.filesHijacked.add(fileName);
        }
    }

    private void addLocallyDeletedFiles(ChangelistBuilder builder) {
        for (String file : this.filesLocallyDeleted) {
            FilePath path = VcsUtil.getFilePath((String)file);
            builder.processLocallyDeletedFile(path);
        }
    }

    private void addAddedFiles(ChangelistBuilder builder) {
        for (String fileName : this.filesNew) {
            String refName = this.host.discoverOldName(fileName);
            if (!refName.equals(fileName)) continue;
            if (this.host.containsNew(fileName) || this.host.containsNew(refName)) {
                FilePath path = VcsUtil.getFilePath((String)fileName);
                String activity = this.findActivityForFile(path, path);
                builder.processChangeInList(new Change(null, (ContentRevision)new CurrentContentRevision(path)), activity, TransparentVcs.getKey());
                continue;
            }
            builder.processUnversionedFile(VcsUtil.getVirtualFile((String)fileName));
        }
    }

    private void setActivityInfoOnChangedFiles() {
        ArrayList<String> filesToCheck = new ArrayList<String>();
        for (String fileName : this.filesChanged) {
            if (this.myViewManager.getCheckoutActivityForFile(fileName) != null) continue;
            filesToCheck.add(fileName);
        }
        this.setActivityInfoOnChangedFiles(filesToCheck);
    }

    public void setActivityInfoOnChangedFiles(List<String> files) {
        ArrayList<String> refFilesToCheck = new ArrayList<String>();
        for (String fileName : files) {
            refFilesToCheck.add(this.host.discoverOldName(fileName));
        }
        DescribeMultipleProcessor processor = new DescribeMultipleProcessor(refFilesToCheck);
        processor.execute();
        boolean hasAlreadyReloadedActivities = false;
        for (int i = 0; i < refFilesToCheck.size(); ++i) {
            String activity = processor.getActivity((String)refFilesToCheck.get(i));
            if (activity == null) continue;
            String activityName = this.myViewManager.getActivityDisplayName(activity);
            if (activityName == null) {
                if (!hasAlreadyReloadedActivities) {
                    hasAlreadyReloadedActivities = true;
                    this.myViewManager.extractViewActivities();
                }
                activityName = this.myViewManager.getActivityDisplayName(activity);
            }
            if (activityName == null) continue;
            this.myViewManager.addFile2Changelist(files.get(i), activityName);
        }
    }

    private void addChangedFiles(ChangelistBuilder builder) {
        String validRefName;
        this.filesChanged.removeAll(this.host.renamedFolders.keySet());
        for (String fileName : this.filesChanged) {
            validRefName = this.host.discoverOldName(fileName);
            this.add2ChangeList(builder, FileStatus.MODIFIED, fileName, validRefName);
        }
        for (String fileName : this.filesHijacked) {
            validRefName = this.host.discoverOldName(fileName);
            this.add2ChangeList(builder, FileStatus.HIJACKED, fileName, validRefName);
        }
        for (String folderName : this.host.renamedFolders.keySet()) {
            String oldFolderName = this.host.renamedFolders.get(folderName);
            FilePath refPath = VcsUtil.getFilePath((String)oldFolderName, (boolean)true);
            FilePath currPath = VcsUtil.getFilePath((String)folderName);
            String activity = this.findActivityForFile(refPath, currPath);
            CCaseContentRevision revision = ContentRevisionFactory.getRevision(refPath, this.project);
            builder.processChangeInList(new Change((ContentRevision)revision, (ContentRevision)new CurrentContentRevision(currPath), FileStatus.MODIFIED), activity, TransparentVcs.getKey());
        }
    }

    private void add2ChangeList(ChangelistBuilder builder, FileStatus status, String fileName, String validRefName) {
        FilePath refPath = VcsUtil.getFilePath((String)validRefName);
        FilePath currPath = VcsUtil.getFilePath((String)fileName);
        String activity = this.findActivityForFile(refPath, currPath);
        CCaseContentRevision revision = ContentRevisionFactory.getRevision(refPath, this.project);
        builder.processChangeInList(new Change((ContentRevision)revision, (ContentRevision)new CurrentContentRevision(currPath), status), activity, TransparentVcs.getKey());
    }

    private void addRemovedFiles(ChangelistBuilder builder) {
        FilePath refPath;
        HashSet<String> files = new HashSet<String>();
        files.addAll(this.host.removedFolders);
        for (String path : files) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((String)path, (boolean)true));
        }
        files.clear();
        files.addAll(this.host.removedFiles);
        for (String path : files) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((String)path, (boolean)false));
        }
        files.clear();
        files.addAll(this.host.deletedFolders);
        for (String path : files) {
            refPath = VcsUtil.getFilePath((String)path, (boolean)true);
            String activity = this.findActivityForFile(refPath, refPath);
            builder.processChangeInList(new Change((ContentRevision)new CurrentContentRevision(refPath), null, FileStatus.DELETED), activity, TransparentVcs.getKey());
        }
        files.clear();
        files.addAll(this.host.deletedFiles);
        for (String path : files) {
            refPath = VcsUtil.getFilePath((String)path, (boolean)false);
            CCaseContentRevision revision = ContentRevisionFactory.getRevision(refPath, this.project);
            String activity = this.findActivityForFile(refPath, refPath);
            builder.processChangeInList(new Change((ContentRevision)revision, null, FileStatus.DELETED), activity, TransparentVcs.getKey());
        }
    }

    private void addIgnoredFiles(ChangelistBuilder builder) {
        for (String path : this.filesIgnored) {
            builder.processIgnoredFile(VcsUtil.getVirtualFile((String)path));
        }
    }

    private void addMergeConflictFiles(ChangelistBuilder builder) {
        for (String path : this.filesMerge) {
            FilePath fp = VcsUtil.getFilePath((String)path);
            CCaseContentRevision revision = ContentRevisionFactory.getRevision(fp, this.project);
            String activity = this.findActivityForFile(fp, fp);
            builder.processChangeInList(new Change((ContentRevision)revision, (ContentRevision)new CurrentContentRevision(fp), FileStatus.MERGED_WITH_CONFLICTS), activity, TransparentVcs.getKey());
        }
    }

    private static boolean isProperNotification(FilePath filePath) {
        String oldName = filePath.getName();
        String newName = filePath.getVirtualFile() == null ? "" : filePath.getVirtualFile().getName();
        String oldParent = filePath.getVirtualFileParent() == null ? "" : filePath.getVirtualFileParent().getPath();
        String newParent = filePath.getPath().substring(0, filePath.getPath().length() - oldName.length() - 1);
        return newParent.equals(oldParent) && (newName.equals(oldName) || StringUtil.isEmpty((String)newName) && StringUtil.isEmpty((String)oldName));
    }

    private void initInternals() {
        this.filesLocallyDeleted.clear();
        this.filesWritable.clear();
        this.filesNew.clear();
        this.filesChanged.clear();
        this.filesHijacked.clear();
        this.filesIgnored.clear();
        this.filesMerge.clear();
    }

    private boolean isBatchUpdate(VcsDirtyScope scope) {
        ProjectLevelVcsManager mgr = ProjectLevelVcsManager.getInstance((Project)this.project);
        VirtualFile[] roots = mgr.getRootsUnderVcs((AbstractVcs)this.host);
        for (FilePath path : scope.getRecursivelyDirtyDirectories()) {
            for (VirtualFile root : roots) {
                VirtualFile vfScopePath = path.getVirtualFile();
                if (vfScopePath == null || !vfScopePath.getPath().equalsIgnoreCase(root.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUnderRenamedFolder(String fileName) {
        return this.getUnderRenamedFolder(fileName) != null;
    }

    @Nullable
    private String getUnderRenamedFolder(String fileName) {
        for (String folder : this.host.renamedFolders.keySet()) {
            if (!fileName.startsWith(folder)) continue;
            return folder;
        }
        return null;
    }

    static boolean isValidFile(VirtualFile file) {
        return file != null && file.isWritable() && !file.isDirectory();
    }

    @Nullable
    private String findActivityForFile(FilePath refPath, FilePath currPath) {
        Change change;
        String activity = null;
        if (this.mySharedConfig.isUseUcmModel() && this.myViewManager.isUcmViewForFile(refPath) && (activity = this.myViewManager.getCheckoutActivityForFile(refPath.getPath())) == null && (change = this.myChangeListManager.getChange(currPath)) == null) {
            activity = this.myViewManager.getActivityOfViewOfFile(currPath);
            if (activity == null) {
                throw new NullPointerException("Illegal (NULL) activity name from ViewInfo for an UCM view.");
            }
            this.myViewManager.addFile2Changelist(refPath.getPath(), activity);
        }
        return activity;
    }

    private static void logChangesContent(VcsDirtyScope scope) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("-- ChangeProvider: Dirty files: " + scope.getDirtyFiles().size());
        if (scope.getDirtyFiles().size() > 0) {
            LOG.debug(" == " + CCaseChangeProvider.extMasks(scope.getDirtyFiles()));
        }
        LOG.debug(", dirty recursive directories: " + scope.getRecursivelyDirtyDirectories().size());
        for (FilePath path : scope.getDirtyFiles()) {
            LOG.debug("                                " + path.getPath());
        }
        LOG.debug("                                ---");
        for (FilePath path : scope.getRecursivelyDirtyDirectories()) {
            LOG.debug("                                " + path.getPath());
        }
    }

    private static String extMasks(Set<FilePath> scope) {
        HashMap<String, Integer> masks = new HashMap<String, Integer>();
        for (FilePath path : scope) {
            String ext;
            int index = path.getName().lastIndexOf(46);
            if (index == -1) continue;
            Integer count = (Integer)masks.get(ext = path.getName().substring(index));
            masks.put(ext, count == null ? 1 : count + 1);
        }
        String masksStr = "";
        for (String ext : masks.keySet()) {
            masksStr = masksStr + ext + " - " + (Integer)masks.get(ext) + "; ";
        }
        return masksStr;
    }
}

