/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.transparent.actions.FileAction;
import net.sourceforge.transparent.exceptions.ClearCaseException;

public abstract class AsynchronousAction
extends FileAction {
    protected abstract void perform(VirtualFile var1, Project var2) throws VcsException;

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setEnabled(files.length == 1);
        }
    }

    @Override
    protected List<VcsException> runAction(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = VcsUtil.getOneVirtualFile((AnActionEvent)e);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        try {
            this.perform(file, project);
        }
        catch (VcsException ex) {
            ex.setVirtualFile(file);
            exceptions.add(ex);
        }
        catch (ClearCaseException ex) {
            VcsException vcsEx = new VcsException((Throwable)ex);
            vcsEx.setVirtualFile(file);
            exceptions.add(vcsEx);
        }
        return exceptions;
    }

    public static String getVersionExtendedPathName(Project project, VirtualFile file) {
        String path = VcsUtil.getCanonicalPath((String)file.getPath());
        FileStatus status = AsynchronousAction.getFileStatus(project, file);
        return status.equals(FileStatus.HIJACKED) ? path + "@@" : path;
    }
}

