/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.intentions;

import com.intellij.guice.GuiceBundle;
import com.intellij.guice.intentions.Intention;
import com.intellij.guice.intentions.MoveBindingToClassPredicate;
import com.intellij.guice.intentions.PsiElementPredicate;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.guice.utils.MutationUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MoveBindingToClassIntention
extends Intention {
    @NotNull
    public String getText() {
        String string = GuiceBundle.message("move.binding.to.class.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/intentions/MoveBindingToClassIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GuiceBundle.message("move.binding.to.class.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/intentions/MoveBindingToClassIntention", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MoveBindingToClassPredicate moveBindingToClassPredicate = new MoveBindingToClassPredicate();
        if (moveBindingToClassPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/intentions/MoveBindingToClassIntention", "getElementPredicate"));
        }
        return moveBindingToClassPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/guice/intentions/MoveBindingToClassIntention", "processIntention"));
        }
        PsiMethodCallExpression originalCall = (PsiMethodCallExpression)element;
        PsiClass implmentingClass = GuiceUtils.findImplementingClassForBinding(originalCall);
        PsiClass implementedClass = GuiceUtils.findImplementedClassForBinding(originalCall);
        MutationUtils.addAnnotation((PsiModifierListOwner)implementedClass, "@com.google.inject.ImplementedBy(" + implmentingClass.getQualifiedName() + ".class)");
        PsiMethodCallExpression bindingCall = GuiceUtils.findBindingCallForBinding(originalCall);
        PsiExpression qualifier = bindingCall.getMethodExpression().getQualifierExpression();
        assert (qualifier != null);
        MutationUtils.replaceExpression(qualifier.getText(), (PsiExpression)bindingCall);
    }
}

