/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring.model.xml.beans;

import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.values.PropertyValueConverter;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Stubbed;
import org.jetbrains.annotations.NotNull;

/**
 * @author Dmitry Avdeev
 */
public interface SpringValueHolder extends SpringElementsHolder, SpringValueHolderDefinition {

  /**
   * Returns the value of the ref child.
   * <pre>
   * <h3>Attribute null:ref documentation</h3>
   * 	A short-cut alternative to a nested "<ref bean='...'/>".
   * <p/>
   * </pre>
   *
   * @return the value of the ref child.
   */
  @NotNull
  @Attribute(value = "ref")
  @Convert(value = SpringBeanResolveConverter.PropertyBean.class)
  @Stubbed
  GenericAttributeValue<SpringBeanPointer> getRefAttr();

  /**
   * Returns the value of the value child.
   * <pre>
   * <h3>Attribute null:value documentation</h3>
   * 	A short-cut alternative to a nested "<value>...</value>"
   * 	element.
   * <p/>
   * </pre>
   *
   * @return the value of the value child.
   */
  @NotNull
  @Attribute(value = "value")
  @Convert(PropertyValueConverter.class)
  @Stubbed
  GenericAttributeValue<String> getValueAttr();
}
