/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.llm;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.ml.llm.domains.context.DomainItemContext;
import com.intellij.ml.llm.domains.ide.presentation.DomainItemPresentation;
import com.intellij.ml.llm.domains.ide.presentation.PresentableProvider;
import com.intellij.ml.llm.domains.mapper.DomainContextMapper;
import com.intellij.openapi.util.Pair;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.security.references.SpringSecurityRoleUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecurityRolesProvider
implements PresentableProvider<Pair<String, Icon>>,
DomainContextMapper<Pair<String, Icon>> {
    public static final String ID = "Security Roles";

    @NotNull
    public String getId() {
        return ID;
    }

    public boolean isAvailable(@NotNull DomainSearchScope searchScope) {
        if (searchScope == null) {
            SecurityRolesProvider.$$$reportNull$$$0(0);
        }
        return SpringLibraryUtil.hasSpringLibrary((Collection)searchScope.getModules());
    }

    @NotNull
    public Set<Pair<String, Icon>> getItems(@NotNull DomainSearchScope searchScope) {
        if (searchScope == null) {
            SecurityRolesProvider.$$$reportNull$$$0(1);
        }
        Set<Pair<String, Icon>> set = Objects.requireNonNull(searchScope.getModules()).stream().flatMap(module -> SpringSecurityRoleUtils.collectRoles(module).stream().map(s -> Pair.create((Object)s, (Object)AllIcons.Nodes.SecurityRole))).collect(Collectors.toSet());
        if (set == null) {
            SecurityRolesProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public DomainItemContext asContext(Pair<String, Icon> pair, @NotNull DomainSearchScope searchScope) {
        if (searchScope == null) {
            SecurityRolesProvider.$$$reportNull$$$0(3);
        }
        DomainItemContext domainItemContext = DomainItemContext.create((String)ID, (String)"Security Role").with("name", (String)pair.first);
        if (domainItemContext == null) {
            SecurityRolesProvider.$$$reportNull$$$0(4);
        }
        return domainItemContext;
    }

    @NotNull
    public DomainItemPresentation getItemPresentation(Pair<String, Icon> item) {
        return new SecurityRoleItemPresentation((String)item.first, (Icon)item.second);
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return SpringApiIcons.SpringBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/llm/SecurityRolesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/llm/SecurityRolesProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private static class SecurityRoleItemPresentation
    implements DomainItemPresentation {
        private final String name;
        private final Icon icon;

        private SecurityRoleItemPresentation(String name, Icon icon) {
            this.name = name;
            this.icon = icon;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                SecurityRoleItemPresentation.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getPresentableText() {
            return this.name;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return this.icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/llm/SecurityRolesProvider$SecurityRoleItemPresentation", "getName"));
        }
    }
}

