/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.mvc.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInsight.navigation.TargetPresentationProvider;
import com.intellij.microservices.url.inlay.UrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.security.SpringSecurityBundle;
import com.intellij.spring.security.SpringSecurityIcons;
import com.intellij.spring.security.mvc.SpringSecuredUrlsUtils;
import com.intellij.spring.security.mvc.actions.SpringSecurityMatcherCellRenderer;
import com.intellij.spring.security.util.SpringSecurityUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/spring/security/mvc/actions/ShowSecurityMatcherRegistryInlayAction;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayAction;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "actionPerformed", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "mouseEvent", "Ljava/awt/event/MouseEvent;", "isAvailable", "", "urlPathInlayHint", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint;", "intellij.spring.security.mvc"})
public final class ShowSecurityMatcherRegistryInlayAction
implements UrlPathInlayAction {
    @NotNull
    public Icon getIcon() {
        Icon icon = SpringSecurityIcons.SpringSecurity;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SpringSecurity");
        return icon;
    }

    @NotNull
    public String getName() {
        String string = SpringSecurityBundle.message("action.show.security.matcher.registration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void actionPerformed(@NotNull PsiFile file, @NotNull Editor editor, @NotNull UrlPathContext urlPathContext, @NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return;
        }
        Module module2 = module;
        MicroservicesUsageCollector.INSTANCE.getURL_INLAY_ACTION_TRIGGERED_EVENT().log(project2, (Object)"show_security_matchers");
        PsiTargetNavigator navigator = new PsiTargetNavigator(() -> ShowSecurityMatcherRegistryInlayAction.actionPerformed$lambda$0(module2, urlPathContext)).presentationProvider((TargetPresentationProvider)new SpringSecurityMatcherCellRenderer());
        if (!navigator.navigate(editor, SpringSecurityBundle.message("spring.secured.configurations", new Object[0]))) {
            HintManager.getInstance().showInformationHint(editor, SpringSecurityBundle.message("spring.secured.configuration.not.found", new Object[0]));
        }
    }

    public boolean isAvailable(@NotNull PsiFile file, @NotNull UrlPathInlayHint urlPathInlayHint) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)urlPathInlayHint, (String)"urlPathInlayHint");
        return SpringSecurityUtil.hasSpringLibrary(ModuleUtilCore.findModuleForFile((PsiFile)file));
    }

    private static final Collection actionPerformed$lambda$0(Module $module, UrlPathContext $urlPathContext) {
        Set<PsiElement> set = SpringSecuredUrlsUtils.getMatchedUrls($module, $urlPathContext);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getMatchedUrls(...)");
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)set));
    }
}

