/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.mvc.inlay;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.ParameterInfoTaskRunnerUtil;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.security.SpringSecurityBundle;
import com.intellij.spring.security.mvc.actions.SpringSecurityUrlMappingPopupFactory;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spring/security/mvc/inlay/SpringSecurityMatchersInlayCollector;", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "scaleAwareFactory", "Lcom/intellij/codeInsight/hints/presentation/ScaleAwarePresentationFactory;", "buildPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "element", "Lcom/intellij/psi/PsiElement;", "urlMappingsFunc", "Lkotlin/Function0;", "", "Lcom/intellij/spring/mvc/mapping/UrlMappingElement;", "intellij.spring.security.mvc"})
public abstract class SpringSecurityMatchersInlayCollector
extends FactoryInlayHintsCollector {
    @NotNull
    private final ScaleAwarePresentationFactory scaleAwareFactory;

    public SpringSecurityMatchersInlayCollector(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(editor);
        this.scaleAwareFactory = new ScaleAwarePresentationFactory(editor, this.getFactory());
    }

    @NotNull
    public final InlayPresentation buildPresentation(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Function0<? extends Set<UrlMappingElement>> urlMappingsFunc) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(urlMappingsFunc, (String)"urlMappingsFunc");
        PresentationFactory $this$buildPresentation_u24lambda_u246 = this.getFactory();
        boolean bl = false;
        String string = SpringSecurityBundle.message("spring.secured.url.matcher.inlay", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ScaleAwarePresentationFactory scaleAwarePresentationFactory = this.scaleAwareFactory;
        Icon icon = AllIcons.Actions.InlaySecuredShield;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlaySecuredShield");
        InlayPresentation inlayPresentation = this.scaleAwareFactory.smallScaledIcon(icon);
        InlayPresentationFactory.Padding padding = new InlayPresentationFactory.Padding(2, 2, 1, 1);
        Color color = editor.getColorsScheme().getColor(DefaultLanguageHighlighterColors.INLINE_REFACTORING_SETTINGS_DEFAULT);
        InlayPresentationFactory.RoundedCorners roundedCorners = new InlayPresentationFactory.RoundedCorners(6, 6);
        return $this$buildPresentation_u24lambda_u246.referenceOnHover($this$buildPresentation_u24lambda_u246.withTooltip(string, this.scaleAwareFactory.lineCentered(InlayPresentationFactory.container$default((InlayPresentationFactory)((InlayPresentationFactory)scaleAwarePresentationFactory), (InlayPresentation)inlayPresentation, (InlayPresentationFactory.Padding)padding, (InlayPresentationFactory.RoundedCorners)roundedCorners, (Color)color, (float)0.0f, (int)16, null))), (arg_0, arg_1) -> SpringSecurityMatchersInlayCollector.buildPresentation$lambda$6$lambda$5(editor, element, urlMappingsFunc, arg_0, arg_1));
    }

    private static final Set buildPresentation$lambda$6$lambda$5$lambda$0(Function0 $urlMappingsFunc) {
        return (Set)$urlMappingsFunc.invoke();
    }

    private static final boolean buildPresentation$lambda$6$lambda$5$lambda$1(Editor $editor) {
        return $editor.isDisposed();
    }

    private static final void buildPresentation$lambda$6$lambda$5$lambda$3$lambda$2(Editor $editor, Set urlMappings) {
        if (urlMappings.isEmpty()) {
            HintManager.getInstance().showInformationHint($editor, SpringSecurityBundle.message("spring.secured.url.not.found", new Object[0]));
            return;
        }
        Intrinsics.checkNotNull((Object)urlMappings);
        SpringSecurityUrlMappingPopupFactory.getUrlMappingPopup(CollectionsKt.toList((Iterable)urlMappings), SpringSecurityBundle.message("spring.secured.url.matcher.navigate.title", new Object[0])).showInBestPositionFor($editor);
    }

    private static final void buildPresentation$lambda$6$lambda$5$lambda$3(PsiElement $element, NonBlockingReadAction $action, Editor $editor) {
        ParameterInfoTaskRunnerUtil.runTask((Project)$element.getProject(), (NonBlockingReadAction)$action, arg_0 -> SpringSecurityMatchersInlayCollector.buildPresentation$lambda$6$lambda$5$lambda$3$lambda$2($editor, arg_0), (String)SpringSecurityBundle.message("spring.secured.urls.search", new Object[0]), (Editor)$editor);
    }

    private static final boolean buildPresentation$lambda$6$lambda$5$lambda$4(Editor $editor, Object it) {
        return $editor.isDisposed();
    }

    private static final void buildPresentation$lambda$6$lambda$5(Editor $editor, PsiElement $element, Function0 $urlMappingsFunc, MouseEvent mouseEvent, Point point) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
        MicroservicesUsageCollector.INSTANCE.getURL_INLAY_ACTION_TRIGGERED_EVENT().log($editor.getProject(), (Object)"show_secured_urls");
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> SpringSecurityMatchersInlayCollector.buildPresentation$lambda$6$lambda$5$lambda$0($urlMappingsFunc)).inSmartMode($element.getProject()).expireWhen(() -> SpringSecurityMatchersInlayCollector.buildPresentation$lambda$6$lambda$5$lambda$1($editor));
        Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"expireWhen(...)");
        NonBlockingReadAction action = nonBlockingReadAction;
        Runnable runnable = () -> SpringSecurityMatchersInlayCollector.buildPresentation$lambda$6$lambda$5$lambda$3($element, action, $editor);
        ApplicationManager.getApplication().invokeLater(runnable, arg_0 -> SpringSecurityMatchersInlayCollector.buildPresentation$lambda$6$lambda$5$lambda$4($editor, arg_0));
    }
}

