/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.mvc.matchers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.security.mvc.UrlMatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSecurityUrlMatcher
implements UrlMatcher {
    protected final String myPattern;
    protected final SmartPsiElementPointer<PsiElement> myPsiElementPointer;
    @Nullable
    private String myRequestMethod = null;

    public SpringSecurityUrlMatcher(@Nullable String pattern, @Nullable PsiElement navigationElement) {
        this.myPattern = pattern;
        this.myPsiElementPointer = navigationElement == null ? null : SmartPointerManager.createPointer((PsiElement)navigationElement);
    }

    @Override
    public boolean acceptMethod(String ... methods) {
        if (this.myRequestMethod == null || Arrays.stream(methods).filter(Objects::nonNull).toList().isEmpty()) {
            return true;
        }
        for (String method : methods) {
            if (!this.myRequestMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    public void setRequestMethod(@Nullable String requestMethod) {
        this.myRequestMethod = requestMethod;
    }

    @Override
    public boolean accept(@NotNull String request) {
        if (request == null) {
            SpringSecurityUrlMatcher.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myPattern)) {
            return false;
        }
        return this.acceptUrl(SpringSecurityUrlMatcher.replaceVariables(this.myPattern), request.isEmpty() ? "/" : request);
    }

    @NotNull
    private static String replaceVariables(@NotNull String pattern) {
        if (pattern == null) {
            SpringSecurityUrlMatcher.$$$reportNull$$$0(1);
        }
        for (String varText : SpringSecurityUrlMatcher.getVariableTexts(pattern)) {
            pattern = StringUtil.replace((String)pattern, (String)varText, (String)"*");
        }
        String string = pattern;
        if (string == null) {
            SpringSecurityUrlMatcher.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static @NotNull List<@NotNull String> getVariableTexts(@NotNull String pattern) {
        if (pattern == null) {
            SpringSecurityUrlMatcher.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.map((Collection)PlaceholderTextRanges.getPlaceholderRanges((String)pattern, (String)"{", (String)"}", (boolean)true, (boolean)true), range -> range.substring(pattern));
        if (list == null) {
            SpringSecurityUrlMatcher.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected boolean acceptUrl(@NotNull String pattern, @NotNull String url) {
        if (pattern == null) {
            SpringSecurityUrlMatcher.$$$reportNull$$$0(5);
        }
        if (url == null) {
            SpringSecurityUrlMatcher.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Override
    @Nullable
    public PsiElement getIdentifyingElement() {
        return this.myPsiElementPointer == null ? null : this.myPsiElementPointer.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/mvc/matchers/SpringSecurityUrlMatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/mvc/matchers/SpringSecurityUrlMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableTexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "replaceVariables";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTexts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

