/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.compilation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.importing.tree.MavenJavaVersionHolder;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.ManifestBuilder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.maven.model.impl.MavenEjbClientConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenIdBean;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

public class ResourceConfigGenerator {
    private static final Logger LOG = Logger.getInstance(ResourceConfigGenerator.class);
    private static final String IDEA_MAVEN_DISABLE_MANIFEST = System.getProperty("idea.maven.disable.manifest");
    private final ProjectFileIndex fileIndex;
    private final MavenProjectsManager mavenProjectsManager;
    private final RemotePathTransformerFactory.Transformer transformer;
    private final MavenProjectConfiguration projectConfig;
    private final MavenProject mavenProject;

    public ResourceConfigGenerator(ProjectFileIndex fileIndex, MavenProjectsManager mavenProjectsManager, RemotePathTransformerFactory.Transformer transformer, MavenProjectConfiguration projectConfig, MavenProject mavenProject) {
        this.fileIndex = fileIndex;
        this.mavenProjectsManager = mavenProjectsManager;
        this.transformer = transformer;
        this.projectConfig = projectConfig;
        this.mavenProject = mavenProject;
    }

    public void generateResourceConfig() {
        if ("pom".equals(this.mavenProject.getPackaging())) {
            return;
        }
        VirtualFile pomXml = this.mavenProject.getFile();
        Module module = this.fileIndex.getModuleForFile(pomXml);
        if (module == null) {
            return;
        }
        if (!Comparing.equal((Object)this.mavenProject.getDirectoryFile(), (Object)this.fileIndex.getContentRootForFile(pomXml))) {
            return;
        }
        MavenJavaVersionHolder javaVersions = MavenImportUtil.getMavenJavaVersions(this.mavenProject);
        StandardMavenModuleType moduleType = MavenImportUtil.getModuleType(this.mavenProject, javaVersions);
        this.generate(module, moduleType);
        if (moduleType == StandardMavenModuleType.COMPOUND_MODULE) {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
            String moduleName = module.getName();
            this.generate(moduleManager.findModuleByName(moduleName + ".main"), StandardMavenModuleType.MAIN_ONLY);
            this.generate(moduleManager.findModuleByName(moduleName + ".test"), StandardMavenModuleType.TEST_ONLY);
        }
    }

    private void generate(Module module, StandardMavenModuleType moduleType) {
        String string;
        if (module == null) {
            return;
        }
        MavenModuleResourceConfiguration resourceConfig = new MavenModuleResourceConfiguration();
        MavenId projectId = this.mavenProject.getMavenId();
        resourceConfig.id = new MavenIdBean(projectId.getGroupId(), projectId.getArtifactId(), projectId.getVersion());
        MavenId parentId = this.mavenProject.getParentId();
        if (parentId != null) {
            resourceConfig.parentId = new MavenIdBean(parentId.getGroupId(), parentId.getArtifactId(), parentId.getVersion());
        }
        resourceConfig.directory = this.transformer.toRemotePathOrSelf(FileUtil.toSystemIndependentName((String)this.mavenProject.getDirectory()));
        resourceConfig.delimitersPattern = MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(this.mavenProject).pattern();
        for (Map.Entry<String, String> entry : this.mavenProject.getModelMap().entrySet()) {
            String key = entry.getKey();
            String string2 = entry.getValue();
            if (string2 == null) continue;
            resourceConfig.modelMap.put(key, this.transformer.toRemotePathOrSelf(string2));
        }
        ResourceConfigGenerator.addEarModelMapEntries(this.mavenProject, resourceConfig.modelMap);
        Element pluginConfiguration = this.mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        resourceConfig.outputDirectory = this.transformer.toRemotePathOrSelf(ResourceConfigGenerator.getResourcesPluginGoalOutputDirectory(this.mavenProject, pluginConfiguration, "resources"));
        resourceConfig.testOutputDirectory = this.transformer.toRemotePathOrSelf(ResourceConfigGenerator.getResourcesPluginGoalOutputDirectory(this.mavenProject, pluginConfiguration, "testResources"));
        if (moduleType != StandardMavenModuleType.TEST_ONLY) {
            ResourceConfigGenerator.addResources(this.transformer, resourceConfig.resources, this.mavenProject.getResources());
        }
        if (moduleType != StandardMavenModuleType.MAIN_ONLY) {
            ResourceConfigGenerator.addResources(this.transformer, resourceConfig.testResources, this.mavenProject.getTestResources());
        }
        ResourceConfigGenerator.addWebResources(this.transformer, module, this.projectConfig, this.mavenProject);
        ResourceConfigGenerator.addEjbClientArtifactConfiguration(module, this.projectConfig, this.mavenProject);
        resourceConfig.filteringExclusions.addAll(MavenProjectsTree.getFilterExclusions(this.mavenProject));
        Properties properties = ResourceConfigGenerator.getFilteringProperties(this.mavenProject, this.mavenProjectsManager);
        for (Map.Entry entry : properties.entrySet()) {
            resourceConfig.properties.put((String)entry.getKey(), this.transformer.toRemotePathOrSelf((String)entry.getValue()));
        }
        resourceConfig.escapeString = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "escapeString", null);
        String escapeWindowsPaths = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "escapeWindowsPaths");
        if (escapeWindowsPaths != null) {
            resourceConfig.escapeWindowsPaths = Boolean.parseBoolean(escapeWindowsPaths);
        }
        if ((string = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "overwrite")) != null) {
            resourceConfig.overwrite = Boolean.parseBoolean(string);
        }
        this.projectConfig.moduleConfigurations.put(module.getName(), resourceConfig);
        ResourceConfigGenerator.generateManifest(this.mavenProject, module, resourceConfig);
    }

    private static void addEarModelMapEntries(@NotNull MavenProject mavenProject, @NotNull Map<String, String> modelMap) {
        if (mavenProject == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(0);
        }
        if (modelMap == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(1);
        }
        Element pluginConfiguration = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-ear-plugin");
        String skinnyWars = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "skinnyWars", "false");
        modelMap.put("build.plugin.maven-ear-plugin.skinnyWars", skinnyWars);
    }

    @Nullable
    private static String getResourcesPluginGoalOutputDirectory(@NotNull MavenProject mavenProject, @Nullable Element pluginConfiguration, @NotNull String goal) {
        Element goalConfiguration;
        String outputDirectory;
        if (mavenProject == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(2);
        }
        if (goal == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(3);
        }
        if ((outputDirectory = MavenJDOMUtil.findChildValueByPath(goalConfiguration = mavenProject.getPluginGoalConfiguration("org.apache.maven.plugins", "maven-resources-plugin", goal), "outputDirectory", null)) == null) {
            outputDirectory = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "outputDirectory", null);
        }
        return outputDirectory == null || FileUtil.isAbsolute((String)outputDirectory) ? outputDirectory : mavenProject.getDirectory() + "/" + outputDirectory;
    }

    private static void generateManifest(@NotNull MavenProject mavenProject, @NotNull Module module, @NotNull MavenModuleResourceConfiguration resourceConfig) {
        if (mavenProject == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(5);
        }
        if (resourceConfig == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(6);
        }
        if (mavenProject.isAggregator()) {
            return;
        }
        if (Boolean.parseBoolean(IDEA_MAVEN_DISABLE_MANIFEST)) {
            resourceConfig.manifest = null;
            return;
        }
        try {
            MavenDomProjectModel domModel;
            int quoteIndex;
            String jdkVersion = null;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk != null && (jdkVersion = sdk.getVersionString()) != null && (quoteIndex = jdkVersion.indexOf(34)) != -1) {
                jdkVersion = jdkVersion.substring(quoteIndex + 1, jdkVersion.length() - 1);
            }
            if ((domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile())) != null) {
                UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
                new ManifestBuilder(mavenProject).withJdkVersion(jdkVersion).build().write((OutputStream)outputStream);
                String resolvedText = MavenPropertyResolver.resolve(outputStream.toString(), domModel);
                resourceConfig.manifest = Base64.getEncoder().encodeToString(resolvedText.getBytes(StandardCharsets.UTF_8));
            }
            resourceConfig.classpath = ManifestBuilder.getClasspath(mavenProject);
        }
        catch (ManifestBuilder.ManifestBuilderException e) {
            LOG.warn("Unable to generate artifact manifest", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Unable to save generated artifact manifest", (Throwable)e);
        }
    }

    private static Properties getFilteringProperties(MavenProject mavenProject, MavenProjectsManager mavenProjectsManager) {
        String javaVersion;
        Properties properties = new Properties();
        for (String each : mavenProject.getFilterPropertiesFiles()) {
            try (FileInputStream in = new FileInputStream(each);){
                properties.load(in);
            }
            catch (IOException iOException) {}
        }
        properties.putAll((Map<?, ?>)mavenProject.getProperties());
        properties.setProperty("settings.localRepository", mavenProject.getLocalRepository().getAbsolutePath());
        String jreDir = MavenUtil.getModuleJreHome(mavenProjectsManager, mavenProject);
        if (jreDir != null) {
            properties.setProperty("java.home", jreDir);
        }
        if ((javaVersion = MavenUtil.getModuleJavaVersion(mavenProjectsManager, mavenProject)) != null) {
            properties.setProperty("java.version", javaVersion);
        }
        return properties;
    }

    private static void addResources(RemotePathTransformerFactory.Transformer transformer, List<ResourceRootConfiguration> container, @NotNull Collection<MavenResource> resources) {
        if (resources == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(7);
        }
        for (MavenResource resource : resources) {
            String dir = resource.getDirectory();
            ResourceRootConfiguration props = new ResourceRootConfiguration();
            props.directory = transformer.toRemotePathOrSelf(FileUtil.toSystemIndependentName((String)dir));
            String target = transformer.toRemotePathOrSelf(resource.getTargetPath());
            props.targetPath = target != null ? FileUtil.toSystemIndependentName((String)target) : null;
            props.isFiltered = resource.isFiltered();
            props.includes.clear();
            for (String include : resource.getIncludes()) {
                props.includes.add(include.trim());
            }
            props.excludes.clear();
            for (String exclude : resource.getExcludes()) {
                props.excludes.add(exclude.trim());
            }
            container.add(props);
        }
    }

    private static void addWebResources(RemotePathTransformerFactory.Transformer transformer, @NotNull Module module, MavenProjectConfiguration projectCfg, MavenProject mavenProject) {
        Element warCfg;
        if (module == null) {
            ResourceConfigGenerator.$$$reportNull$$$0(8);
        }
        if ((warCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin")) == null) {
            return;
        }
        boolean filterWebXml = Boolean.parseBoolean(warCfg.getChildTextTrim("filteringDeploymentDescriptors"));
        Element webResources = warCfg.getChild("webResources");
        String webArtifactName = MavenUtil.getArtifactName("war", module, true);
        MavenWebArtifactConfiguration artifactResourceCfg = (MavenWebArtifactConfiguration)projectCfg.webArtifactConfigs.get(webArtifactName);
        if (artifactResourceCfg == null) {
            artifactResourceCfg = new MavenWebArtifactConfiguration();
            artifactResourceCfg.moduleName = module.getName();
            projectCfg.webArtifactConfigs.put(webArtifactName, artifactResourceCfg);
        } else {
            LOG.error("MavenWebArtifactConfiguration already exists.");
        }
        ResourceConfigGenerator.addSplitAndTrimmed(artifactResourceCfg.packagingIncludes, warCfg.getChildTextTrim("packagingIncludes"));
        ResourceConfigGenerator.addSplitAndTrimmed(artifactResourceCfg.packagingExcludes, warCfg.getChildTextTrim("packagingExcludes"));
        ResourceConfigGenerator.addConfigValues(artifactResourceCfg.nonFilteredFileExtensions, "nonFilteredFileExtensions", "nonFilteredFileExtension", warCfg);
        Object warSourceDirectory = warCfg.getChildTextTrim("warSourceDirectory");
        if (warSourceDirectory == null) {
            warSourceDirectory = "src/main/webapp";
        }
        if (!FileUtil.isAbsolute((String)warSourceDirectory)) {
            warSourceDirectory = mavenProject.getDirectory() + "/" + (String)warSourceDirectory;
        }
        artifactResourceCfg.warSourceDirectory = transformer.toRemotePathOrSelf(FileUtil.toSystemIndependentName((String)StringUtil.trimEnd((String)warSourceDirectory, (char)'/')));
        ResourceConfigGenerator.addSplitAndTrimmed(artifactResourceCfg.warSourceIncludes, warCfg.getChildTextTrim("warSourceIncludes"));
        ResourceConfigGenerator.addSplitAndTrimmed(artifactResourceCfg.warSourceExcludes, warCfg.getChildTextTrim("warSourceExcludes"));
        if (webResources != null) {
            for (Element resource : webResources.getChildren("resource")) {
                ResourceRootConfiguration r = new ResourceRootConfiguration();
                Object directory = resource.getChildTextTrim("directory");
                if (StringUtil.isEmptyOrSpaces((String)directory)) continue;
                if (!FileUtil.isAbsolute((String)directory)) {
                    directory = mavenProject.getDirectory() + "/" + (String)directory;
                }
                r.directory = transformer.toRemotePathOrSelf((String)directory);
                r.isFiltered = Boolean.parseBoolean(resource.getChildTextTrim("filtering"));
                r.targetPath = resource.getChildTextTrim("targetPath");
                ResourceConfigGenerator.addConfigValues(r.includes, "includes", "include", resource);
                ResourceConfigGenerator.addConfigValues(r.excludes, "excludes", "exclude", resource);
                artifactResourceCfg.webResources.add(r);
            }
        }
        if (filterWebXml) {
            ResourceRootConfiguration r = new ResourceRootConfiguration();
            r.directory = transformer.toRemotePathOrSelf((String)warSourceDirectory);
            r.includes = Collections.singleton("WEB-INF/web.xml");
            r.isFiltered = true;
            r.targetPath = "";
            artifactResourceCfg.webResources.add(r);
        }
    }

    private static void addConfigValues(Collection<String> collection, String tag, String subTag, Element resource) {
        Element config = resource.getChild(tag);
        if (config != null) {
            for (Element value : config.getChildren(subTag)) {
                String text = value.getTextTrim();
                if (text.isEmpty()) continue;
                collection.add(text);
            }
            if (config.getChildren(subTag).isEmpty()) {
                ResourceConfigGenerator.addSplitAndTrimmed(collection, config.getTextTrim());
            }
        }
    }

    private static void addSplitAndTrimmed(Collection<String> collection, @Nullable String commaSeparatedList) {
        if (commaSeparatedList != null) {
            for (String s : StringUtil.split((String)commaSeparatedList, (String)",")) {
                collection.add(s.trim());
            }
        }
    }

    private static void addEjbClientArtifactConfiguration(Module module, MavenProjectConfiguration projectCfg, MavenProject mavenProject) {
        Element excludes;
        Element pluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-ejb-plugin");
        if (pluginCfg == null || !Boolean.parseBoolean(pluginCfg.getChildTextTrim("generateClient"))) {
            return;
        }
        MavenEjbClientConfiguration ejbClientCfg = new MavenEjbClientConfiguration();
        Element includes = pluginCfg.getChild("clientIncludes");
        if (includes != null) {
            for (Element include : includes.getChildren("clientInclude")) {
                String includeText = include.getTextTrim();
                if (includeText.isEmpty()) continue;
                ejbClientCfg.includes.add(includeText);
            }
        }
        if ((excludes = pluginCfg.getChild("clientExcludes")) != null) {
            for (Element exclude : excludes.getChildren("clientExclude")) {
                String excludeText = exclude.getTextTrim();
                if (excludeText.isEmpty()) continue;
                ejbClientCfg.excludes.add(excludeText);
            }
        }
        if (!ejbClientCfg.isEmpty()) {
            projectCfg.ejbClientArtifactConfigs.put(MavenUtil.getEjbClientArtifactName(module, true), ejbClientCfg);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceConfig";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/compilation/ResourceConfigGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addEarModelMapEntries";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourcesPluginGoalOutputDirectory";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "generateManifest";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addResources";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addWebResources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

