/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenIndexerCMDState;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.utils.MavenLog;

public class LocalMavenIndexServerRemoteProcessSupport
extends MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport {
    private final Sdk myJdk;
    private final String myOptions;
    private final MavenDistribution myDistribution;
    private final Integer myDebugPort;

    public LocalMavenIndexServerRemoteProcessSupport(@NotNull Sdk jdk, @Nullable String vmOptions, @NotNull MavenDistribution mavenDistribution, @Nullable Integer debugPort) {
        if (jdk == null) {
            LocalMavenIndexServerRemoteProcessSupport.$$$reportNull$$$0(0);
        }
        if (mavenDistribution == null) {
            LocalMavenIndexServerRemoteProcessSupport.$$$reportNull$$$0(1);
        }
        super(MavenServer.class);
        this.myJdk = jdk;
        this.myOptions = vmOptions;
        this.myDistribution = mavenDistribution;
        this.myDebugPort = debugPort;
    }

    protected void fireModificationCountChanged() {
    }

    protected String getName(@NotNull Object o) {
        if (o == null) {
            LocalMavenIndexServerRemoteProcessSupport.$$$reportNull$$$0(2);
        }
        return LocalMavenIndexServerRemoteProcessSupport.class.getSimpleName();
    }

    protected RunProfileState getRunProfileState(@NotNull Object target, @NotNull Object configuration, @NotNull Executor executor) {
        if (target == null) {
            LocalMavenIndexServerRemoteProcessSupport.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            LocalMavenIndexServerRemoteProcessSupport.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            LocalMavenIndexServerRemoteProcessSupport.$$$reportNull$$$0(5);
        }
        return new MavenIndexerCMDState(this.myJdk, this.myOptions, this.myDistribution, this.myDebugPort);
    }

    @Override
    public String type() {
        return "Local";
    }

    @Override
    public void onTerminate(Consumer<ProcessEvent> onTerminate) {
    }

    protected void sendDataAfterStart(ProcessHandler handler) {
        if (handler.getProcessInput() == null) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(handler.getProcessInput(), StandardCharsets.UTF_8);){
            writer.write("token=" + MavenRemoteObjectWrapper.ourToken);
            writer.write(System.lineSeparator());
            writer.flush();
            MavenLog.LOG.info("Sent token to maven server");
        }
        catch (IOException e) {
            MavenLog.LOG.warn("Cannot send token to maven server", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDistribution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/server/LocalMavenIndexServerRemoteProcessSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRunProfileState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

