/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/server/wsl/WslRemotePathTransformFactory;", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "createTransformer", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;", "intellij.maven"})
public final class WslRemotePathTransformFactory
implements RemotePathTransformerFactory {
    @Override
    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MavenWslUtil.useWslMaven(project);
    }

    @Override
    @NotNull
    public RemotePathTransformerFactory.Transformer createTransformer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WSLDistribution wSLDistribution = MavenWslUtil.tryGetWslDistribution(project);
        if (wSLDistribution == null) {
            throw new IllegalArgumentException("Project " + project + " is not WSL based!");
        }
        WSLDistribution wslDistribution = wSLDistribution;
        return new RemotePathTransformerFactory.Transformer(wslDistribution){
            final /* synthetic */ WSLDistribution $wslDistribution;
            {
                this.$wslDistribution = $wslDistribution;
            }

            public String toRemotePath(String localPath) {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                return this.$wslDistribution.getWslPath(localPath);
            }

            public String toIdePath(String remotePath) {
                Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
                String string = this.$wslDistribution.getWindowsPath(remotePath);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWindowsPath(...)");
                return string;
            }

            public boolean canBeRemotePath(String s) {
                String string = s;
                return string != null ? StringsKt.startsWith$default((String)string, (String)"/", (boolean)false, (int)2, null) : false;
            }
        };
    }
}

