/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;

abstract class AbstractI18nizeQuickFix<T extends UExpression>
implements LocalQuickFix,
I18nQuickFixHandler<T>,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(I18nizeQuickFix.class);
    private static final Set<String> AUXILIARY_WORDS = Set.of("is", "the", "of", "and", "a", "an");
    private final NlsInfo.Localized myInfo;

    protected AbstractI18nizeQuickFix(NlsInfo.Localized info) {
        this.myInfo = info;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public final void performI18nization(PsiFile psiFile, Editor editor, T literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, UExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
        Project project = psiFile.getProject();
        propertyCreationHandler.createProperty(project, propertiesFiles, key, value, parameters);
        try {
            this.doReplacement(psiFile, editor, literalExpression, i18nizedText);
        }
        catch (IncorrectOperationException e) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)JavaI18nBundle.message("inspection.i18n.expression.is.invalid.error.message", new Object[0]), (String)JavaI18nBundle.message("inspection.error.dialog.title", new Object[0])));
        }
    }

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AbstractI18nizeQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            AbstractI18nizeQuickFix.$$$reportNull$$$0(1);
        }
        this.doFix(descriptor, project);
    }

    protected abstract void doReplacement(@NotNull PsiFile var1, Editor var2, T var3, String var4) throws IncorrectOperationException;

    protected static void doDocumentReplacement(@NotNull PsiFile psiFile, UElement literalExpression, String i18nizedText, Document document, @Nullable UastCodeGenerationPlugin generationPlugin) {
        PsiElement psi;
        if (psiFile == null) {
            AbstractI18nizeQuickFix.$$$reportNull$$$0(2);
        }
        if ((psi = literalExpression.getSourcePsi()) == null) {
            return;
        }
        Language language = psi.getLanguage();
        int startOffset = psi.getTextRange().getStartOffset();
        document.replaceString(startOffset, psi.getTextRange().getEndOffset(), (CharSequence)i18nizedText);
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document);
        if (generationPlugin == null) {
            return;
        }
        PsiElement notShortenPsi = CodeInsightUtilCore.findElementInRange((PsiFile)psiFile, (int)startOffset, (int)(startOffset + i18nizedText.length()), PsiElement.class, (Language)language);
        AbstractI18nizeQuickFix.shortenReferences(notShortenPsi, generationPlugin);
    }

    private static void shortenReferences(@Nullable PsiElement element, @NotNull UastCodeGenerationPlugin generationPlugin) {
        UElement uElement;
        if (generationPlugin == null) {
            AbstractI18nizeQuickFix.$$$reportNull$$$0(3);
        }
        if ((uElement = UastContextKt.toUElement((PsiElement)element)) == null) {
            return;
        }
        generationPlugin.replace(uElement, uElement, UElement.class);
    }

    @NotNull
    protected I18nizeQuickFixDialog.DialogCustomization getCustomization(String value) {
        return new I18nizeQuickFixDialog.DialogCustomization(null, true, false, null, AbstractI18nizeQuickFix.getSuggestedName(value, this.myInfo));
    }

    private void doFix(ProblemDescriptor descriptor, Project project) {
        PsiElement psi = descriptor.getPsiElement();
        PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
        if (!JavaI18nizeQuickFixDialog.isAvailable(psiFile)) {
            return;
        }
        UExpression uast = this.getEnclosingLiteral(psiFile, PsiEditorUtil.findEditor((PsiElement)psiFile));
        JavaI18nizeQuickFixDialog<UExpression> dialog = this.createDialog(project, psiFile, uast);
        if (!dialog.showAndGet()) {
            return;
        }
        Collection propertiesFiles = dialog.getAllPropertiesFiles();
        if (!FileModificationService.getInstance().preparePsiElementForWrite(psi)) {
            return;
        }
        for (PropertiesFile file : propertiesFiles) {
            if (file.findPropertyByKey(dialog.getKey()) != null || FileModificationService.getInstance().prepareFileForWrite(file.getContainingFile())) continue;
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                this.performI18nization(psiFile, PsiEditorUtil.findEditor((PsiElement)psiFile), dialog.getLiteralExpression(), propertiesFiles, dialog.getKey(), dialog.getValue(), dialog.getI18nizedText(), dialog.getParameters(), dialog.getPropertyCreationHandler());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), PropertiesBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
    }

    protected abstract JavaI18nizeQuickFixDialog<T> createDialog(Project var1, PsiFile var2, @NotNull T var3);

    protected static String getSuggestedName(String value, NlsInfo.Localized info) {
        Object prefix = info.getPrefix();
        Object suffix = info.getSuffix();
        if (((String)prefix).isEmpty() && ((String)suffix).isEmpty()) {
            return null;
        }
        if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + ".";
        }
        if (!((String)suffix).isEmpty()) {
            suffix = "." + (String)suffix;
        }
        String payload = I18nizeQuickFixDialog.generateDefaultPropertyKey((String)value);
        payload = Stream.of(payload.split("\\.")).filter(s -> !s.matches("\\d+") && !AUXILIARY_WORDS.contains(s)).collect(Collectors.joining("."));
        return (String)prefix + payload + (String)suffix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationPlugin";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/i18n/AbstractI18nizeQuickFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doDocumentReplacement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shortenReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

