/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0000\u001a\u001c\u0010\u0007\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u0012"}, d2={"getLiquibasePlaceHolderRanges", "", "Lcom/intellij/openapi/util/TextRange;", "psiElement", "Lcom/intellij/psi/PsiElement;", "isInLiquibaseXmlChangelog", "", "isUnderDbChangelogDir", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentDirectory", "Lcom/intellij/psi/PsiDirectory;", "formatPropertyValue", "", "value", "dbms", "dirName", "parentDirName", "intellij.liquibase"})
@SourceDebugExtension(value={"SMAP\nLiquibaseUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseUtil.kt\ncom/intellij/liquibase/LiquibaseUtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,53:1\n19#2:54\n*S KotlinDebug\n*F\n+ 1 LiquibaseUtil.kt\ncom/intellij/liquibase/LiquibaseUtilKt\n*L\n19#1:54\n*E\n"})
public final class LiquibaseUtilKt {
    @NotNull
    public static final Set<TextRange> getLiquibasePlaceHolderRanges(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)psiElement.getText(), (String)"${", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        return set;
    }

    public static final boolean isInLiquibaseXmlChangelog(@NotNull PsiElement psiElement) {
        XmlFile xmlFile;
        XmlFile xmlFile2;
        XmlTag rootTag;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile $this$asSafely$iv = psiElement.getContainingFile();
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlTag xmlTag = rootTag = (xmlFile2 = (xmlFile = (XmlFile)psiFile)) != null && (xmlFile2 = xmlFile2.getDocument()) != null ? xmlFile2.getRootTag() : null;
        return Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"databaseChangeLog");
    }

    public static final boolean isUnderDbChangelogDir(@NotNull VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        VirtualFile vFile = currentFile;
        while (vFile.getParent() != null) {
            if (LiquibaseUtilKt.isUnderDbChangelogDir(vFile.getName(), vFile.getParent().getName())) {
                return true;
            }
            vFile = vFile.getParent();
        }
        return false;
    }

    public static final boolean isUnderDbChangelogDir(@Nullable PsiDirectory currentDirectory) {
        if (currentDirectory == null) {
            return false;
        }
        for (PsiDirectory directory = currentDirectory; directory != null && directory.getParentDirectory() != null; directory = directory.getParentDirectory()) {
            PsiDirectory psiDirectory = directory.getParentDirectory();
            if (!LiquibaseUtilKt.isUnderDbChangelogDir(directory.getName(), psiDirectory != null ? psiDirectory.getName() : null)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final String formatPropertyValue(@NotNull String value, @Nullable String dbms) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = dbms;
        return charSequence == null || charSequence.length() == 0 ? value : value + " (" + dbms + ")";
    }

    private static final boolean isUnderDbChangelogDir(String dirName, String parentDirName) {
        return Intrinsics.areEqual((Object)dirName, (Object)"changelog") && Intrinsics.areEqual((Object)parentDirName, (Object)"db");
    }
}

