/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.action;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.liquibase.action.LiquibaseUpdateListener;
import com.intellij.liquibase.common.LiquibaseUpdateProcess;
import com.intellij.liquibase.common.LiquibaseUpdateResult;
import com.intellij.liquibase.common.action.LiquibaseUpdateSuccessfulFilter;
import com.intellij.liquibase.common.action.filter.LiquibaseChangeSetFilter;
import com.intellij.liquibase.common.config.LogLevel;
import com.intellij.liquibase.common.gui.JpaRunContentExecutor;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import liquibase.ext.intellij.configuration.IdeaConfigurationValueProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0096@\u00a2\u0006\u0002\u0010*R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\n\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006+"}, d2={"Lcom/intellij/liquibase/action/JpaLiquibaseUpdateProcess;", "Lcom/intellij/liquibase/common/LiquibaseUpdateProcess;", "project", "Lcom/intellij/openapi/project/Project;", "myChangeLog", "Lcom/intellij/psi/PsiFile;", "dataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "contexts", "", "labels", "logLevel", "Lcom/intellij/liquibase/common/config/LogLevel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/liquibase/common/config/LogLevel;)V", "getDataStore", "()Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "getContexts", "()Ljava/lang/String;", "getLabels", "getLogLevel", "()Lcom/intellij/liquibase/common/config/LogLevel;", "properties", "", "getProperties", "()Ljava/util/Map;", "changeLogFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChangeLogFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "getDbProperties", "()Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "executeCommandLine", "Lcom/intellij/liquibase/common/LiquibaseUpdateResult;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.liquibase"})
final class JpaLiquibaseUpdateProcess
extends LiquibaseUpdateProcess {
    @NotNull
    private final AbstractRdbmsStore dataStore;
    @Nullable
    private final String contexts;
    @Nullable
    private final String labels;
    @Nullable
    private final LogLevel logLevel;
    @NotNull
    private final VirtualFile changeLogFile;
    @NotNull
    private final Module module;

    public JpaLiquibaseUpdateProcess(@NotNull Project project, @NotNull PsiFile myChangeLog, @NotNull AbstractRdbmsStore dataStore, @Nullable String contexts, @Nullable String labels, @Nullable LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myChangeLog, (String)"myChangeLog");
        Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
        super(project);
        this.dataStore = dataStore;
        this.contexts = contexts;
        this.labels = labels;
        this.logLevel = logLevel;
        VirtualFile virtualFile = myChangeLog.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        this.changeLogFile = virtualFile;
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)myChangeLog);
        Intrinsics.checkNotNull((Object)module);
        this.module = module;
    }

    @NotNull
    public final AbstractRdbmsStore getDataStore() {
        return this.dataStore;
    }

    @Override
    @Nullable
    public String getContexts() {
        return this.contexts;
    }

    @Override
    @Nullable
    public String getLabels() {
        return this.labels;
    }

    @Override
    @Nullable
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    @NotNull
    public Map<String, String> getProperties() {
        return MapsKt.plus(super.getProperties(), IdeaConfigurationValueProvider.Companion.getCONFIGS_MAP());
    }

    @Override
    @NotNull
    public VirtualFile getChangeLogFile() {
        return this.changeLogFile;
    }

    @Override
    @NotNull
    public DbProperties getDbProperties() {
        DbProperties dbProperties = DbProperties.prepareDbProperties((Project)this.getProject(), (DbProperties)this.dataStore.getDbProperties());
        Intrinsics.checkNotNullExpressionValue((Object)dbProperties, (String)"prepareDbProperties(...)");
        return dbProperties;
    }

    @Override
    @NotNull
    public Module getModule() {
        return this.module;
    }

    @Override
    @Nullable
    public Object executeCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull Continuation<? super LiquibaseUpdateResult> $completion) {
        ProcessHandler processHandler = (ProcessHandler)new KillableProcessHandler(commandLine);
        new JpaRunContentExecutor(this.getProject(), processHandler).withTitle(LiquibaseResourceBundle.message("tab.title.liquibase.update", new Object[0])).withProcessAdapter(new ProcessAdapter(this){
            final /* synthetic */ JpaLiquibaseUpdateProcess this$0;
            {
                this.this$0 = $receiver;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AbstractRdbmsStore dataStore = this.this$0.getDataStore();
                ((LiquibaseUpdateListener)this.this$0.getProject().getMessageBus().syncPublisher(LiquibaseUpdateListener.Companion.getTOPIC())).processTerminated(dataStore, event);
            }
        }).withIcon(AllIcons.Providers.Liquibase).withFilter(new LiquibaseUpdateSuccessfulFilter()).withFilter(new LiquibaseChangeSetFilter(this.getProject())).run();
        return new LiquibaseUpdateResult.Success("");
    }
}

