/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.codeInsight;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.liquibase.LiquibaseUtilKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.gist.GistAstMarker;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/codeInsight/LiquibaseXmlIconProvider;", "Lcom/intellij/ide/IconProvider;", "<init>", "()V", "XML_MARKER", "Lcom/intellij/util/gist/GistAstMarker;", "getIcon", "Ljavax/swing/Icon;", "element", "Lcom/intellij/psi/PsiElement;", "flags", "", "isDatabaseChangelog", "", "tree", "Lcom/intellij/lang/LighterAST;", "intellij.liquibase"})
public final class LiquibaseXmlIconProvider
extends IconProvider {
    @NotNull
    private final GistAstMarker XML_MARKER;

    public LiquibaseXmlIconProvider() {
        XmlFileType xmlFileType = XmlFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)xmlFileType, (String)"INSTANCE");
        this.XML_MARKER = new GistAstMarker((FileType)xmlFileType, "LIQUIBASE_XML", (Function1)new Function1<LighterAST, Boolean>((Object)this){

            public final Boolean invoke(LighterAST p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LiquibaseXmlIconProvider.access$isDatabaseChangelog((LiquibaseXmlIconProvider)((Object)this.receiver), p0);
            }
        });
    }

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof XmlFile)) {
            return null;
        }
        VirtualFile virtualFile = ((XmlFile)element).getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!LiquibaseUtilKt.isUnderDbChangelogDir(((XmlFile)element).getParent())) {
            return null;
        }
        if (this.XML_MARKER.accepts(((XmlFile)element).getProject(), virtualFile2)) {
            return AllIcons.Providers.Liquibase;
        }
        return null;
    }

    private final boolean isDatabaseChangelog(LighterAST tree) {
        for (LighterASTNode child : tree.getChildren(tree.getRoot())) {
            if (!Intrinsics.areEqual((Object)child.getTokenType(), (Object)XmlElementType.XML_DOCUMENT)) continue;
            for (LighterASTNode tag : tree.getChildren(child)) {
                if (!Intrinsics.areEqual((Object)tag.getTokenType(), (Object)XmlElementType.XML_TAG)) continue;
                for (LighterASTNode tagName : tree.getChildren(tag)) {
                    if (!Intrinsics.areEqual((Object)tagName.getTokenType(), (Object)XmlTokenType.XML_NAME) || !(tagName instanceof LighterASTTokenNode) || !Intrinsics.areEqual((Object)((LighterASTTokenNode)tagName).getText(), (Object)"databaseChangeLog")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isDatabaseChangelog(LiquibaseXmlIconProvider $this, LighterAST tree) {
        return $this.isDatabaseChangelog(tree);
    }
}

