/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.liquibase.ns.ImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.liquibase.ns.SpringImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import liquibase.ext.intellij.database.connection.IntellijConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/liquibase/common/IntellijDatabaseManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "changeSetAuthor", "", "getChangeSetAuthor", "()Ljava/lang/String;", "findEntityByTableName", "Lcom/intellij/jpa/jpb/model/model/Entity;", "intellijConnection", "Lliquibase/ext/intellij/database/connection/IntellijConnection;", "tableName", "collectEntitiesToProcess", "", "collectAllEntities", "getImplicitNameStrategy", "Lcom/intellij/jpa/jpb/model/liquibase/ns/ImplicitNamingStrategy;", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nIntellijDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijDatabaseManager.kt\ncom/intellij/liquibase/common/IntellijDatabaseManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1611#2,9:35\n1863#2:44\n1864#2:46\n1620#2:47\n1#3:45\n*S KotlinDebug\n*F\n+ 1 IntellijDatabaseManager.kt\ncom/intellij/liquibase/common/IntellijDatabaseManager\n*L\n17#1:35,9\n17#1:44\n17#1:46\n17#1:47\n17#1:45\n*E\n"})
public abstract class IntellijDatabaseManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public IntellijDatabaseManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public abstract String getChangeSetAuthor();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Entity findEntityByTableName(@NotNull IntellijConnection intellijConnection, @NotNull String tableName) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)intellijConnection, (String)"intellijConnection");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        EntitySearch entitySearch = EntitySearch.getInstance((Project)intellijConnection.getProject());
        Iterable iterable = this.collectAllEntities(intellijConnection);
        EntitySearch entitySearch2 = entitySearch;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Entity it = (Entity)element$iv$iv;
            boolean bl2 = false;
            if (it.getPsiClass() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        PsiClass psiClass = entitySearch2.findByTableName((Collection)((List)destination$iv$iv), tableName);
        if (psiClass == null) {
            return null;
        }
        PsiClass foundEntityClass = psiClass;
        return (Entity)EntityPsi.getInstance((PsiClass)foundEntityClass);
    }

    @NotNull
    public abstract List<Entity> collectEntitiesToProcess(@NotNull IntellijConnection var1);

    @NotNull
    public abstract List<Entity> collectAllEntities(@NotNull IntellijConnection var1);

    @NotNull
    public ImplicitNamingStrategy getImplicitNameStrategy() {
        return (ImplicitNamingStrategy)SpringImplicitNamingStrategy.Companion.getInstance(this.project);
    }

    @JvmStatic
    @NotNull
    public static final IntellijDatabaseManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/common/IntellijDatabaseManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/liquibase/common/IntellijDatabaseManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntellijDatabaseManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(IntellijDatabaseManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (IntellijDatabaseManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

