/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.liquibase.common.AbstractLiquibaseGenerator;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/liquibase/common/JpaLiquibaseGenerator;", "Lcom/intellij/liquibase/common/AbstractLiquibaseGenerator;", "project", "Lcom/intellij/openapi/project/Project;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "context", "Lcom/intellij/liquibase/common/LiquibaseGenerationContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;Lcom/intellij/liquibase/common/LiquibaseGenerationContext;)V", "getEnumAttributeLength", "", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "(Lcom/intellij/jpa/jpb/model/model/EntityAttribute;)Ljava/lang/Integer;", "generateConstraintName", "", "prefix", "tableName", "suffix", "columnNames", "", "intellij.liquibase.common"})
public final class JpaLiquibaseGenerator
extends AbstractLiquibaseGenerator {
    public JpaLiquibaseGenerator(@NotNull Project project, @NotNull DbType dbType, @NotNull LiquibaseGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(project, dbType, context);
    }

    @Override
    @Nullable
    public Integer getEnumAttributeLength(@NotNull EntityAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (attribute.getEnumType() == EntityAttribute.EnumType.STRING) {
            Integer n = attribute.getProcessedLength();
            return n != null ? n : 255;
        }
        return null;
    }

    @Override
    @NotNull
    public String generateConstraintName(@Nullable String prefix, @NotNull String tableName, @Nullable String suffix, @Nullable Collection<String> columnNames) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Function converter = JpaPluginProjectConfig.Companion.getState((Project)project).indexCase.getConverter();
        Object r = converter.apply(super.generateConstraintName(prefix, tableName, suffix, columnNames));
        Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
        return (String)r;
    }
}

