/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.model.audit.EnversProperties;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.service.EnversService;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.IntellijDatabaseManager;
import com.intellij.liquibase.common.JpaLiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.config.DiffGenerationConfig;
import com.intellij.liquibase.common.gui.DiffScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.ext.intellij.database.connection.IntellijConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/liquibase/common/JpbIntellijDatabaseManager;", "Lcom/intellij/liquibase/common/IntellijDatabaseManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "enversService", "Lcom/intellij/jpa/jpb/model/service/EnversService;", "changeSetAuthor", "", "getChangeSetAuthor", "()Ljava/lang/String;", "findEntityByTableName", "Lcom/intellij/jpa/jpb/model/model/Entity;", "intellijConnection", "Lliquibase/ext/intellij/database/connection/IntellijConnection;", "tableName", "collectEntitiesToProcess", "", "collectAllEntities", "generationContext", "Lcom/intellij/liquibase/common/JpaLiquibaseGenerationContext;", "diffScope", "Lcom/intellij/liquibase/common/gui/DiffScope;", "collectEntities", "persistenceUnitName", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nJpbIntellijDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpbIntellijDatabaseManager.kt\ncom/intellij/liquibase/common/JpbIntellijDatabaseManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n1#2:102\n1#2:116\n295#3,2:103\n1611#3,9:106\n1863#3:115\n1864#3:117\n1620#3:118\n774#3:119\n865#3,2:120\n1557#3:122\n1628#3,3:123\n14#4:105\n*S KotlinDebug\n*F\n+ 1 JpbIntellijDatabaseManager.kt\ncom/intellij/liquibase/common/JpbIntellijDatabaseManager\n*L\n91#1:116\n83#1:103,2\n91#1:106,9\n91#1:115\n91#1:117\n91#1:118\n92#1:119\n92#1:120,2\n93#1:122\n93#1:123,3\n87#1:105\n*E\n"})
public final class JpbIntellijDatabaseManager
extends IntellijDatabaseManager {
    @NotNull
    private final EnversService enversService;

    public JpbIntellijDatabaseManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.enversService = EnversService.Companion.getInstance(project);
    }

    @Override
    @Nullable
    public String getChangeSetAuthor() {
        return DiffGenerationConfig.Companion.getInstance(this.getProject()).getLiquibaseAuthor();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Entity findEntityByTableName(@NotNull IntellijConnection intellijConnection, @NotNull String tableName) {
        AuditEntity auditEntity;
        Intrinsics.checkNotNullParameter((Object)intellijConnection, (String)"intellijConnection");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Entity entity = super.findEntityByTableName(intellijConnection, tableName);
        if (entity != null) return entity;
        if (!JpaUtils.isHibernateEnversProject((Project)this.getProject(), null)) {
            return entity;
        }
        Entity revisionEntity = this.enversService.getRevisionEntity();
        if (StringsKt.equals((String)tableName, (String)revisionEntity.getTable(), (boolean)true)) {
            return revisionEntity;
        }
        EnversProperties enversProps = this.enversService.getActualEnversProperties();
        if (StringsKt.startsWith$default((String)tableName, (String)enversProps.getAuditTablePrefix(), (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)tableName, (String)enversProps.getAuditTableSuffix(), (boolean)false, (int)2, null)) {
            AuditEntity auditEntity2;
            Entity entity2 = super.findEntityByTableName(intellijConnection, StringsKt.removeSurrounding((String)tableName, (CharSequence)enversProps.getAuditTablePrefix(), (CharSequence)enversProps.getAuditTableSuffix()));
            if (entity2 != null) {
                Entity it = entity2;
                boolean bl = false;
                EntityPsi entityPsi = it instanceof EntityPsi ? (EntityPsi)it : null;
                if (entityPsi != null) {
                    it = entityPsi;
                    boolean bl2 = false;
                    auditEntity2 = AuditEntity.Companion.getInstance((EntityPsi)it);
                    return (Entity)auditEntity2;
                }
            }
            auditEntity2 = null;
            return (Entity)auditEntity2;
        }
        PsiClass psiClass = EntitySearch.getInstance((Project)this.getProject()).findByAuditTableName(tableName);
        if (psiClass != null) {
            PsiClass it = psiClass;
            boolean bl = false;
            EntityPsi entityPsi = EntityPsi.getInstance((PsiClass)it);
            Intrinsics.checkNotNullExpressionValue((Object)entityPsi, (String)"getInstance(...)");
            auditEntity = AuditEntity.Companion.getInstance(entityPsi);
            return (Entity)auditEntity;
        }
        auditEntity = null;
        return (Entity)auditEntity;
    }

    @Override
    @NotNull
    public List<Entity> collectEntitiesToProcess(@NotNull IntellijConnection intellijConnection) {
        Intrinsics.checkNotNullParameter((Object)intellijConnection, (String)"intellijConnection");
        LiquibaseGenerationContext liquibaseGenerationContext = intellijConnection.getGenerationContext();
        Intrinsics.checkNotNull((Object)liquibaseGenerationContext, (String)"null cannot be cast to non-null type com.intellij.liquibase.common.JpaLiquibaseGenerationContext");
        JpaLiquibaseGenerationContext generationContext = (JpaLiquibaseGenerationContext)liquibaseGenerationContext;
        return this.collectEntitiesToProcess(generationContext, generationContext.getDiffScope());
    }

    @Override
    @NotNull
    public List<Entity> collectAllEntities(@NotNull IntellijConnection intellijConnection) {
        Intrinsics.checkNotNullParameter((Object)intellijConnection, (String)"intellijConnection");
        LiquibaseGenerationContext liquibaseGenerationContext = intellijConnection.getGenerationContext();
        Intrinsics.checkNotNull((Object)liquibaseGenerationContext, (String)"null cannot be cast to non-null type com.intellij.liquibase.common.JpaLiquibaseGenerationContext");
        JpaLiquibaseGenerationContext generationContext = (JpaLiquibaseGenerationContext)liquibaseGenerationContext;
        return this.collectEntitiesToProcess(generationContext, DiffScope.AllPlaces);
    }

    @NotNull
    public final List<Entity> collectEntitiesToProcess(@NotNull JpaLiquibaseGenerationContext generationContext, @NotNull DiffScope diffScope) {
        Intrinsics.checkNotNullParameter((Object)generationContext, (String)"generationContext");
        Intrinsics.checkNotNullParameter((Object)((Object)diffScope), (String)"diffScope");
        String persistenceUnitName = generationContext.getPersistenceUnitName();
        CacheKeyStore cacheKeyStore = CacheKeyStore.Companion.getInstance(this.getProject());
        String string = persistenceUnitName;
        if (string == null) {
            string = "all_persistence_units";
        }
        Key key = cacheKeyStore.getKey((Object)(string + " - " + diffScope.getId()));
        Object object = CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this.getProject(), key, () -> JpbIntellijDatabaseManager.collectEntitiesToProcess$lambda$3(this, persistenceUnitName, diffScope), false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> collectEntities(String persistenceUnitName, DiffScope diffScope) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PsiClass it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object v1;
        GlobalSearchScope searchScope;
        block5: {
            searchScope = diffScope.toSearchScope(this.getProject());
            OrmUnitsProvider ormUnitsProvider = OrmUnitsProvider.Companion.getForProject(this.getProject());
            Intrinsics.checkNotNull((Object)ormUnitsProvider);
            OrmUnitsProvider unitsProvider = ormUnitsProvider;
            Iterable $this$firstOrNull$iv = unitsProvider.getUnits(this.getProject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OrmUnit it2 = (OrmUnit)element$iv;
                boolean bl = false;
                if (!(persistenceUnitName == null || Intrinsics.areEqual((Object)persistenceUnitName, (Object)it2.getName()))) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        OrmUnit persistenceUnit = v1;
        if (persistenceUnit == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JpbIntellijDatabaseManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Persistence unit '" + persistenceUnitName + "' not found");
            return CollectionsKt.emptyList();
        }
        Iterable $i$f$logger = persistenceUnit.getEntities();
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            OrmEntity it3 = (OrmEntity)element$iv$iv;
            boolean bl2 = false;
            SmartPsiElementPointer smartPsiElementPointer = it3.getClassPsiPointer();
            if ((smartPsiElementPointer != null ? (PsiClass)smartPsiElementPointer.getElement() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PsiClass)element$iv$iv;
            boolean bl = false;
            if (!PsiSearchScopeUtil.isInScope((GlobalSearchScope)searchScope, (PsiElement)((PsiElement)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PsiClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EntityPsi.getInstance((PsiClass)it));
        }
        return (List)destination$iv$iv;
    }

    private static final CachedValueProvider.Result collectEntitiesToProcess$lambda$3(JpbIntellijDatabaseManager this$0, String $persistenceUnitName, DiffScope $diffScope) {
        List list;
        List entities = this$0.collectEntities($persistenceUnitName, $diffScope);
        if (JpaUtils.isHibernateEnversProject((Project)this$0.getProject(), null)) {
            List auditEntities = EnversService.Companion.getInstance(this$0.getProject()).getAuditEntities(entities);
            list = CollectionsKt.plus((Collection)entities, (Iterable)auditEntities);
        } else {
            list = entities;
        }
        List allEntities = list;
        Object[] objectArray = new Object[]{PsiModificationTracker.getInstance((Project)this$0.getProject())};
        return CachedValueProvider.Result.create((Object)allEntities, (Object[])objectArray);
    }
}

