/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.json.psi.JsonFile;
import com.intellij.liquibase.common.LiquibaseCreatorKt;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/liquibase/common/LiquibaseCreator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createDbChangeLogFile", "Lcom/intellij/psi/PsiFile;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "fileName", "", "fileType", "Lcom/intellij/liquibase/common/LiquibaseFileType;", "changeSource", "quotingStrategy", "Lcom/intellij/liquibase/common/LiquibaseCreator$ObjectQuotingStrategy;", "Companion", "ObjectQuotingStrategy", "intellij.liquibase.common"})
public final class LiquibaseCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public LiquibaseCreator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final PsiFile createDbChangeLogFile(@NotNull PsiDirectory targetDirectory, @NotNull String fileName, @NotNull LiquibaseFileType fileType, @NotNull String changeSource, @NotNull ObjectQuotingStrategy quotingStrategy) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)changeSource, (String)"changeSource");
        Intrinsics.checkNotNullParameter((Object)((Object)quotingStrategy), (String)"quotingStrategy");
        String templateName = switch (WhenMappings.$EnumSwitchMapping$0[fileType.ordinal()]) {
            case 1 -> "com.intellij.jpb.JpaLiquibaseChangeLog.yaml";
            case 2 -> "com.intellij.jpb.JpaLiquibaseChangeLog.json";
            case 3 -> "com.intellij.jpb.JpaLiquibaseChangeLog.sql";
            case 4 -> "com.intellij.jpb.JpaLiquibaseChangeLog.xml";
            default -> throw new NoWhenBranchMatchedException();
        };
        Pair<Properties, FileTemplate> pair = LiquibaseCreatorKt.getJ2EETemplateWithProps(this.project, changeSource, quotingStrategy, templateName);
        Properties props = (Properties)pair.component1();
        FileTemplate template = (FileTemplate)pair.component2();
        try {
            PsiFile psiFile2;
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)props, (PsiDirectory)targetDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement element = psiElement;
            switch (WhenMappings.$EnumSwitchMapping$0[fileType.ordinal()]) {
                case 1: {
                    PsiFile psiFile3 = element.getContainingFile();
                    psiFile2 = psiFile3;
                    Intrinsics.checkNotNull((Object)psiFile3, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
                    break;
                }
                case 2: {
                    PsiFile psiFile4 = element.getContainingFile();
                    Intrinsics.checkNotNull((Object)psiFile4, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonFile");
                    psiFile2 = (PsiFile)((JsonFile)psiFile4);
                    break;
                }
                case 3: {
                    PsiFile psiFile5 = element.getContainingFile();
                    psiFile2 = psiFile5;
                    Intrinsics.checkNotNull((Object)psiFile5, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
                    break;
                }
                case 4: {
                    PsiFile psiFile6 = element.getContainingFile();
                    Intrinsics.checkNotNull((Object)psiFile6, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
                    psiFile2 = (PsiFile)((XmlFile)psiFile6);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            psiFile = psiFile2;
        }
        catch (Exception e) {
            new ExceptionEvent((Object)("Exception while trying to create liquibase changelog file: '" + fileName + "'"), (Throwable)e).post(this.project);
            psiFile = null;
        }
        return psiFile;
    }

    public static /* synthetic */ PsiFile createDbChangeLogFile$default(LiquibaseCreator liquibaseCreator, PsiDirectory psiDirectory, String string, LiquibaseFileType liquibaseFileType, String string2, ObjectQuotingStrategy objectQuotingStrategy, int n, Object object) {
        if ((n & 4) != 0) {
            liquibaseFileType = LiquibaseFileType.XML;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            objectQuotingStrategy = ObjectQuotingStrategy.LEGACY;
        }
        return liquibaseCreator.createDbChangeLogFile(psiDirectory, string, liquibaseFileType, string2, objectQuotingStrategy);
    }

    @JvmStatic
    @NotNull
    public static final LiquibaseCreator getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/common/LiquibaseCreator$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/liquibase/common/LiquibaseCreator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LiquibaseCreator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LiquibaseCreator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LiquibaseCreator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/liquibase/common/LiquibaseCreator$ObjectQuotingStrategy;", "", "<init>", "(Ljava/lang/String;I)V", "LEGACY", "QUOTE_ONLY_RESERVED_WORDS", "intellij.liquibase.common"})
    public static final class ObjectQuotingStrategy
    extends Enum<ObjectQuotingStrategy> {
        public static final /* enum */ ObjectQuotingStrategy LEGACY = new ObjectQuotingStrategy();
        public static final /* enum */ ObjectQuotingStrategy QUOTE_ONLY_RESERVED_WORDS = new ObjectQuotingStrategy();
        private static final /* synthetic */ ObjectQuotingStrategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ObjectQuotingStrategy[] values() {
            return (ObjectQuotingStrategy[])$VALUES.clone();
        }

        public static ObjectQuotingStrategy valueOf(String value) {
            return Enum.valueOf(ObjectQuotingStrategy.class, value);
        }

        @NotNull
        public static EnumEntries<ObjectQuotingStrategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = objectQuotingStrategyArray = new ObjectQuotingStrategy[]{ObjectQuotingStrategy.LEGACY, ObjectQuotingStrategy.QUOTE_ONLY_RESERVED_WORDS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LiquibaseFileType.values().length];
            try {
                nArray[LiquibaseFileType.YAML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiquibaseFileType.JSON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiquibaseFileType.SQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LiquibaseFileType.XML.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

