/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.core.model.dbprop.OfflineDbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.util.CanceledProgressAction;
import com.intellij.jpa.jpb.model.core.util.HProgressManager;
import com.intellij.liquibase.common.JpaLiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseCommandManager;
import com.intellij.liquibase.common.LiquibaseCommandManagerKt;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseGenerationContextRegistry;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import liquibase.database.Database;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/liquibase/common/LiquibaseGenerateModelSnapshotHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbmsType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "outputFile", "", "persistenceUnit", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;Ljava/lang/String;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDbmsType", "()Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "getOutputFile", "()Ljava/lang/String;", "getPersistenceUnit", "testMode", "", "liquibaseCommandManager", "Lcom/intellij/liquibase/common/LiquibaseCommandManager;", "run", "", "createDatabase", "Lliquibase/database/Database;", "context", "Lcom/intellij/liquibase/common/LiquibaseGenerationContext;", "doRun", "Lcom/intellij/liquibase/common/JpaLiquibaseGenerationContext;", "Companion", "intellij.liquibase.common"})
public final class LiquibaseGenerateModelSnapshotHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DbType dbmsType;
    @NotNull
    private final String outputFile;
    @Nullable
    private final String persistenceUnit;
    private final boolean testMode;
    @NotNull
    private final LiquibaseCommandManager liquibaseCommandManager;

    public LiquibaseGenerateModelSnapshotHandler(@NotNull Project project, @NotNull DbType dbmsType, @NotNull String outputFile, @Nullable String persistenceUnit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbmsType, (String)"dbmsType");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        this.project = project;
        this.dbmsType = dbmsType;
        this.outputFile = outputFile;
        this.persistenceUnit = persistenceUnit;
        this.testMode = ApplicationManager.getApplication().isUnitTestMode();
        this.liquibaseCommandManager = LiquibaseCommandManager.Companion.getInstance(this.project);
    }

    public /* synthetic */ LiquibaseGenerateModelSnapshotHandler(Project project, DbType dbType, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(project, dbType, string, string2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DbType getDbmsType() {
        return this.dbmsType;
    }

    @NotNull
    public final String getOutputFile() {
        return this.outputFile;
    }

    @Nullable
    public final String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        LiquibaseGenerationContextRegistry registry = LiquibaseGenerationContextRegistry.Companion.getInstance();
        JpaLiquibaseGenerationContext context = new JpaLiquibaseGenerationContext(this.project, this.dbmsType, CollectionsKt.emptyList(), this.persistenceUnit, null, new String[0], 16, null);
        registry.registerContext(context);
        try {
            if (this.testMode) {
                this.doRun(context);
            } else {
                HProgressManager.Companion.getInstance(this.project).runProcessWithCanceledProgressSynchronously((CanceledProgressAction)new CanceledProgressAction<Unit>(this, context){
                    private final String progressTitle;
                    final /* synthetic */ LiquibaseGenerateModelSnapshotHandler this$0;
                    final /* synthetic */ JpaLiquibaseGenerationContext $context;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        String string = LiquibaseResourceBundle.message("generate.liquibase.snapshot", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.progressTitle = string;
                    }

                    public String getProgressTitle() {
                        return this.progressTitle;
                    }

                    public void compute() {
                        LiquibaseGenerateModelSnapshotHandler.access$doRun(this.this$0, this.$context);
                    }
                });
            }
        }
        finally {
            registry.unregisterContext(context);
        }
    }

    private final Database createDatabase(LiquibaseGenerationContext context) {
        String referenceUrl = "jpab?generationContext=" + context.getId();
        return LiquibaseCommandManager.createDatabase$default(this.liquibaseCommandManager, this.liquibaseCommandManager.createFileOpener(null, null), referenceUrl, null, null, null, context.getMainDbType(), false, 64, null);
    }

    private final void doRun(JpaLiquibaseGenerationContext context) {
        ActionsKt.runReadAction(() -> LiquibaseGenerateModelSnapshotHandler.doRun$lambda$1(this, context));
    }

    private static final Unit doRun$lambda$1$lambda$0(LiquibaseGenerateModelSnapshotHandler this$0, JpaLiquibaseGenerationContext $context) {
        Database intellijDatabase = this$0.createDatabase($context);
        this$0.liquibaseCommandManager.generateSnapshot(this$0.outputFile, intellijDatabase);
        return Unit.INSTANCE;
    }

    private static final Unit doRun$lambda$1(LiquibaseGenerateModelSnapshotHandler this$0, JpaLiquibaseGenerationContext $context) {
        LiquibaseCommandManagerKt.runWithPluginClassLoader(() -> LiquibaseGenerateModelSnapshotHandler.doRun$lambda$1$lambda$0(this$0, $context));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$doRun(LiquibaseGenerateModelSnapshotHandler $this, JpaLiquibaseGenerationContext context) {
        $this.doRun(context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/liquibase/common/LiquibaseGenerateModelSnapshotHandler$Companion;", "", "<init>", "()V", "fromOfflineDbProperties", "Lcom/intellij/liquibase/common/LiquibaseGenerateModelSnapshotHandler;", "project", "Lcom/intellij/openapi/project/Project;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/OfflineDbProperties;", "outputFile", "", "readProperties", "Ljava/util/Properties;", "string", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiquibaseGenerateModelSnapshotHandler fromOfflineDbProperties(@NotNull Project project, @NotNull OfflineDbProperties dbProperties, @NotNull String outputFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            String string = dbProperties.getUrl();
            Intrinsics.checkNotNull((Object)string);
            String params = StringsKt.removePrefix((String)string, (CharSequence)"jpab?");
            Properties properties2 = this.readProperties(params);
            String persistenceUnit = properties2.getProperty("persistenceUnit");
            DbType dbType = dbProperties.getType();
            Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
            return new LiquibaseGenerateModelSnapshotHandler(project, dbType, outputFile, persistenceUnit);
        }

        private final Properties readProperties(String string) {
            String queryString = string;
            Properties properties2 = new Properties();
            CharSequence charSequence = queryString;
            Regex regex = new Regex("&");
            String string2 = System.getProperty("line.separator");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            String string3 = string2;
            queryString = regex.replace(charSequence, string3);
            try {
                queryString = URLDecoder.decode(queryString, "UTF-8");
                properties2.load(new StringReader(queryString));
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Failed to read properties from url", ioe);
            }
            return properties2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

