/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.liquibase.common.AbstractLiquibaseGenerator;
import com.intellij.liquibase.common.JavaType;
import com.intellij.liquibase.common.LiquibaseProperty;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.MappingType;
import com.intellij.liquibase.common.ddl.DbMappingSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0005J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'J\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020#J\u000e\u0010.\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\"J\u000e\u0010/\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0005J)\u00100\u001a\u0004\u0018\u00010\"2\u0006\u00101\u001a\u0002022\u0006\u0010%\u001a\u00020\u00052\b\u00103\u001a\u0004\u0018\u00010\u000fH&\u00a2\u0006\u0002\u00104J)\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u0002022\u0006\u0010%\u001a\u00020\u00052\b\u00103\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u0005H$J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\"H\u0016J\u0012\u0010>\u001a\u00020<2\b\u0010?\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010@\u001a\u00020<2\u0006\u0010A\u001a\u00020BH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/liquibase/common/LiquibaseGenerationContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "mainDbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "supportedDbTypes", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getMainDbType", "()Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "identifierMaxLength", "", "getIdentifierMaxLength", "()I", "mappingSettings", "", "Lcom/intellij/liquibase/common/ddl/DbMappingSettings;", "getSupportedDbTypes", "()Ljava/util/List;", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "generators", "Lcom/intellij/liquibase/common/AbstractLiquibaseGenerator;", "properties", "Ljava/util/LinkedHashSet;", "Lcom/intellij/liquibase/common/LiquibaseProperty;", "types", "", "", "Lcom/intellij/liquibase/common/JavaType;", "getGenerator", "dbType", "getLiquibaseProperties", "", "putLiquibaseProperty", "", "key", "value", "registerType", "javaType", "getType", "getMappingSettings", "getOverriddenSqlType", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "jdbcTypeCode", "(Lcom/intellij/jpa/jpb/model/model/Datatype;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;Ljava/lang/Integer;)Ljava/lang/String;", "getSqlTypeParameter", "Lcom/intellij/liquibase/common/config/MappingType$SqlTypeParameter;", "completedAttrType", "(Lcom/intellij/jpa/jpb/model/model/Datatype;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;Ljava/lang/Integer;)Lcom/intellij/liquibase/common/config/MappingType$SqlTypeParameter;", "createGenerator", "it", "isIgnoreTableName", "", "tableName", "isIgnoreName", "name", "isIgnoreDatabaseObject", "dbObject", "Lliquibase/structure/DatabaseObject;", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nLiquibaseGenerationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseGenerationContext.kt\ncom/intellij/liquibase/common/LiquibaseGenerationContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1755#2,3:106\n*S KotlinDebug\n*F\n+ 1 LiquibaseGenerationContext.kt\ncom/intellij/liquibase/common/LiquibaseGenerationContext\n*L\n78#1:106,3\n*E\n"})
public abstract class LiquibaseGenerationContext {
    @NotNull
    private final Project project;
    @NotNull
    private final DbType mainDbType;
    @NotNull
    private final Map<DbType, DbMappingSettings> mappingSettings;
    @NotNull
    private final List<DbType> supportedDbTypes;
    @NotNull
    private final UUID id;
    @NotNull
    private final Map<DbType, AbstractLiquibaseGenerator> generators;
    @NotNull
    private final LinkedHashSet<LiquibaseProperty> properties;
    @NotNull
    private final Map<String, JavaType> types;

    public LiquibaseGenerationContext(@NotNull Project project, @NotNull DbType mainDbType, @NotNull List<? extends DbType> supportedDbTypes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mainDbType, (String)"mainDbType");
        Intrinsics.checkNotNullParameter(supportedDbTypes, (String)"supportedDbTypes");
        this.project = project;
        this.mainDbType = mainDbType;
        Map map = FactoryMap.create(arg_0 -> LiquibaseGenerationContext.mappingSettings$lambda$1(arg_0 -> LiquibaseGenerationContext.mappingSettings$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"create(...)");
        this.mappingSettings = map;
        LiquibaseGenerationContext liquibaseGenerationContext = this;
        boolean bl = false;
        liquibaseGenerationContext.supportedDbTypes = supportedDbTypes.contains(DbType.Companion.getMainType(this.mainDbType)) ? supportedDbTypes : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)DbType.Companion.getMainType(this.mainDbType)), (Iterable)supportedDbTypes);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.id = uUID;
        Map map2 = FactoryMap.create(arg_0 -> LiquibaseGenerationContext.generators$lambda$4(arg_0 -> LiquibaseGenerationContext.generators$lambda$3(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"create(...)");
        this.generators = map2;
        this.properties = new LinkedHashSet();
        this.types = new LinkedHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DbType getMainDbType() {
        return this.mainDbType;
    }

    public int getIdentifierMaxLength() {
        Integer n = DatabaseMigrationConfig.Companion.getInstance(this.project).getState().getMaxIdentifierLength();
        return n != null ? n : -1;
    }

    @NotNull
    public final List<DbType> getSupportedDbTypes() {
        return this.supportedDbTypes;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final AbstractLiquibaseGenerator getGenerator(@NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        return (AbstractLiquibaseGenerator)MapsKt.getValue(this.generators, (Object)dbType);
    }

    @NotNull
    public final Set<LiquibaseProperty> getLiquibaseProperties() {
        return CollectionsKt.toSet((Iterable)this.properties);
    }

    public final void putLiquibaseProperty(@NotNull String key, @NotNull String value, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        Iterator iterator = this.properties.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            LiquibaseProperty property = (LiquibaseProperty)e;
            if (!Intrinsics.areEqual((Object)property.getName(), (Object)key) || !Intrinsics.areEqual((Object)property.getDbms(), (Object)DbType.Companion.getLiquibaseDbmsId(dbType))) continue;
            return;
        }
        this.properties.add(new LiquibaseProperty(key, value, DbType.Companion.getLiquibaseDbmsId(dbType)));
    }

    public final void registerType(@NotNull JavaType javaType) {
        Intrinsics.checkNotNullParameter((Object)javaType, (String)"javaType");
        this.types.put(javaType.getId(), javaType);
    }

    @NotNull
    public final JavaType getType(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (JavaType)MapsKt.getValue(this.types, (Object)id);
    }

    @NotNull
    public final DbMappingSettings getMappingSettings(@NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        return (DbMappingSettings)MapsKt.getValue(this.mappingSettings, (Object)dbType);
    }

    @Nullable
    public abstract String getOverriddenSqlType(@NotNull Datatype var1, @NotNull DbType var2, @Nullable Integer var3);

    @Nullable
    public MappingType.SqlTypeParameter getSqlTypeParameter(@NotNull Datatype completedAttrType, @NotNull DbType dbType, @Nullable Integer jdbcTypeCode) {
        Intrinsics.checkNotNullParameter((Object)completedAttrType, (String)"completedAttrType");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        return null;
    }

    @NotNull
    protected abstract AbstractLiquibaseGenerator createGenerator(@NotNull DbType var1);

    public boolean isIgnoreTableName(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return false;
    }

    public boolean isIgnoreName(@Nullable String name) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIgnoreDatabaseObject(@NotNull DatabaseObject dbObject) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dbObject, (String)"dbObject");
        if (this.isIgnoreName(dbObject.getName())) return true;
        List<Relation> list = LiquibaseUtils.getTables(dbObject);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTables(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Relation it = (Relation)element$iv;
            boolean bl2 = false;
            if (it == null) return true;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (this.isIgnoreTableName(string)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final DbMappingSettings mappingSettings$lambda$0(LiquibaseGenerationContext this$0, DbType it) {
        Intrinsics.checkNotNull((Object)it);
        return DbMappingSettings.Companion.getInstance(it, this$0.project);
    }

    private static final DbMappingSettings mappingSettings$lambda$1(Function1 $tmp0, Object p0) {
        return (DbMappingSettings)$tmp0.invoke(p0);
    }

    private static final AbstractLiquibaseGenerator generators$lambda$3(LiquibaseGenerationContext this$0, DbType it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.createGenerator(it);
    }

    private static final AbstractLiquibaseGenerator generators$lambda$4(Function1 $tmp0, Object p0) {
        return (AbstractLiquibaseGenerator)$tmp0.invoke(p0);
    }
}

