/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.core.es.BuildVersion;
import com.intellij.jpa.jpb.model.core.es.ExternalSystemInfo;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MysqlType;
import com.intellij.jpa.jpb.model.core.pg.PgKeepClassMembers;
import com.intellij.jpa.jpb.model.core.util.JpbVfsUtil;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.service.JpabReferenceManager;
import com.intellij.jpa.jpb.model.util.DiffHelper;
import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.liquibase.common.FormatterTemplate;
import com.intellij.liquibase.common.LiquibaseIntellijDiffGenerationHandler;
import com.intellij.liquibase.common.LiquibaseIntellijDiffGenerationHandlerFactory;
import com.intellij.liquibase.common.LiquibaseSearcher;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\tJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J)\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0019\"\u00020\r\u00a2\u0006\u0002\u0010\u001aJ7\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0019\"\u00020\r\u00a2\u0006\u0002\u0010\u001fJ7\u0010 \u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0019\"\u00020\rH\u0002\u00a2\u0006\u0002\u0010$J(\u0010%\u001a\u00020\r2\b\u0010&\u001a\u0004\u0018\u00010\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(2\b\b\u0002\u0010\u000e\u001a\u00020\tJ*\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\r2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\r2\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0(J\u0012\u0010-\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\tH\u0002J\u0014\u0010.\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u000e\u0010/\u001a\u0004\u0018\u000100*\u00020\u000bH\u0002J\u0010\u0010.\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u00101\u001a\u00020\r2\u0006\u00102\u001a\u0002002\u0006\u0010\u000e\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00064"}, d2={"Lcom/intellij/liquibase/common/LiquibaseHelper;", "Lcom/intellij/jpa/jpb/model/core/pg/PgKeepClassMembers;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isLiquibaseSupported", "", "module", "Lcom/intellij/openapi/module/Module;", "generateChangeLogDir", "", "isMainChangeLogTemplate", "generateChangeLogDirFromExistingRoot", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findExistingChangelogDir", "Lcom/intellij/psi/PsiDirectory;", "generateTableChangeLog", "Lcom/intellij/psi/xml/XmlTag;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "tableNames", "", "(Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;[Ljava/lang/String;)Lcom/intellij/psi/xml/XmlTag;", "isSuitableTableTag", "tag", "tagName", "tableAttrName", "(Lcom/intellij/psi/xml/XmlTag;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Z", "isSuitableSequenceTag", "sequenceNamesWithEntities", "", "Lcom/intellij/jpa/jpb/model/service/JpabReferenceManager$SequenceInfo;", "(Lcom/intellij/psi/xml/XmlTag;Ljava/util/List;[Ljava/lang/String;)Z", "generateChangeLogName", "dirPath", "existChangeLogNames", "", "createFormatterTemplate", "Lcom/intellij/liquibase/common/FormatterTemplate;", "content", "existFileNames", "completeChangeLogDirTemplate", "generateFirstChangeLogDirName", "findSourceRootsForChangelog", "Lcom/intellij/openapi/vfs/VirtualFile;", "createChangelogDirPath", "root", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nLiquibaseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseHelper.kt\ncom/intellij/liquibase/common/LiquibaseHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,196:1\n1381#2:197\n1469#2,5:198\n2632#2,3:210\n827#2:213\n855#2,2:214\n774#2:218\n865#2:219\n866#2:222\n1755#2,3:223\n1863#2,2:228\n1#3:203\n10072#4:204\n10494#4,5:205\n12574#4,2:216\n12574#4,2:220\n37#5,2:226\n*S KotlinDebug\n*F\n+ 1 LiquibaseHelper.kt\ncom/intellij/liquibase/common/LiquibaseHelper\n*L\n70#1:197\n70#1:198,5\n86#1:210,3\n91#1:213\n91#1:214,2\n120#1:218\n120#1:219\n120#1:222\n127#1:223,3\n101#1:228,2\n84#1:204\n84#1:205,5\n110#1:216,2\n125#1:220,2\n185#1:226,2\n*E\n"})
public final class LiquibaseHelper
implements PgKeepClassMembers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String INCREMENT_PATTERN = "$INCREMENT_LOCATION$";
    @NotNull
    public static final String SEMANTIC_VERSION_VAR_NAME = "semVer";

    public LiquibaseHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isLiquibaseSupported(@NotNull Project project) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DiffHelper.INSTANCE.isLiquibaseSupported(project) || !((charSequence = (CharSequence)DatabaseMigrationConfig.Companion.getInstance(project).getState().getLiquibaseVersion()) == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    public final boolean isLiquibaseSupported(@NotNull Project project, @Nullable Module module) {
        boolean liquibaseIsForced;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CharSequence charSequence = DatabaseMigrationConfig.Companion.getInstance(project).getState().getLiquibaseVersion();
        boolean bl = liquibaseIsForced = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        if (module == null) {
            return DiffHelper.INSTANCE.isLiquibaseSupported(project) || liquibaseIsForced;
        }
        return DiffHelper.INSTANCE.isLiquibaseSupported(module) || liquibaseIsForced;
    }

    @NotNull
    public final String generateChangeLogDir(boolean isMainChangeLogTemplate) {
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.projectProductionScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectProductionScope(...)");
        String string = this.generateChangeLogDirFromExistingRoot(globalSearchScope, isMainChangeLogTemplate);
        if (string == null) {
            string = this.generateFirstChangeLogDirName(isMainChangeLogTemplate);
        }
        return string;
    }

    public static /* synthetic */ String generateChangeLogDir$default(LiquibaseHelper liquibaseHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return liquibaseHelper.generateChangeLogDir(bl);
    }

    @NotNull
    public final String generateChangeLogDir(@NotNull Module module, boolean isMainChangeLogTemplate) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GlobalSearchScope globalSearchScope = module.getModuleScope(false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleScope(...)");
        String string = this.generateChangeLogDirFromExistingRoot(globalSearchScope, isMainChangeLogTemplate);
        if (string == null) {
            string = this.generateFirstChangeLogDirName(module, isMainChangeLogTemplate);
        }
        return string;
    }

    public static /* synthetic */ String generateChangeLogDir$default(LiquibaseHelper liquibaseHelper, Module module, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return liquibaseHelper.generateChangeLogDir(module, bl);
    }

    private final String generateChangeLogDirFromExistingRoot(GlobalSearchScope scope, boolean isMainChangeLogTemplate) {
        PsiDirectory psiDirectory = this.findExistingChangelogDir(this.project, scope);
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory existingChangelogDir = psiDirectory;
        VirtualFile virtualFile = existingChangelogDir.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return this.createChangelogDirPath(virtualFile, isMainChangeLogTemplate);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiDirectory findExistingChangelogDir(Project project, GlobalSearchScope scope) {
        PsiDirectory psiDirectory;
        block2: {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = LiquibaseSearcher.Companion.getAllImplementations(project);
            boolean $i$f$flatMapSequence = false;
            PsiDirectory psiDirectory2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                LiquibaseSearcher it = (LiquibaseSearcher)element$iv$iv;
                boolean bl = false;
                Sequence<PsiFile> list$iv$iv = it.collectChangelogFiles(scope);
                CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
            }
            List changeLogFiles = (List)destination$iv$iv;
            for (PsiFile it : (Iterable)changeLogFiles) {
                boolean bl = false;
                psiDirectory2 = HPsiUtil.getSourceRoot((PsiElement)((PsiElement)it));
                if (psiDirectory2 == null) continue;
                psiDirectory = psiDirectory2;
                break block2;
            }
            psiDirectory = null;
        }
        return psiDirectory;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final XmlTag generateTableChangeLog(@NotNull DbType dbType, String ... tableNames) {
        void $this$filterNotTo$iv$iv;
        Object it;
        boolean bl;
        List allChanges;
        Collection destination$iv$iv;
        XmlTag changeLogTag;
        block10: {
            List list;
            XmlTag[] xmlTagArray;
            Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
            Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
            FileDocumentManager.getInstance().saveAllDocuments();
            if (tableNames.length == 0) {
                return null;
            }
            LiquibaseIntellijDiffGenerationHandler handler = LiquibaseIntellijDiffGenerationHandlerFactory.Companion.getInstance(this.project).createTableDiffHandler(dbType, Arrays.copyOf(tableNames, tableNames.length));
            changeLogTag = handler.run();
            if (changeLogTag != null && (xmlTagArray = changeLogTag.findSubTags("changeSet")) != null) {
                void $this$flatMapTo$iv$iv;
                Iterator $this$flatMap$iv;
                XmlTag[] xmlTagArray2 = xmlTagArray;
                boolean $i$f$flatMap = false;
                void var10_9 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                int n = ((void)$this$flatMapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it2 = element$iv$iv = $this$flatMapTo$iv$iv[i];
                    boolean bl2 = false;
                    XmlTag[] xmlTagArray3 = it2.getSubTags();
                    Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray3, (String)"getSubTags(...)");
                    Iterable list$iv$iv = ArraysKt.toList((Object[])xmlTagArray3);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            allChanges = list;
            Iterable $this$none$iv = allChanges;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (XmlTag)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.isSuitableTableTag((XmlTag)it, "createTable", "tableName", Arrays.copyOf(tableNames, tableNames.length))) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        List sequenceNamesWithEntities = JpabReferenceManager.Companion.getInstance(this.project).getSequenceNamesWithEntities();
        Iterable $this$filterNot$iv = allChanges;
        boolean $i$f$filterNot = false;
        it = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            XmlTag changeTag = (XmlTag)element$iv$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)changeTag);
            if (this.isSuitableTableTag(changeTag, "createTable", "tableName", Arrays.copyOf(tableNames, tableNames.length)) || this.isSuitableTableTag(changeTag, "addForeignKeyConstraint", "baseTableName", Arrays.copyOf(tableNames, tableNames.length)) || this.isSuitableTableTag(changeTag, "createIndex", "tableName", Arrays.copyOf(tableNames, tableNames.length)) || this.isSuitableTableTag(changeTag, "addUniqueConstraint", "tableName", Arrays.copyOf(tableNames, tableNames.length)) || !(dbType instanceof MysqlType) && this.isSuitableSequenceTag(changeTag, sequenceNamesWithEntities, Arrays.copyOf(tableNames, tableNames.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toDeleteTags = (List)destination$iv$iv;
        if (!((Collection)toDeleteTags).isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> LiquibaseHelper.generateTableChangeLog$lambda$6(toDeleteTags));
        }
        return changeLogTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSuitableTableTag(@NotNull XmlTag tag, @NotNull String tagName, @NotNull String tableAttrName, String ... tableNames) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)tableAttrName, (String)"tableAttrName");
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.Companion.getInstance(this.project);
        if (!Intrinsics.areEqual((Object)tag.getLocalName(), (Object)tagName)) return false;
        String[] $this$any$iv = tableNames;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String element$iv;
            String it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (Intrinsics.areEqual((Object)namingStrategy.toTableName(it), (Object)tag.getAttributeValue(tableAttrName))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSuitableSequenceTag(XmlTag tag, List<JpabReferenceManager.SequenceInfo> sequenceNamesWithEntities, String ... tableNames) {
        boolean bl;
        block8: {
            void $this$filterTo$iv$iv;
            if (!Intrinsics.areEqual((Object)tag.getLocalName(), (Object)"createSequence")) {
                return false;
            }
            PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.Companion.getInstance(this.project);
            Iterable $this$filter$iv = sequenceNamesWithEntities;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl2;
                block7: {
                    JpabReferenceManager.SequenceInfo sequence = (JpabReferenceManager.SequenceInfo)element$iv$iv;
                    boolean bl3 = false;
                    Entity entity = sequence.getEntity();
                    String sequenceTable = entity != null ? entity.getTable() : null;
                    CharSequence charSequence = sequenceTable;
                    if (charSequence == null || charSequence.length() == 0) {
                        return false;
                    }
                    String[] $this$any$iv = tableNames;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String table = element$iv = $this$any$iv[i];
                        boolean bl4 = false;
                        if (!namingStrategy.compareLogicalWithPhysicalTableNames(sequenceTable, table)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sequenceInfos = (List)destination$iv$iv;
            Iterable $this$any$iv = sequenceInfos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JpabReferenceManager.SequenceInfo sequenceInfo = (JpabReferenceManager.SequenceInfo)element$iv;
                    boolean bl5 = false;
                    XmlAttribute xmlAttribute = tag.getAttribute("sequenceName");
                    if (!namingStrategy.compareSequence(xmlAttribute != null ? xmlAttribute.getValue() : null, sequenceInfo.getName())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String generateChangeLogName(@Nullable String dirPath, @NotNull Collection<String> existChangeLogNames, boolean isMainChangeLogTemplate) {
        Intrinsics.checkNotNullParameter(existChangeLogNames, (String)"existChangeLogNames");
        DatabaseMigrationState databaseMigrationState = DatabaseMigrationConfig.Companion.getInstance(this.project).getState();
        String mainChangeLogNameTemplate = isMainChangeLogTemplate ? databaseMigrationState.getMainChangeLogName() : databaseMigrationState.getSecondaryChangeLogName();
        return this.createFormatterTemplate(mainChangeLogNameTemplate, dirPath, existChangeLogNames).run();
    }

    public static /* synthetic */ String generateChangeLogName$default(LiquibaseHelper liquibaseHelper, String string, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return liquibaseHelper.generateChangeLogName(string, collection, bl);
    }

    @NotNull
    public final FormatterTemplate createFormatterTemplate(@NotNull String content, @Nullable String dirPath, @NotNull Collection<String> existFileNames) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(existFileNames, (String)"existFileNames");
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)"${semVer", (boolean)false, (int)2, null)) {
            BuildVersion buildVersion = ExternalSystemInfo.Companion.findBuildVersion(this.project);
            if (buildVersion == null) {
                buildVersion = new BuildVersion("0.0.1", 0, 0, 1, null, null, 48, null);
            }
            BuildVersion buildVersion2 = buildVersion;
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)SEMANTIC_VERSION_VAR_NAME, (Object)buildVersion2));
        } else {
            map = MapsKt.emptyMap();
        }
        Map attributes = map;
        return new FormatterTemplate(content, attributes, dirPath, existFileNames);
    }

    public static /* synthetic */ FormatterTemplate createFormatterTemplate$default(LiquibaseHelper liquibaseHelper, String string, String string2, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return liquibaseHelper.createFormatterTemplate(string, string2, collection);
    }

    private final String completeChangeLogDirTemplate(boolean isMainChangeLogTemplate) {
        DatabaseMigrationState databaseMigrationState = DatabaseMigrationConfig.Companion.getInstance(this.project).getState();
        String mainChangeLogDir = isMainChangeLogTemplate ? databaseMigrationState.getMainChangeLogDir() : databaseMigrationState.getSecondaryChangeLogDir();
        return LiquibaseHelper.createFormatterTemplate$default(this, mainChangeLogDir, null, null, 6, null).run();
    }

    static /* synthetic */ String completeChangeLogDirTemplate$default(LiquibaseHelper liquibaseHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return liquibaseHelper.completeChangeLogDirTemplate(bl);
    }

    private final String generateFirstChangeLogDirName(Module $this$generateFirstChangeLogDirName, boolean isMainChangeLogTemplate) {
        VirtualFile virtualFile = this.findSourceRootsForChangelog($this$generateFirstChangeLogDirName);
        if (virtualFile == null) {
            throw new IllegalStateException("Project doesn't contain source or resource directories");
        }
        VirtualFile root = virtualFile;
        return this.createChangelogDirPath(root, isMainChangeLogTemplate);
    }

    private final VirtualFile findSourceRootsForChangelog(Module $this$findSourceRootsForChangelog) {
        List list;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)$this$findSourceRootsForChangelog);
        List it = list = rootManager.getSourceRoots(JavaModuleSourceRootTypes.RESOURCES);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        List list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            List list3 = rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getSourceRoots(...)");
        }
        List roots = list2;
        return (VirtualFile)CollectionsKt.firstOrNull((List)roots);
    }

    private final String generateFirstChangeLogDirName(boolean isMainChangeLogTemplate) {
        List sourceRoots = JpbVfsUtil.getProjectSourceRoots((Project)this.project, (Set)SetsKt.setOf((Object)JavaResourceRootType.RESOURCE));
        if (sourceRoots.isEmpty()) {
            Set set = JavaModuleSourceRootTypes.SOURCES;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SOURCES");
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JavaSourceRootType[] javaSourceRootTypeArray = thisCollection$iv.toArray(new JavaSourceRootType[0]);
            sourceRoots = JpbVfsUtil.getProjectSourceRoots((Project)this.project, (Set)SetsKt.setOf((Object[])Arrays.copyOf(javaSourceRootTypeArray, javaSourceRootTypeArray.length)));
        }
        if (sourceRoots.isEmpty()) {
            throw new IllegalStateException("Project doesn't contain source or resource directories");
        }
        Object e = sourceRoots.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return this.createChangelogDirPath((VirtualFile)e, isMainChangeLogTemplate);
    }

    private final String createChangelogDirPath(VirtualFile root, boolean isMainChangeLogTemplate) {
        return root.getPath() + "/" + this.completeChangeLogDirTemplate(isMainChangeLogTemplate);
    }

    private static final void generateTableChangeLog$lambda$6(List $toDeleteTags) {
        Iterable $this$forEach$iv = $toDeleteTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XmlTag it = (XmlTag)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/liquibase/common/LiquibaseHelper$Companion;", "", "<init>", "()V", "INCREMENT_PATTERN", "", "SEMANTIC_VERSION_VAR_NAME", "getInstance", "Lcom/intellij/liquibase/common/LiquibaseHelper;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiquibaseHelper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LiquibaseHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LiquibaseHelper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

