/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.util.CanceledProgressAction;
import com.intellij.jpa.jpb.model.core.util.HProgressManager;
import com.intellij.liquibase.common.LiquibaseCommandManager;
import com.intellij.liquibase.common.LiquibaseCommandManagerKt;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseGenerationContextRegistry;
import com.intellij.liquibase.common.LiquibaseProperty;
import com.intellij.liquibase.common.dom.DatabaseChangeLog;
import com.intellij.liquibase.common.dom.Property;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.resource.CompositeResourceAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH$J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001dH\u0004J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0014J\u0018\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0002J+\u00101\u001a\u0002H2\"\u0004\b\u0000\u00102*\u00020.2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002H204H\u0002\u00a2\u0006\u0002\u00105R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001e\u001a\f0\u0007\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\b X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000f\u00a8\u00066"}, d2={"Lcom/intellij/liquibase/common/LiquibaseIntellijDiffGenerationHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "changelogFilePath", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDbProperties", "()Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "getChangelogFilePath", "()Ljava/lang/String;", "liquibaseCommandManager", "Lcom/intellij/liquibase/common/LiquibaseCommandManager;", "getLiquibaseCommandManager", "()Lcom/intellij/liquibase/common/LiquibaseCommandManager;", "contextRegistry", "Lcom/intellij/liquibase/common/LiquibaseGenerationContextRegistry;", "getContextRegistry", "()Lcom/intellij/liquibase/common/LiquibaseGenerationContextRegistry;", "testMode", "", "getTestMode", "()Z", "createContext", "Lcom/intellij/liquibase/common/LiquibaseGenerationContext;", "progressCaption", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getProgressCaption", "run", "Lcom/intellij/psi/xml/XmlTag;", "doRun", "Ljava/io/File;", "context", "insertProperties", "", "xmlTag", "properties", "", "Lcom/intellij/liquibase/common/LiquibaseProperty;", "createDatabase", "Lliquibase/database/Database;", "fileOpener", "Lliquibase/resource/CompositeResourceAccessor;", "use", "T", "action", "Lkotlin/Function1;", "(Lliquibase/database/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.liquibase.common"})
public abstract class LiquibaseIntellijDiffGenerationHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final DbProperties dbProperties;
    @Nullable
    private final String changelogFilePath;
    @NotNull
    private final LiquibaseCommandManager liquibaseCommandManager;
    @NotNull
    private final LiquibaseGenerationContextRegistry contextRegistry;
    private final boolean testMode;
    @NotNull
    private final String progressCaption;

    public LiquibaseIntellijDiffGenerationHandler(@NotNull Project project, @NotNull DbProperties dbProperties, @Nullable String changelogFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
        this.project = project;
        this.dbProperties = dbProperties;
        this.changelogFilePath = changelogFilePath;
        this.liquibaseCommandManager = LiquibaseCommandManager.Companion.getInstance(this.project);
        this.contextRegistry = LiquibaseGenerationContextRegistry.Companion.getInstance();
        this.testMode = ApplicationManager.getApplication().isUnitTestMode();
        String string = LiquibaseResourceBundle.message("generate.diff.changes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.progressCaption = string;
    }

    public /* synthetic */ LiquibaseIntellijDiffGenerationHandler(Project project, DbProperties dbProperties, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(project, dbProperties, string);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final DbProperties getDbProperties() {
        return this.dbProperties;
    }

    @Nullable
    protected final String getChangelogFilePath() {
        return this.changelogFilePath;
    }

    @NotNull
    protected final LiquibaseCommandManager getLiquibaseCommandManager() {
        return this.liquibaseCommandManager;
    }

    @NotNull
    protected final LiquibaseGenerationContextRegistry getContextRegistry() {
        return this.contextRegistry;
    }

    protected final boolean getTestMode() {
        return this.testMode;
    }

    @NotNull
    protected abstract LiquibaseGenerationContext createContext();

    @NotNull
    protected String getProgressCaption() {
        return this.progressCaption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XmlTag run() {
        LiquibaseGenerationContext context = this.createContext();
        this.contextRegistry.registerContext(context);
        try {
            File changeLogFile2 = this.testMode ? this.doRun(context) : (File)HProgressManager.Companion.getInstance(this.project).runProcessWithCanceledProgressSynchronously((CanceledProgressAction)new CanceledProgressAction<File>(this, context){
                private final String progressTitle;
                final /* synthetic */ LiquibaseIntellijDiffGenerationHandler this$0;
                final /* synthetic */ LiquibaseGenerationContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.progressTitle = $receiver.getProgressCaption();
                }

                public String getProgressTitle() {
                    return this.progressTitle;
                }

                public File compute() {
                    return this.this$0.doRun(this.$context);
                }

                public String completeIndicatorText(int timerIdx) {
                    Object[] objectArray = new Object[]{timerIdx};
                    String string = LiquibaseResourceBundle.message("generation.time", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }
            });
            Set<LiquibaseProperty> liquibaseProperties = context.getLiquibaseProperties();
            if (!((Collection)liquibaseProperties).isEmpty()) {
                XmlTag xmlTag = this.liquibaseCommandManager.getChangeLogTag(changeLogFile2);
                Intrinsics.checkNotNull((Object)xmlTag);
                XmlTag changeLogTag = xmlTag;
                WriteCommandAction.writeCommandAction((Project)this.project).run(() -> LiquibaseIntellijDiffGenerationHandler.run$lambda$0(this, changeLogTag, liquibaseProperties));
            }
            XmlTag xmlTag = this.liquibaseCommandManager.getChangeLogTag(changeLogFile2);
            return xmlTag;
        }
        finally {
            this.contextRegistry.unregisterContext(context);
        }
    }

    @NotNull
    protected final File doRun(@NotNull LiquibaseGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (File)ActionsKt.runReadAction(() -> LiquibaseIntellijDiffGenerationHandler.doRun$lambda$3(this, context));
    }

    protected void insertProperties(@NotNull XmlTag xmlTag, @NotNull Set<LiquibaseProperty> properties2) {
        Intrinsics.checkNotNullParameter((Object)xmlTag, (String)"xmlTag");
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        DomElement domElement = DomManager.getDomManager((Project)this.project).getDomElement(xmlTag);
        DatabaseChangeLog databaseChangeLog = domElement instanceof DatabaseChangeLog ? (DatabaseChangeLog)domElement : null;
        if (databaseChangeLog == null) {
            return;
        }
        DatabaseChangeLog changeLog = databaseChangeLog;
        for (LiquibaseProperty property : properties2) {
            Property newProperty = changeLog.addProperty(changeLog.getProperties().size());
            newProperty.getName().setValue((Object)property.getName());
            newProperty.getValue().setValue((Object)property.getValue());
            newProperty.getDbms().setValue((Object)property.getDbms());
        }
    }

    private final Database createDatabase(LiquibaseGenerationContext context, CompositeResourceAccessor fileOpener) {
        String referenceUrl = "jpab?generationContext=" + context.getId();
        return LiquibaseCommandManager.createDatabase$default(this.liquibaseCommandManager, fileOpener, referenceUrl, null, null, null, context.getMainDbType(), false, 64, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T use(Database $this$use, Function1<? super Database, ? extends T> action) {
        try {
            Object object = action.invoke((Object)$this$use);
            return (T)object;
        }
        finally {
            try {
                $this$use.rollback();
                $this$use.close();
            }
            catch (DatabaseException e) {
                throw new IllegalStateException(LiquibaseResourceBundle.message("problem.closing.connection", new Object[0]));
            }
        }
    }

    private static final void run$lambda$0(LiquibaseIntellijDiffGenerationHandler this$0, XmlTag $changeLogTag, Set $liquibaseProperties) {
        this$0.insertProperties($changeLogTag, $liquibaseProperties);
    }

    private static final File doRun$lambda$3$lambda$2$lambda$1(LiquibaseIntellijDiffGenerationHandler this$0, LiquibaseGenerationContext $context, Database rdbmsDatabase) {
        File file;
        Intrinsics.checkNotNullParameter((Object)rdbmsDatabase, (String)"rdbmsDatabase");
        Database intellijDatabase = this$0.createDatabase($context, this$0.liquibaseCommandManager.createFileOpener(this$0.dbProperties));
        if (this$0.changelogFilePath != null) {
            File file2 = new File(this$0.changelogFilePath);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            file = file2;
        } else {
            File file3 = FileUtil.createTempFile((String)("liquibase-change-log-" + System.currentTimeMillis()), (String)".xml", (boolean)true);
            Intrinsics.checkNotNull((Object)file3);
            file = file3;
        }
        File changeLogFile2 = file;
        LiquibaseCommandManager liquibaseCommandManager = this$0.liquibaseCommandManager;
        String string = changeLogFile2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        liquibaseCommandManager.generateDiffChangeLog(string, intellijDatabase, rdbmsDatabase);
        return changeLogFile2;
    }

    private static final File doRun$lambda$3$lambda$2(LiquibaseIntellijDiffGenerationHandler this$0, LiquibaseGenerationContext $context) {
        return (File)this$0.use((Database)LiquibaseCommandManager.createDatabase$default(this$0.liquibaseCommandManager, this$0.dbProperties, null, false, 6, null).getFirst(), arg_0 -> LiquibaseIntellijDiffGenerationHandler.doRun$lambda$3$lambda$2$lambda$1(this$0, $context, arg_0));
    }

    private static final File doRun$lambda$3(LiquibaseIntellijDiffGenerationHandler this$0, LiquibaseGenerationContext $context) {
        return (File)LiquibaseCommandManagerKt.runWithPluginClassLoader(() -> LiquibaseIntellijDiffGenerationHandler.doRun$lambda$3$lambda$2(this$0, $context));
    }
}

