/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import liquibase.structure.core.Column;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.Table;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lcom/intellij/liquibase/common/LiquibaseModelObjectFactory;", "", "<init>", "()V", "createTable", "Lliquibase/structure/core/Table;", "name", "", "createColumn", "Lliquibase/structure/core/Column;", "createIndexColumn", "createSequence", "Lliquibase/structure/core/Sequence;", "getNamingStrategy", "Lcom/intellij/jpa/jpb/model/liquibase/ns/PhysicalNamingStrategy;", "intellij.liquibase.common"})
public abstract class LiquibaseModelObjectFactory {
    @NotNull
    public final Table createTable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Table table = new Table().setName(this.getNamingStrategy().toTableName(name));
        Intrinsics.checkNotNullExpressionValue((Object)table, (String)"setName(...)");
        return table;
    }

    @NotNull
    public final Column createColumn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column column = new Column().setName(this.getNamingStrategy().toColumnName(name));
        Intrinsics.checkNotNullExpressionValue((Object)column, (String)"setName(...)");
        return column;
    }

    @NotNull
    public final Column createIndexColumn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column column = new Column();
        if (StringsKt.endsWith((String)name, (String)" desc", (boolean)true)) {
            PhysicalNamingStrategy physicalNamingStrategy = this.getNamingStrategy();
            String string = name.substring(0, name.length() - 5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            column.setName(physicalNamingStrategy.toColumnName(string));
            column.setDescending(Boolean.valueOf(true));
        } else {
            column.setName(this.getNamingStrategy().toColumnName(name));
        }
        return column;
    }

    @NotNull
    public final Sequence createSequence(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Sequence sequence = new Sequence().setName(this.getNamingStrategy().toSequenceName(name));
        Intrinsics.checkNotNullExpressionValue((Object)sequence, (String)"setName(...)");
        return sequence;
    }

    @NotNull
    public abstract PhysicalNamingStrategy getNamingStrategy();
}

