/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.ui.SSwingUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0002\"#B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\fJ\u001d\u0010\u0016\u001a\u00020\u00132\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018H\u0082\bJ\u0006\u0010\u001a\u001a\u00020\u0019J\b\u0010\u001b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/intellij/liquibase/common/PersistenceUnitField;", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmUnit;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionIds", "", "", "ormUnitsProvider", "Lcom/intellij/jpa/jpb/model/orm/ep/OrmUnitsProvider;", "field", "getField", "()Lcom/intellij/openapi/ui/ComboBox;", "init", "", "selectByPersistenceName", "persistenceUnitName", "selectPersistenceUnit", "predicate", "Lkotlin/Function1;", "", "isSelectedPersistenceUnitEmpty", "getPersistenceUnitName", "addActionListener", "listener", "Ljava/awt/event/ActionListener;", "addAction", "actionListener", "updatePersistenceUnitItems", "EditSelectedPersistenceUnitAction", "PersistentUnitRenderer", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nPersistenceUnitField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistenceUnitField.kt\ncom/intellij/liquibase/common/PersistenceUnitField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n40#1,11:114\n1863#2,2:125\n*S KotlinDebug\n*F\n+ 1 PersistenceUnitField.kt\ncom/intellij/liquibase/common/PersistenceUnitField\n*L\n35#1:114,11\n83#1:125,2\n*E\n"})
public final class PersistenceUnitField
extends ComponentWithBrowseButton<ComboBox<OrmUnit>> {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> actionIds;
    @NotNull
    private final OrmUnitsProvider ormUnitsProvider;

    public PersistenceUnitField(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((JComponent)new ComboBox(), null);
        this.project = project;
        this.actionIds = new LinkedHashSet();
        OrmUnitsProvider ormUnitsProvider = OrmUnitsProvider.Companion.getForProject(this.project);
        Intrinsics.checkNotNull((Object)ormUnitsProvider);
        this.ormUnitsProvider = ormUnitsProvider;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ComboBox<OrmUnit> getField() {
        JComponent jComponent = this.getChildComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
        return (ComboBox)jComponent;
    }

    public final void init() {
        if (this.ormUnitsProvider.isUnitsModifiable()) {
            this.addAction(new EditSelectedPersistenceUnitAction());
            this.setButtonIcon(AllIcons.Actions.Edit);
        } else {
            this.setButtonVisible(false);
        }
        this.updatePersistenceUnitItems();
        this.getField().setRenderer((ListCellRenderer)((Object)new PersistentUnitRenderer()));
    }

    public final void selectByPersistenceName(@Nullable String persistenceUnitName) {
        PersistenceUnitField this_$iv = this;
        boolean $i$f$selectPersistenceUnit = false;
        int n = this_$iv.getField().getItemCount();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            OrmUnit itemAt$iv = (OrmUnit)this_$iv.getField().getItemAt(i$iv);
            if (itemAt$iv == null) continue;
            OrmUnit it = itemAt$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)persistenceUnitName)) continue;
            OrmUnit currSelectedItem$iv = (OrmUnit)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)this_$iv.getField()));
            if (Intrinsics.areEqual((Object)currSelectedItem$iv, (Object)itemAt$iv)) {
                this_$iv.getField().setSelectedItem(null);
            }
            SSwingUtilKt.setSelectedItemTyped((JComboBox)((JComboBox)this_$iv.getField()), (Object)itemAt$iv);
        }
    }

    private final void selectPersistenceUnit(Function1<? super OrmUnit, Boolean> predicate) {
        boolean $i$f$selectPersistenceUnit = false;
        int n = this.getField().getItemCount();
        for (int i = 0; i < n; ++i) {
            OrmUnit itemAt = (OrmUnit)this.getField().getItemAt(i);
            if (itemAt == null || !((Boolean)predicate.invoke((Object)itemAt)).booleanValue()) continue;
            OrmUnit currSelectedItem = (OrmUnit)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)this.getField()));
            if (Intrinsics.areEqual((Object)currSelectedItem, (Object)itemAt)) {
                this.getField().setSelectedItem(null);
            }
            SSwingUtilKt.setSelectedItemTyped((JComboBox)((JComboBox)this.getField()), (Object)itemAt);
        }
    }

    public final boolean isSelectedPersistenceUnitEmpty() {
        OrmUnit ormUnit = (OrmUnit)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)this.getField()));
        if (ormUnit == null) {
            return true;
        }
        OrmUnit persistenceUnit = ormUnit;
        return persistenceUnit.getEntities().isEmpty();
    }

    @Nullable
    public final String getPersistenceUnitName() {
        OrmUnit ormUnit = (OrmUnit)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)this.getField()));
        return ormUnit != null ? ormUnit.getName() : null;
    }

    public void addActionListener(@Nullable ActionListener listener) {
        this.getField().addActionListener(listener);
    }

    public final void addAction(@NotNull ActionListener actionListener) {
        Intrinsics.checkNotNullParameter((Object)actionListener, (String)"actionListener");
        super.addActionListener(actionListener);
        this.actionIds.add(actionListener.getClass().getName() + actionListener.hashCode());
    }

    public final void updatePersistenceUnitItems() {
        OrmUnit ormUnit = (OrmUnit)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)this.getField()));
        String lastSelectedItem = ormUnit != null ? ormUnit.getName() : null;
        this.getField().removeAllItems();
        Iterable $this$forEach$iv = this.ormUnitsProvider.getUnits(this.project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OrmUnit it = (OrmUnit)element$iv;
            boolean bl = false;
            this.getField().addItem((Object)it);
        }
        this.selectByPersistenceName(lastSelectedItem);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/common/PersistenceUnitField$EditSelectedPersistenceUnitAction;", "Ljava/awt/event/ActionListener;", "<init>", "(Lcom/intellij/liquibase/common/PersistenceUnitField;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.liquibase.common"})
    public final class EditSelectedPersistenceUnitAction
    implements ActionListener {
        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            OrmUnit ormUnit = (OrmUnit)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)PersistenceUnitField.this.getField()));
            if (ormUnit == null) {
                return;
            }
            OrmUnit selectedUnit = ormUnit;
            PersistenceUnitField.this.ormUnitsProvider.modifyUnit(selectedUnit, () -> EditSelectedPersistenceUnitAction.actionPerformed$lambda$0(PersistenceUnitField.this));
        }

        private static final Unit actionPerformed$lambda$0(PersistenceUnitField this$0) {
            this$0.updatePersistenceUnitItems();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/liquibase/common/PersistenceUnitField$PersistentUnitRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmUnit;", "<init>", "()V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.liquibase.common"})
    private static final class PersistentUnitRenderer
    extends ColoredListCellRenderer<OrmUnit> {
        protected void customizeCellRenderer(@NotNull JList<? extends OrmUnit> list, @Nullable OrmUnit value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (value == null) {
                return;
            }
            this.append(value.getPresentableName());
            String string = value.getDescription();
            if (string == null) {
                return;
            }
            String moduleName = string;
            this.append(" ");
            this.append(moduleName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }
}

