/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.liquibase.common.ChangeLogCreationResult;
import com.intellij.liquibase.common.ChangeLogDeserializerWriter;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.liquibase.common.gui.ChangeLogModel;
import com.intellij.liquibase.common.gui.IncludeInfo;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import liquibase.database.Database;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.core.formattedsql.FormattedSqlChangeLogSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0014J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0014J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lcom/intellij/liquibase/common/SQLChangeLogWriter;", "Lcom/intellij/liquibase/common/ChangeLogDeserializerWriter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "generator", "Lcom/intellij/json/psi/JsonElementGenerator;", "getGenerator", "()Lcom/intellij/json/psi/JsonElementGenerator;", "writeToFile", "Lcom/intellij/liquibase/common/ChangeLogCreationResult;", "existingFile", "Lcom/intellij/psi/PsiFile;", "changeLogModel", "Lcom/intellij/liquibase/common/gui/ChangeLogModel;", "newFile", "propertyTags", "", "Lcom/intellij/psi/xml/XmlTag;", "changeSource", "", "createFileFromContent", "content", "getChangeLogSerializer", "Lliquibase/serializer/ChangeLogSerializer;", "supportedFileType", "Lcom/intellij/liquibase/common/LiquibaseFileType;", "unwrapChangesetFromChangelog", "changelogText", "unwrapChangeFromChangelog", "getDummyFileName", "db", "Lliquibase/database/Database;", "SqlChangeLogCreationResult", "Companion", "intellij.liquibase.common"})
public final class SQLChangeLogWriter
extends ChangeLogDeserializerWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonElementGenerator generator;
    @NotNull
    public static final String SQL_COMMENT = "-- liquibase formatted sql";

    public SQLChangeLogWriter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.generator = new JsonElementGenerator(project);
    }

    @NotNull
    public final JsonElementGenerator getGenerator() {
        return this.generator;
    }

    @Override
    @NotNull
    public ChangeLogCreationResult<?> writeToFile(@Nullable PsiFile existingFile, @NotNull ChangeLogModel changeLogModel, @NotNull PsiFile newFile, @NotNull List<? extends XmlTag> propertyTags, @NotNull String changeSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeLogModel), (String)"changeLogModel");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Intrinsics.checkNotNullParameter(propertyTags, (String)"propertyTags");
        Intrinsics.checkNotNullParameter((Object)changeSource, (String)"changeSource");
        SqlChangeLogCreationResult result = new SqlChangeLogCreationResult(null, null, 3, null);
        Object object = WriteCommandAction.writeCommandAction((Project)this.getProject()).withName(LiquibaseResourceBundle.message("command.name.writing.changelog.file", new Object[0])).compute(() -> SQLChangeLogWriter.writeToFile$lambda$0(result, existingFile, this, changeLogModel, newFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (ChangeLogCreationResult)object;
    }

    @Override
    @NotNull
    public PsiFile createFileFromContent(@NotNull ChangeLogModel changeLogModel, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeLogModel), (String)"changeLogModel");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(changeLogModel.getFileName() + ".sql", (FileType)PlainTextFileType.INSTANCE, (CharSequence)content);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        return psiFile;
    }

    @Override
    @NotNull
    public ChangeLogSerializer getChangeLogSerializer() {
        return (ChangeLogSerializer)new FormattedSqlChangeLogSerializer();
    }

    @Override
    @NotNull
    public LiquibaseFileType supportedFileType() {
        return LiquibaseFileType.SQL;
    }

    @Override
    @NotNull
    protected String unwrapChangesetFromChangelog(@NotNull String changelogText) {
        Intrinsics.checkNotNullParameter((Object)changelogText, (String)"changelogText");
        return changelogText;
    }

    @Override
    @NotNull
    protected String unwrapChangeFromChangelog(@NotNull String changelogText) {
        Intrinsics.checkNotNullParameter((Object)changelogText, (String)"changelogText");
        return StringsKt.substringAfter$default((String)StringsKt.substringAfterLast$default((String)changelogText, (String)"-- changeset", null, (int)2, null), (String)"\n", null, (int)2, null);
    }

    @Override
    @NotNull
    protected String getDummyFileName(@NotNull Database db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        return "stub." + db.getShortName() + ".sql";
    }

    private static final ChangeLogCreationResult writeToFile$lambda$0(SqlChangeLogCreationResult $result, PsiFile $existingFile, SQLChangeLogWriter this$0, ChangeLogModel $changeLogModel, PsiFile $newFile) {
        PsiFile psiFile;
        if ($existingFile == null) {
            psiFile = this$0.storeFile($changeLogModel, $newFile);
        } else {
            String string = $existingFile.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() > 0) {
                String string2 = $existingFile.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                PsiFile fileWithoutComment = this$0.createFileFromContent($changeLogModel, StringsKt.substringAfter$default((String)string2, (String)SQL_COMMENT, null, (int)2, null));
                v3 = $existingFile.add(fileWithoutComment.getFirstChild());
            } else {
                v3 = $existingFile.add($newFile.getFirstChild());
            }
            psiFile = $existingFile;
        }
        PsiFile psiFile2 = psiFile;
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
        $result.setFile(psiFile2);
        return $result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/liquibase/common/SQLChangeLogWriter$Companion;", "", "<init>", "()V", "SQL_COMMENT", "", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/common/SQLChangeLogWriter$SqlChangeLogCreationResult;", "Lcom/intellij/liquibase/common/ChangeLogCreationResult;", "Lcom/intellij/psi/PsiFile;", "file", "includeInfo", "Lcom/intellij/liquibase/common/gui/IncludeInfo;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/liquibase/common/gui/IncludeInfo;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "setFile", "(Lcom/intellij/psi/PsiFile;)V", "getIncludeInfo", "()Lcom/intellij/liquibase/common/gui/IncludeInfo;", "setIncludeInfo", "(Lcom/intellij/liquibase/common/gui/IncludeInfo;)V", "intellij.liquibase.common"})
    public static final class SqlChangeLogCreationResult
    implements ChangeLogCreationResult<PsiFile> {
        @Nullable
        private PsiFile file;
        @Nullable
        private IncludeInfo includeInfo;

        public SqlChangeLogCreationResult(@Nullable PsiFile file, @Nullable IncludeInfo includeInfo) {
            this.file = file;
            this.includeInfo = includeInfo;
        }

        public /* synthetic */ SqlChangeLogCreationResult(PsiFile psiFile, IncludeInfo includeInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                psiFile = null;
            }
            if ((n & 2) != 0) {
                includeInfo = null;
            }
            this(psiFile, includeInfo);
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return this.file;
        }

        @Override
        public void setFile(@Nullable PsiFile psiFile) {
            this.file = psiFile;
        }

        @Override
        @Nullable
        public IncludeInfo getIncludeInfo() {
            return this.includeInfo;
        }

        @Override
        public void setIncludeInfo(@Nullable IncludeInfo includeInfo) {
            this.includeInfo = includeInfo;
        }

        public SqlChangeLogCreationResult() {
            this(null, null, 3, null);
        }
    }
}

