/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.ddl;

import com.google.common.collect.ImmutableMap;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.HibernateTypes;
import com.intellij.jpa.jpb.model.db.VladmihalceaHibernateTypes;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.ddl.DbMappingSettings;
import com.intellij.liquibase.common.ddl.DbMappingSettingsKt;
import com.intellij.liquibase.common.ddl.LiquibaseTypes;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dJ1\u0010 \u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\u001b2\b\u0010\"\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010%J(\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u001bH\u0016J1\u0010,\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\u001b2\b\u0010\"\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006."}, d2={"Lcom/intellij/liquibase/common/ddl/OracleMappingSettings;", "Lcom/intellij/liquibase/common/ddl/DbMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "liquibaseTypes", "Lcom/intellij/liquibase/common/ddl/LiquibaseTypes;", "vladmihalceaHibernateTypes", "Lcom/intellij/jpa/jpb/model/db/VladmihalceaHibernateTypes;", "sqlSynonymTypes", "", "", "", "getSqlSynonymTypes", "()Ljava/util/Map;", "mappingTypes", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "jdbcTypeCodeMappings", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getJdbcTypeCodeMappings", "isJdbcTypeCodeLengthAvailable", "", "jdbcTypeCode", "", "getSpecificLengthByJdbcTypeCode", "(I)Ljava/lang/Integer;", "defaultValues", "getDefaultValues", "precisionChanged", "attributeColumnSize", "dbColumnSizeInt", "attributeSqlType", "dbSqlType", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Z", "typeChanged", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "attrMappedSqlType", "dbType", "oldLength", "scaleChanged", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nDbMappingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/common/ddl/OracleMappingSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1520:1\n1863#2,2:1521\n1863#2,2:1523\n1863#2,2:1525\n12574#3,2:1527\n*S KotlinDebug\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/common/ddl/OracleMappingSettings\n*L\n1395#1:1521,2\n1396#1:1523,2\n1402#1:1525,2\n1378#1:1527,2\n*E\n"})
public final class OracleMappingSettings
implements DbMappingSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LiquibaseTypes liquibaseTypes;
    @NotNull
    private final VladmihalceaHibernateTypes vladmihalceaHibernateTypes;
    @NotNull
    private final Map<String, Collection<String>> sqlSynonymTypes;
    @NotNull
    private final Map<HibernateSqlType, String> jdbcTypeCodeMappings;
    @NotNull
    private final Map<Datatypes.BasicDatatype, String> defaultValues;
    private static final int MAX_DECIMAL_PRECISION = 1000;
    private static final int PRIMARY_KEY_UUID_LENGTH = 32;
    private static final Pattern TIMESTAMP_WITH_SECONDS_PRECISION_PATTERN = Pattern.compile("^timestamp(\\(\\d+?\\))", 2);

    /*
     * WARNING - void declaration
     */
    public OracleMappingSettings(@NotNull Project project) {
        Datatypes.BasicDatatype it;
        void $this$defaultValues_u24lambda_u247;
        void it2;
        Pair[] $this$sqlSynonymTypes_u24lambda_u240;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.liquibaseTypes = new LiquibaseTypes(this.project);
        this.vladmihalceaHibernateTypes = VladmihalceaHibernateTypes.Companion.getInstance(this.project);
        Pair[] pairArray2 = pairArray = (Pair[])new LinkedHashMap();
        OracleMappingSettings oracleMappingSettings = this;
        boolean bl = false;
        $this$sqlSynonymTypes_u24lambda_u240.put("BIGINT", CollectionsKt.listOf((Object)"number"));
        Object[] objectArray = new String[]{"BFILE", "RAW"};
        $this$sqlSynonymTypes_u24lambda_u240.put("BLOB", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"char", "NUMBER"};
        $this$sqlSynonymTypes_u24lambda_u240.put("BOOLEAN", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"character", "NCHAR"};
        $this$sqlSynonymTypes_u24lambda_u240.put("CHAR", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"timestamp", "timestamp with time zone", "timestamptz", "TIMESTAMP WITH LOCAL TIME ZONE"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DATE", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"timestamptz", "timestamp with time zone", "TIMESTAMP"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DATETIME", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"CURRENCY", "NUMBER"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DECIMAL", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"float", "double precision", "float(53)", "float(24)"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DOUBLE", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"integer", "number"};
        $this$sqlSynonymTypes_u24lambda_u240.put("INT", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"integer", "number", "TINYINT"};
        $this$sqlSynonymTypes_u24lambda_u240.put("SMALLINT", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"DATE", "time with time zone", "TIMESTAMP", "TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP(6)", "DATETIME"};
        $this$sqlSynonymTypes_u24lambda_u240.put("TIME", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"varchar2", "character varying", "nvarchar2", "CLOB", "NCLOB", "NVARCHAR"};
        $this$sqlSynonymTypes_u24lambda_u240.put("VARCHAR", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"raw", "varchar2"};
        $this$sqlSynonymTypes_u24lambda_u240.put("UUID", CollectionsKt.listOf((Object[])objectArray));
        $this$sqlSynonymTypes_u24lambda_u240.put("XML", CollectionsKt.emptyList());
        $this$sqlSynonymTypes_u24lambda_u240 = pairArray;
        boolean $i$a$-let-OracleMappingSettings$sqlSynonymTypes$32 = false;
        oracleMappingSettings.sqlSynonymTypes = DbMappingSettingsKt.access$createSynonymMap(this.project, (Map)it2);
        pairArray = new Pair[]{TuplesKt.to((Object)HibernateSqlType.JSON, (Object)"CLOB"), TuplesKt.to((Object)HibernateSqlType.LONG32NVARCHAR, (Object)"NCLOB"), TuplesKt.to((Object)HibernateSqlType.LONGVARCHAR, (Object)"CLOB"), TuplesKt.to((Object)HibernateSqlType.LONGNVARCHAR, (Object)"NCLOB"), TuplesKt.to((Object)HibernateSqlType.TIMESTAMP_WITH_TIMEZONE, (Object)"timestamp with time zone"), TuplesKt.to((Object)HibernateSqlType.TIMESTAMP_UTC, (Object)"timestamp with time zone"), TuplesKt.to((Object)HibernateSqlType.DOUBLE, (Object)"FLOAT(53)"), TuplesKt.to((Object)HibernateSqlType.FLOAT, (Object)"FLOAT(24)"), TuplesKt.to((Object)HibernateSqlType.REAL, (Object)"FLOAT(24)")};
        this.jdbcTypeCodeMappings = MapsKt.plus(this.liquibaseTypes.getJDBC_TYPE_CODE_TYPES(), (Map)MapsKt.mapOf((Pair[])pairArray));
        Map $i$a$-let-OracleMappingSettings$sqlSynonymTypes$32 = new LinkedHashMap();
        oracleMappingSettings = this;
        boolean bl2 = false;
        Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.Boolean;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"Boolean");
        $this$defaultValues_u24lambda_u247.put(basicDatatype, "'0''");
        Datatypes.BasicDatatype basicDatatype2 = Datatypes.BasicDatatype.ByteArray;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype2, (String)"ByteArray");
        $this$defaultValues_u24lambda_u247.put(basicDatatype2, "empty_blob()");
        Iterable $this$forEach$iv = DbMappingSettingsKt.access$getDATE_TYPES$p();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u247.put(it, "current_date");
        }
        $this$forEach$iv = DbMappingSettingsKt.access$getDATATIME_TYPES$p();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u247.put(it, "current_timestamp");
        }
        Datatypes.BasicDatatype basicDatatype3 = Datatypes.BasicDatatype.BigDecimal;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype3, (String)"BigDecimal");
        $this$defaultValues_u24lambda_u247.put(basicDatatype3, "0");
        Datatypes.BasicDatatype basicDatatype4 = Datatypes.BasicDatatype.Double;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype4, (String)"Double");
        $this$defaultValues_u24lambda_u247.put(basicDatatype4, "0");
        Datatypes.BasicDatatype basicDatatype5 = Datatypes.BasicDatatype.Integer;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype5, (String)"Integer");
        $this$defaultValues_u24lambda_u247.put(basicDatatype5, "0");
        Datatypes.BasicDatatype basicDatatype6 = Datatypes.BasicDatatype.Long;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype6, (String)"Long");
        $this$defaultValues_u24lambda_u247.put(basicDatatype6, "0");
        Datatypes.BasicDatatype basicDatatype7 = Datatypes.BasicDatatype.String;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype7, (String)"String");
        $this$defaultValues_u24lambda_u247.put(basicDatatype7, "' '");
        $this$forEach$iv = DbMappingSettingsKt.access$getTIME_TYPES$p();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u247.put(it, "current_timestamp");
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)$this$defaultValues_u24lambda_u247);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"run(...)");
        oracleMappingSettings.defaultValues = (Map)immutableMap;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        return this.sqlSynonymTypes;
    }

    @Override
    @NotNull
    public Map<Datatypes.BasicDatatype, String> getMappingTypes() {
        Map $this$_get_mappingTypes__u24lambda_u242 = new LinkedHashMap();
        boolean bl = false;
        $this$_get_mappingTypes__u24lambda_u242.putAll(this.liquibaseTypes.DATABASE_INDEPENDENT_TYPES);
        if (JpaUtils.isHibernate6Project((Project)this.project)) {
            Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.OffsetDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"OffsetDateTime");
            $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype, "timestamp");
            Datatypes.BasicDatatype basicDatatype2 = Datatypes.BasicDatatype.OffsetTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype2, (String)"OffsetTime");
            $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype2, "timestamp");
            Datatypes.BasicDatatype basicDatatype3 = Datatypes.BasicDatatype.ZonedDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype3, (String)"ZonedDateTime");
            v3 = $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype3, "timestamp");
        } else {
            Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.OffsetDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"OffsetDateTime");
            $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype, "timestamp with time zone");
            Datatypes.BasicDatatype basicDatatype4 = Datatypes.BasicDatatype.OffsetTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype4, (String)"OffsetTime");
            $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype4, "timestamp with time zone");
            Datatypes.BasicDatatype basicDatatype5 = Datatypes.BasicDatatype.ZonedDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype5, (String)"ZonedDateTime");
            v3 = $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype5, "timestamp with time zone");
        }
        Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.Calendar;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"Calendar");
        $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype, "timestamp with time zone");
        $this$_get_mappingTypes__u24lambda_u242.put(HibernateTypes.INSTANCE.getBinaryType(), "raw");
        $this$_get_mappingTypes__u24lambda_u242.put(this.vladmihalceaHibernateTypes.getOracleIntervalDayToSecondType(), "intervalIDS");
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)$this$_get_mappingTypes__u24lambda_u242);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"run(...)");
        return (Map)immutableMap;
    }

    @Override
    @NotNull
    public Map<HibernateSqlType, String> getJdbcTypeCodeMappings() {
        return this.jdbcTypeCodeMappings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isJdbcTypeCodeLengthAvailable(int jdbcTypeCode) {
        if (DbMappingSettings.super.isJdbcTypeCodeLengthAvailable(jdbcTypeCode)) return true;
        HibernateSqlType[] hibernateSqlTypeArray = new HibernateSqlType[]{HibernateSqlType.BINARY, HibernateSqlType.GEOGRAPHY, HibernateSqlType.GEOMETRY, HibernateSqlType.INET, HibernateSqlType.POINT, HibernateSqlType.VARBINARY};
        HibernateSqlType[] $this$any$iv = hibernateSqlTypeArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            HibernateSqlType element$iv;
            HibernateSqlType it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (it.equalsByCode(Integer.valueOf(jdbcTypeCode))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    @Nullable
    public Integer getSpecificLengthByJdbcTypeCode(int jdbcTypeCode) {
        return HibernateSqlType.INET.equalsByCode(Integer.valueOf(jdbcTypeCode)) ? Integer.valueOf(19) : DbMappingSettings.super.getSpecificLengthByJdbcTypeCode(jdbcTypeCode);
    }

    @Override
    @NotNull
    public Map<Datatypes.BasicDatatype, String> getDefaultValues() {
        return this.defaultValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean precisionChanged(@Nullable Integer attributeColumnSize, @Nullable Integer dbColumnSizeInt, @NotNull String attributeSqlType, @NotNull String dbSqlType) {
        Intrinsics.checkNotNullParameter((Object)attributeSqlType, (String)"attributeSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        if (StringsKt.equals((String)"number", (String)dbSqlType, (boolean)true) && StringsKt.equals((String)"CURRENCY", (String)attributeSqlType, (boolean)true)) {
            Integer n = dbColumnSizeInt;
            int n2 = 15;
            if (n != null && n == n2 && attributeColumnSize == null) {
                return false;
            }
        }
        if (Intrinsics.areEqual((Object)dbColumnSizeInt, (Object)attributeColumnSize)) return false;
        if (dbColumnSizeInt == null) return true;
        if (dbColumnSizeInt <= 1000) return true;
        if (attributeColumnSize == null) return false;
        if (attributeColumnSize == 0) return false;
        return true;
    }

    @Override
    public boolean typeChanged(@NotNull Datatype datatype, @NotNull String attrMappedSqlType, @NotNull String dbType, int oldLength) {
        Matcher matcher;
        Datatype[] datatypeArray;
        Intrinsics.checkNotNullParameter((Object)datatype, (String)"datatype");
        Intrinsics.checkNotNullParameter((Object)attrMappedSqlType, (String)"attrMappedSqlType");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        String string = dbType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Object columnDbType = string;
        String string2 = attrMappedSqlType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String attributeType = string2;
        if (this.isConvertibleType((String)columnDbType, "varchar") && oldLength == 32 && Datatypes.BasicDatatype.UUID.isSame(datatypeArray = new Datatype[]{datatype})) {
            attributeType = "varchar";
        }
        if ((matcher = TIMESTAMP_WITH_SECONDS_PRECISION_PATTERN.matcher((CharSequence)columnDbType)).find()) {
            String string3 = ((String)columnDbType).substring(0, matcher.start(1));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String string4 = ((String)columnDbType).substring(matcher.end(1));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            columnDbType = string3 + string4;
        }
        if (Intrinsics.areEqual((Object)"number", (Object)columnDbType) && oldLength == 1 && Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Boolean)) {
            return false;
        }
        String[] stringArray = new String[]{"char", "nchar"};
        return Arrays.asList(stringArray).contains(columnDbType) && Intrinsics.areEqual((Object)"varchar", (Object)attributeType) && oldLength > 1 ? false : !this.isConvertibleType(attributeType, (String)columnDbType);
    }

    @Override
    public boolean scaleChanged(@Nullable Integer attributeColumnSize, @Nullable Integer dbColumnSizeInt, @NotNull String attributeSqlType, @NotNull String dbSqlType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)attributeSqlType, (String)"attributeSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        if (StringsKt.equals((String)"number", (String)dbSqlType, (boolean)true) && StringsKt.equals((String)"CURRENCY", (String)attributeSqlType, (boolean)true)) {
            Integer n = dbColumnSizeInt;
            int n2 = 2;
            if (n != null && n == n2 && attributeColumnSize == null) {
                return false;
            }
        }
        if (DbMappingSettings.super.scaleChanged(attributeColumnSize, dbColumnSizeInt, attributeSqlType, dbSqlType)) {
            Integer n = attributeColumnSize;
            Integer n3 = dbColumnSizeInt;
            bl = n3 == null || (n != null ? n : 0) != n3;
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/liquibase/common/ddl/OracleMappingSettings$Companion;", "", "<init>", "()V", "MAX_DECIMAL_PRECISION", "", "PRIMARY_KEY_UUID_LENGTH", "TIMESTAMP_WITH_SECONDS_PRECISION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

