/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.dom.converter;

import com.intellij.jpa.jpb.model.util.SearchHelper;
import com.intellij.liquibase.common.dom.DatabaseChangeLog;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/liquibase/common/dom/converter/IncludeChangeLogConverter;", "Lcom/intellij/util/xml/Converter;", "Lcom/intellij/liquibase/common/dom/DatabaseChangeLog;", "<init>", "()V", "fromString", "path", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "toString", "t", "intellij.liquibase.common"})
public final class IncludeChangeLogConverter
extends Converter<DatabaseChangeLog> {
    @Nullable
    public DatabaseChangeLog fromString(@Nullable String path, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (path == null) {
            return null;
        }
        GlobalSearchScope globalSearchScope = context.getSearchScope();
        if (globalSearchScope == null) {
            return null;
        }
        GlobalSearchScope searchScope = globalSearchScope;
        if (ModuleUtilCore.findModuleForFile((PsiFile)((PsiFile)context.getFile())) == null) {
            searchScope = searchScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScopes.projectProductionScope((Project)context.getProject())));
        }
        Project project = context.getProject();
        SearchHelper searchHelper = SearchHelper.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)searchHelper, (String)"getInstance(...)");
        SearchHelper searchHelper2 = searchHelper;
        XmlFile xmlFile = (XmlFile)searchHelper2.findFile(path, XmlFile.class, searchScope);
        if (xmlFile == null) {
            return null;
        }
        XmlFile foundFile = xmlFile;
        DomManager domManager = DomManager.getDomManager((Project)project);
        DomFileElement domFileElement = domManager.getFileElement(foundFile, DatabaseChangeLog.class);
        if (domFileElement == null) {
            return null;
        }
        DomFileElement fileElement = domFileElement;
        return (DatabaseChangeLog)fileElement.getRootElement();
    }

    @Nullable
    public String toString(@Nullable DatabaseChangeLog t, @NotNull ConvertContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new UnsupportedOperationException("Not implemented");
    }
}

