/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui;

import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.liquibase.common.config.LiquibaseChange;
import com.intellij.liquibase.common.config.LiquibaseChangesConfig;
import com.intellij.liquibase.common.gui.ChangeLogTreeBuilder;
import com.intellij.liquibase.common.gui.ChangeModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u001aH\u0004J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u001aH\u0014J\u001a\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J,\u0010&\u001a\u00020\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u00a4@\u00a2\u0006\u0002\u0010'R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006("}, d2={"Lcom/intellij/liquibase/common/gui/AbstractChangeLogTreeBuilder;", "Lcom/intellij/liquibase/common/gui/ChangeLogTreeBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "liquibaseChangesConfig", "Lcom/intellij/liquibase/common/config/LiquibaseChangesConfig;", "getLiquibaseChangesConfig", "()Lcom/intellij/liquibase/common/config/LiquibaseChangesConfig;", "rootNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getRootNode", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "setRootNode", "(Ljavax/swing/tree/DefaultMutableTreeNode;)V", "ignoredNode", "getIgnoredNode", "setIgnoredNode", "init", "", "changeLogs", "", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "Lcom/intellij/psi/xml/XmlTag;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "(Ljava/util/Map;Ljavax/swing/tree/DefaultTreeModel;Ljavax/swing/tree/DefaultMutableTreeNode;Ljavax/swing/tree/DefaultMutableTreeNode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addChange", "changeSetNode", "changeTag", "addChangeOrIgnore", "createChangeModel", "Lcom/intellij/liquibase/common/gui/ChangeModel;", "change", "Lcom/intellij/liquibase/common/config/LiquibaseChange;", "doInit", "(Ljava/util/Map;Ljavax/swing/tree/DefaultTreeModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nChangeLogTreeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeLogTreeBuilder.kt\ncom/intellij/liquibase/common/gui/AbstractChangeLogTreeBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,246:1\n13409#2,2:247\n13409#2:249\n13409#2,2:250\n13410#2:252\n*S KotlinDebug\n*F\n+ 1 ChangeLogTreeBuilder.kt\ncom/intellij/liquibase/common/gui/AbstractChangeLogTreeBuilder\n*L\n58#1:247,2\n63#1:249\n65#1:250,2\n63#1:252\n*E\n"})
public abstract class AbstractChangeLogTreeBuilder
implements ChangeLogTreeBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final LiquibaseChangesConfig liquibaseChangesConfig;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultMutableTreeNode ignoredNode;

    public AbstractChangeLogTreeBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.liquibaseChangesConfig = LiquibaseChangesConfig.Companion.getInstance(this.project);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final LiquibaseChangesConfig getLiquibaseChangesConfig() {
        return this.liquibaseChangesConfig;
    }

    @NotNull
    protected final DefaultMutableTreeNode getRootNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
        if (defaultMutableTreeNode != null) {
            return defaultMutableTreeNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rootNode");
        return null;
    }

    protected final void setRootNode(@NotNull DefaultMutableTreeNode defaultMutableTreeNode) {
        Intrinsics.checkNotNullParameter((Object)defaultMutableTreeNode, (String)"<set-?>");
        this.rootNode = defaultMutableTreeNode;
    }

    @NotNull
    protected final DefaultMutableTreeNode getIgnoredNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.ignoredNode;
        if (defaultMutableTreeNode != null) {
            return defaultMutableTreeNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"ignoredNode");
        return null;
    }

    protected final void setIgnoredNode(@NotNull DefaultMutableTreeNode defaultMutableTreeNode) {
        Intrinsics.checkNotNullParameter((Object)defaultMutableTreeNode, (String)"<set-?>");
        this.ignoredNode = defaultMutableTreeNode;
    }

    @Override
    @Nullable
    public Object init(@NotNull Map<DataStore, ? extends XmlTag> changeLogs, @NotNull DefaultTreeModel treeModel, @NotNull DefaultMutableTreeNode rootNode, @NotNull DefaultMutableTreeNode ignoredNode, @NotNull Continuation<? super Unit> $completion) {
        return AbstractChangeLogTreeBuilder.init$suspendImpl(this, changeLogs, treeModel, rootNode, ignoredNode, $completion);
    }

    static /* synthetic */ Object init$suspendImpl(AbstractChangeLogTreeBuilder $this, Map<DataStore, ? extends XmlTag> changeLogs, DefaultTreeModel treeModel, DefaultMutableTreeNode rootNode, DefaultMutableTreeNode ignoredNode, Continuation<? super Unit> $completion) {
        Object object = treeModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        $this.setRootNode((DefaultMutableTreeNode)object);
        $this.setIgnoredNode(ignoredNode);
        Object object2 = $this.doInit(changeLogs, treeModel, $completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    protected final void addChange(@NotNull DefaultMutableTreeNode changeSetNode, @NotNull XmlTag changeTag) {
        String dropColumnName;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)changeSetNode, (String)"changeSetNode");
        Intrinsics.checkNotNullParameter((Object)changeTag, (String)"changeTag");
        String string = changeTag.getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
        String tagName = string;
        if (Intrinsics.areEqual((Object)"dropColumn", (Object)tagName) && !((charSequence = (CharSequence)(dropColumnName = changeTag.getAttributeValue("columnName"))) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            PsiElement psiElement = changeTag.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
            XmlTag copyDropTag = (XmlTag)psiElement;
            XmlTag[] xmlTagArray = copyDropTag.getSubTags();
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"getSubTags(...)");
            Object[] $this$forEach$iv = xmlTagArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XmlTag it = (XmlTag)element$iv;
                boolean bl = false;
                it.delete();
            }
            this.addChangeOrIgnore(changeSetNode, copyDropTag);
        }
        if (Intrinsics.areEqual((Object)"addColumn", (Object)tagName) || Intrinsics.areEqual((Object)"dropColumn", (Object)tagName)) {
            XmlTag[] xmlTagArray = changeTag.findSubTags("column");
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"findSubTags(...)");
            Object[] $this$forEach$iv = xmlTagArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XmlTag columnTag = (XmlTag)element$iv;
                boolean bl = false;
                PsiElement psiElement = changeTag.copy();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
                XmlTag copyTag = (XmlTag)psiElement;
                XmlTag[] xmlTagArray2 = copyTag.getSubTags();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray2, (String)"getSubTags(...)");
                Object[] $this$forEach$iv2 = xmlTagArray2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    XmlTag it = (XmlTag)element$iv2;
                    boolean bl2 = false;
                    it.delete();
                }
                PsiElement psiElement2 = columnTag.copy();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
                copyTag.addSubTag((XmlTag)psiElement2, false);
                this.addChangeOrIgnore(changeSetNode, copyTag);
            }
        } else {
            this.addChangeOrIgnore(changeSetNode, changeTag);
        }
    }

    protected void addChangeOrIgnore(@NotNull DefaultMutableTreeNode changeSetNode, @NotNull XmlTag changeTag) {
        Intrinsics.checkNotNullParameter((Object)changeSetNode, (String)"changeSetNode");
        Intrinsics.checkNotNullParameter((Object)changeTag, (String)"changeTag");
        String string = changeTag.getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalName(...)");
        String tagName = string;
        LiquibaseChange change = this.liquibaseChangesConfig.findChangeByTagName(tagName);
        DefaultMutableTreeNode changeNode = new DefaultMutableTreeNode(this.createChangeModel(changeTag, change));
        if (this.liquibaseChangesConfig.isChangeIgnored(changeTag, change)) {
            this.getIgnoredNode().add(changeNode);
        } else {
            changeSetNode.add(changeNode);
        }
    }

    @NotNull
    protected ChangeModel createChangeModel(@NotNull XmlTag changeTag, @Nullable LiquibaseChange change) {
        Intrinsics.checkNotNullParameter((Object)changeTag, (String)"changeTag");
        Object object = change;
        if (object == null || (object = object.getDangerLevel()) == null) {
            object = LiquibaseChange.DangerLevel.SAFE;
        }
        return new ChangeModel(changeTag, (LiquibaseChange.DangerLevel)((Object)object));
    }

    @Nullable
    protected abstract Object doInit(@NotNull Map<DataStore, ? extends XmlTag> var1, @NotNull DefaultTreeModel var2, @NotNull Continuation<? super Unit> var3);
}

