/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentDescriptorReusePolicy;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaRunContentExecutor
implements Disposable {
    private final Project myProject;
    private final ProcessHandler myProcess;
    private final List<Filter> myFilterList;
    private Runnable myRerunAction;
    private Runnable myStopAction;
    private ProcessAdapter myProcessAdapter;
    private Computable<Boolean> myStopEnabled;
    @NlsContexts.TabTitle
    private String myTitle;
    private Icon myIcon;
    private String myHelpId;
    private boolean myActivateToolWindow;
    private boolean myFocusToolWindow;
    private ConsoleView myUserProvidedConsole;

    public JpaRunContentExecutor(@NotNull Project project, @NotNull ProcessHandler process) {
        if (project == null) {
            JpaRunContentExecutor.$$$reportNull$$$0(0);
        }
        if (process == null) {
            JpaRunContentExecutor.$$$reportNull$$$0(1);
        }
        this.myFilterList = new ArrayList<Filter>();
        this.myTitle = CommonBundle.message((String)"title.output", (Object[])new Object[0]);
        this.myIcon = null;
        this.myHelpId = null;
        this.myActivateToolWindow = true;
        this.myFocusToolWindow = true;
        this.myProject = project;
        this.myProcess = process;
    }

    public JpaRunContentExecutor withFilter(Filter filter) {
        this.myFilterList.add(filter);
        return this;
    }

    public JpaRunContentExecutor withIcon(Icon icon) {
        this.myIcon = icon;
        return this;
    }

    public JpaRunContentExecutor withTitle(@NlsContexts.TabTitle String title) {
        this.myTitle = title;
        return this;
    }

    public JpaRunContentExecutor withRerun(Runnable rerun) {
        this.myRerunAction = rerun;
        return this;
    }

    public JpaRunContentExecutor withStop(@NotNull Runnable stop, @NotNull Computable<Boolean> stopEnabled) {
        if (stop == null) {
            JpaRunContentExecutor.$$$reportNull$$$0(2);
        }
        if (stopEnabled == null) {
            JpaRunContentExecutor.$$$reportNull$$$0(3);
        }
        this.myStopAction = stop;
        this.myStopEnabled = stopEnabled;
        return this;
    }

    public JpaRunContentExecutor withProcessAdapter(ProcessAdapter processAdapter) {
        this.myProcessAdapter = processAdapter;
        return this;
    }

    public JpaRunContentExecutor withHelpId(String helpId) {
        this.myHelpId = helpId;
        return this;
    }

    public JpaRunContentExecutor withActivateToolWindow(boolean activateToolWindow) {
        this.myActivateToolWindow = activateToolWindow;
        return this;
    }

    public JpaRunContentExecutor withFocusToolWindow(boolean focusToolWindow) {
        this.myFocusToolWindow = focusToolWindow;
        return this;
    }

    private ConsoleView createConsole() {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
        consoleBuilder.filters(this.myFilterList);
        ConsoleView console = consoleBuilder.getConsole();
        if (this.myHelpId != null) {
            console.setHelpId(this.myHelpId);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        JComponent consolePanel = JpaRunContentExecutor.createConsolePanel(console, (ActionGroup)actions);
        final RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)console, this.myProcess, consolePanel, this.myTitle, this.myIcon);
        descriptor.setReusePolicy(new RunContentDescriptorReusePolicy(){

            public boolean canBeReusedBy(@NotNull RunContentDescriptor newDescriptor) {
                if (newDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return newDescriptor.getDisplayName().equals(descriptor.getDisplayName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDescriptor", "com/intellij/liquibase/common/gui/JpaRunContentExecutor$1", "canBeReusedBy"));
            }
        });
        descriptor.setActivateToolWindowWhenAdded(this.myActivateToolWindow);
        descriptor.setAutoFocusContent(this.myFocusToolWindow);
        Disposer.register((Disposable)descriptor, (Disposable)this);
        Disposer.register((Disposable)descriptor, (Disposable)console);
        actions.add((AnAction)new RerunAction(consolePanel));
        actions.add((AnAction)new StopAction());
        actions.add((AnAction)new CloseAction(executor, descriptor, this.myProject));
        RunContentManager.getInstance((Project)this.myProject).showRunContent(executor, descriptor);
        return console;
    }

    public void run() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ConsoleView view = this.myUserProvidedConsole != null ? this.myUserProvidedConsole : this.createConsole();
        view.attachToProcess(this.myProcess);
        if (this.myProcessAdapter != null) {
            this.myProcess.addProcessListener((ProcessListener)this.myProcessAdapter);
        }
        this.myProcess.startNotify();
    }

    private static JComponent createConsolePanel(ConsoleView view, ActionGroup actions) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)view.getComponent(), "Center");
        panel.add((Component)JpaRunContentExecutor.createToolbar(actions), "West");
        return panel;
    }

    private static JComponent createToolbar(ActionGroup actions) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("RunContentExecutor", actions, false);
        return actionToolbar.getComponent();
    }

    public void dispose() {
    }

    @NotNull
    public JpaRunContentExecutor withConsole(@Nullable ConsoleView console) {
        this.myUserProvidedConsole = console;
        JpaRunContentExecutor jpaRunContentExecutor = this;
        if (jpaRunContentExecutor == null) {
            JpaRunContentExecutor.$$$reportNull$$$0(4);
        }
        return jpaRunContentExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stop";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopEnabled";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/liquibase/common/gui/JpaRunContentExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/liquibase/common/gui/JpaRunContentExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withStop";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private class RerunAction
    extends AnAction {
        RerunAction(JComponent consolePanel) {
            super(CommonBundle.message((String)"action.text.rerun", (Object[])new Object[0]), CommonBundle.message((String)"action.text.rerun", (Object[])new Object[0]), AllIcons.Actions.Restart);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consolePanel);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            JpaRunContentExecutor.this.myRerunAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabledAndVisible(JpaRunContentExecutor.this.myRerunAction != null);
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/liquibase/common/gui/JpaRunContentExecutor$RerunAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/liquibase/common/gui/JpaRunContentExecutor$RerunAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private class StopAction
    extends AnAction
    implements DumbAware {
        StopAction() {
            super(ExecutionBundle.messagePointer((String)"action.AnAction.text.stop", (Object[])new Object[0]), ExecutionBundle.messagePointer((String)"action.AnAction.description.stop", (Object[])new Object[0]), AllIcons.Actions.Suspend);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                StopAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(1);
            }
            JpaRunContentExecutor.this.myStopAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setVisible(JpaRunContentExecutor.this.myStopAction != null);
            e.getPresentation().setEnabled(JpaRunContentExecutor.this.myStopEnabled != null && (Boolean)JpaRunContentExecutor.this.myStopEnabled.compute() != false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/liquibase/common/gui/JpaRunContentExecutor$StopAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/liquibase/common/gui/JpaRunContentExecutor$StopAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

