/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui.settings.db;

import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.liquibase.common.LiquibaseConstant;
import com.intellij.liquibase.common.config.ChangesetTemplateConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.gui.settings.db.LiquibasePanel;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/LiquibaseChangesetTemplatesPanel;", "Lcom/intellij/liquibase/common/gui/settings/db/LiquibasePanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tags", "", "", "getTags", "()Ljava/util/List;", "table", "Lcom/intellij/liquibase/common/gui/settings/db/LiquibaseChangesetTemplatesPanel$ChangesetTable;", "config", "Lcom/intellij/liquibase/common/config/DatabaseMigrationConfig;", "actionListeners", "", "Ljava/awt/event/ActionListener;", "loadFromState", "", "saveToState", "addActionListener", "listener", "ChangesetTable", "CheckBoxColumnInfo", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nLiquibaseChangesetTemplatesPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseChangesetTemplatesPanel.kt\ncom/intellij/liquibase/common/gui/settings/db/LiquibaseChangesetTemplatesPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n295#2,2:140\n230#2,2:143\n295#2,2:145\n1#3:142\n*S KotlinDebug\n*F\n+ 1 LiquibaseChangesetTemplatesPanel.kt\ncom/intellij/liquibase/common/gui/settings/db/LiquibaseChangesetTemplatesPanel\n*L\n51#1:140,2\n61#1:143,2\n62#1:145,2\n*E\n"})
public final class LiquibaseChangesetTemplatesPanel
extends LiquibasePanel {
    @NotNull
    private final List<String> tags;
    @NotNull
    private final ChangesetTable table;
    @NotNull
    private final DatabaseMigrationConfig config;
    @NotNull
    private final List<ActionListener> actionListeners;

    public LiquibaseChangesetTemplatesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        Object[] objectArray = new String[]{"addAutoIncrement", "addColumn", "addLookupTable", "addDefaultValue", "addNotNullConstraint", "addForeignKeyConstraint", "addPrimaryKey", "addUniqueConstraint", "createIndex", "createSequence", "createTable", "createView", "createProcedure", "dropColumn", "dropSequence", "dropNotNullConstraint", "dropForeignKeyConstraint", "dropIndex", "dropDefaultValue", "dropPrimaryKey", "dropTable", "dropUniqueConstraint", "dropProcedure", "renameColumn", "renameSequence", "renameTable", "renameView", "delete", "customChange", "alterSequence", "insert", "update", "loadData", "loadUpdateData", "mergeColumns", "modifyDataType", "setTableRemarks", "setColumnRemarks"};
        this.tags = CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])objectArray));
        this.table = new ChangesetTable();
        this.config = DatabaseMigrationConfig.Companion.getInstance(project);
        this.actionListeners = new ArrayList();
        this.setLayout(new BorderLayout(0, 8));
        this.add((Component)new JBScrollPane((Component)((Object)this.table)));
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)LiquibaseResourceBundle.message("changeSet.templates", new Object[0]), (boolean)false, (Insets)((Insets)JBUI.insetsTop((int)JBUI.scale((int)4)))));
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadFromState() {
        List<ChangesetTemplateConfig> originalConfigs = this.config.getState().getLiquibaseChangesetTemplates();
        List tmpConfigs = new ArrayList();
        for (String tag : this.tags) {
            ChangesetTemplateConfig changesetTemplateConfig;
            Object v0;
            List list;
            block4: {
                void $this$firstOrNull$iv;
                Iterable iterable = originalConfigs;
                list = tmpConfigs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ChangesetTemplateConfig it = (ChangesetTemplateConfig)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)tag)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            List list2 = list;
            ChangesetTemplateConfig changesetTemplateConfig2 = v0;
            if (changesetTemplateConfig2 != null) {
                void it;
                ChangesetTemplateConfig changesetTemplateConfig3 = changesetTemplateConfig2;
                list = list2;
                boolean bl = false;
                changesetTemplateConfig = new ChangesetTemplateConfig((ChangesetTemplateConfig)it);
                list2 = list;
            } else {
                changesetTemplateConfig = new ChangesetTemplateConfig(tag);
            }
            list2.add(changesetTemplateConfig);
        }
        this.table.getListTableModel().addRows((Collection)tmpConfigs);
        this.table.updateUI();
    }

    @Override
    public void saveToState() {
        List list = this.table.getListTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List sourceConfigs = list;
        List<ChangesetTemplateConfig> targetConfigs = this.config.getState().getLiquibaseChangesetTemplates();
        for (String tag : this.tags) {
            Object v1;
            ChangesetTemplateConfig sourceConfig;
            block5: {
                Object element$iv2;
                block4: {
                    Iterable $this$first$iv = sourceConfigs;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ChangesetTemplateConfig it = (ChangesetTemplateConfig)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)tag)) continue;
                        break block4;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                sourceConfig = (ChangesetTemplateConfig)element$iv2;
                Iterable $this$firstOrNull$iv = targetConfigs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv3 : $this$firstOrNull$iv) {
                    ChangesetTemplateConfig it = (ChangesetTemplateConfig)element$iv3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)tag)) continue;
                    v1 = element$iv3;
                    break block5;
                }
                v1 = null;
            }
            ChangesetTemplateConfig targetConfig = v1;
            if (targetConfig != null) {
                if (sourceConfig.equals(targetConfig)) continue;
                Intrinsics.checkNotNull((Object)sourceConfig);
                targetConfig.copyFrom(sourceConfig);
                continue;
            }
            if (sourceConfig.equals(new ChangesetTemplateConfig(tag))) continue;
            Intrinsics.checkNotNull((Object)sourceConfig);
            targetConfigs.add(new ChangesetTemplateConfig(sourceConfig));
        }
    }

    public final void addActionListener(@NotNull ActionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.actionListeners.add(listener);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/LiquibaseChangesetTemplatesPanel$ChangesetTable;", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/liquibase/common/config/ChangesetTemplateConfig;", "<init>", "(Lcom/intellij/liquibase/common/gui/settings/db/LiquibaseChangesetTemplatesPanel;)V", "intellij.liquibase.common"})
    private final class ChangesetTable
    extends TableView<ChangesetTemplateConfig> {
        public ChangesetTable() {
            ColumnInfo[] columnInfoArray = new ColumnInfo[4];
            String string = JpaModelBundle.message((String)"name", (Object[])new Object[0]);
            columnInfoArray[0] = new ColumnInfo<ChangesetTemplateConfig, String>(string){

                public String valueOf(ChangesetTemplateConfig item) {
                    ChangesetTemplateConfig changesetTemplateConfig = item;
                    return changesetTemplateConfig != null ? changesetTemplateConfig.getName() : null;
                }

                public boolean isCellEditable(ChangesetTemplateConfig item) {
                    return false;
                }
            };
            columnInfoArray[1] = new CheckBoxColumnInfo(){

                public Boolean valueOf(ChangesetTemplateConfig item) {
                    ChangesetTemplateConfig changesetTemplateConfig = item;
                    return changesetTemplateConfig != null ? Intrinsics.areEqual((Object)changesetTemplateConfig.getFailOnError(), (Object)true) : false;
                }

                public void setValue(ChangesetTemplateConfig item, Boolean value) {
                    block2: {
                        Iterable $this$forEach$iv = LiquibaseChangesetTemplatesPanel.this.actionListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ActionListener it = (ActionListener)element$iv;
                            boolean bl = false;
                            it.actionPerformed(new ActionEvent(item, 0, ""));
                        }
                        ChangesetTemplateConfig changesetTemplateConfig = item;
                        if (changesetTemplateConfig == null) break block2;
                        Boolean bl = value;
                        if (bl == null) {
                            bl = false;
                        }
                        changesetTemplateConfig.setFailOnError(bl);
                    }
                }
            };
            columnInfoArray[2] = new CheckBoxColumnInfo(){

                public Boolean valueOf(ChangesetTemplateConfig item) {
                    ChangesetTemplateConfig changesetTemplateConfig = item;
                    return changesetTemplateConfig != null ? Intrinsics.areEqual((Object)changesetTemplateConfig.getRunOnChange(), (Object)true) : false;
                }

                public void setValue(ChangesetTemplateConfig item, Boolean value) {
                    block2: {
                        Iterable $this$forEach$iv = LiquibaseChangesetTemplatesPanel.this.actionListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ActionListener it = (ActionListener)element$iv;
                            boolean bl = false;
                            it.actionPerformed(new ActionEvent(item, 0, ""));
                        }
                        ChangesetTemplateConfig changesetTemplateConfig = item;
                        if (changesetTemplateConfig == null) break block2;
                        Boolean bl = value;
                        if (bl == null) {
                            bl = false;
                        }
                        changesetTemplateConfig.setRunOnChange(bl);
                    }
                }
            };
            string = LiquibaseResourceBundle.message("changeSet.createPreconditions", new Object[0]);
            columnInfoArray[3] = new CheckBoxColumnInfo(string){
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($super_call_param$1);
                }

                public Boolean valueOf(ChangesetTemplateConfig item) {
                    if (item == null || !LiquibaseConstant.isPreconditionAvailable(item.getName())) {
                        return null;
                    }
                    return item.getCreatePrecondition();
                }

                public void setValue(ChangesetTemplateConfig item, Boolean value) {
                    block1: {
                        Iterable $this$forEach$iv = LiquibaseChangesetTemplatesPanel.this.actionListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ActionListener it = (ActionListener)element$iv;
                            boolean bl = false;
                            it.actionPerformed(new ActionEvent(item, 0, ""));
                        }
                        ChangesetTemplateConfig changesetTemplateConfig = item;
                        if (changesetTemplateConfig == null) break block1;
                        Boolean bl = value;
                        changesetTemplateConfig.setCreatePrecondition(bl != null ? bl : false);
                    }
                }

                @Override
                public boolean isCellEditable(ChangesetTemplateConfig item) {
                    return item != null && LiquibaseConstant.isPreconditionAvailable(item.getName());
                }
            };
            this.setModelAndUpdateColumns(new ListTableModel(columnInfoArray));
            this.setSelectionMode(0);
            this.autoResizeMode = 3;
            this.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)200, (int)-1));
            this.setVisibleRowCount(7);
            this.rowHeight = JBUI.scale((int)32);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/LiquibaseChangesetTemplatesPanel$CheckBoxColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/liquibase/common/config/ChangesetTemplateConfig;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "isCellEditable", "item", "getColumnClass", "Ljava/lang/Class;", "intellij.liquibase.common"})
    public static abstract class CheckBoxColumnInfo
    extends ColumnInfo<ChangesetTemplateConfig, Boolean> {
        public CheckBoxColumnInfo(@NlsContexts.ColumnName @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name);
        }

        public boolean isCellEditable(@Nullable ChangesetTemplateConfig item) {
            return true;
        }

        @NotNull
        public Class<?> getColumnClass() {
            return Boolean.TYPE;
        }
    }
}

