/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.mapping;

import com.intellij.jpa.jpb.model.backend.ed.ddl.DbDialect;
import com.intellij.jpa.jpb.model.backend.ed.ddl.MssqlDbDialect;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MssqlType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.HibernateTypes;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.mapping.ReMappingSettings;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import liquibase.structure.core.DataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u001c0\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\nH\u0016R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR&\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/intellij/liquibase/common/mapping/MssqlReMappingSettings;", "Lcom/intellij/liquibase/common/mapping/ReMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/MssqlType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/MssqlType;)V", "mappingTypes", "", "", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "()Ljava/util/Map;", "sqlTypeToJdbcTypeCode", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getSqlTypeToJdbcTypeCode", "sqlSynonymTypes", "", "getSqlSynonymTypes", "isLobStringType", "", "dataType", "Lliquibase/structure/core/DataType;", "getDbDialect", "Lcom/intellij/jpa/jpb/model/backend/ed/ddl/DbDialect;", "getTemporalTypeMappings", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute$TemporalType;", "", "useColumnDefinition", "sqlType", "lengthUnlessTypes", "getLengthUnlessTypes", "()[Ljava/lang/String;", "intellij.liquibase.common"})
public final class MssqlReMappingSettings
extends ReMappingSettings {
    @NotNull
    private final Map<String, HibernateSqlType> sqlTypeToJdbcTypeCode;

    public MssqlReMappingSettings(@NotNull Project project, @NotNull MssqlType dbType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        super(project, (DbType)dbType);
        this.sqlTypeToJdbcTypeCode = MapsKt.mapOf((Pair)TuplesKt.to((Object)"xml", (Object)HibernateSqlType.SQLXML));
    }

    @Override
    @NotNull
    public Map<String, Datatypes.BasicDatatype> getMappingTypes() {
        boolean isHibernate6Project = JpaUtils.isHibernate6Project((Project)this.getProject());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bigint", (Object)Datatypes.BasicDatatype.Long), TuplesKt.to((Object)"decimal", (Object)Datatypes.BasicDatatype.BigDecimal), TuplesKt.to((Object)"bit", (Object)Datatypes.BasicDatatype.Boolean), TuplesKt.to((Object)"int", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"smallint", (Object)Datatypes.BasicDatatype.Short), TuplesKt.to((Object)"tinyint", (Object)Datatypes.BasicDatatype.Short), TuplesKt.to((Object)"money", (Object)Datatypes.BasicDatatype.BigDecimal), TuplesKt.to((Object)"smallmoney", (Object)Datatypes.BasicDatatype.BigDecimal), TuplesKt.to((Object)"float", (Object)Datatypes.BasicDatatype.Double), TuplesKt.to((Object)"real", (Object)Datatypes.BasicDatatype.Float), TuplesKt.to((Object)"date", (Object)Datatypes.BasicDatatype.LocalDate), TuplesKt.to((Object)"datetime2", (Object)Datatypes.BasicDatatype.Instant), TuplesKt.to((Object)"datetime", (Object)Datatypes.BasicDatatype.Instant), TuplesKt.to((Object)"smalldatetime", (Object)Datatypes.BasicDatatype.Instant), TuplesKt.to((Object)"datetimeoffset", (Object)Datatypes.BasicDatatype.OffsetDateTime), TuplesKt.to((Object)"time", (Object)Datatypes.BasicDatatype.LocalTime), TuplesKt.to((Object)"char(1)", (Object)Datatypes.BasicDatatype.Character), TuplesKt.to((Object)"char", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"varchar", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"text", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"nchar", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"nvarchar", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"ntext", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"binary", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"varbinary", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"image", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"uniqueidentifier", (Object)Datatypes.BasicDatatype.UUID), TuplesKt.to((Object)"xml", (Object)(isHibernate6Project ? HibernateTypes.INSTANCE.getMapStringToObject() : Datatypes.BasicDatatype.String))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Map<String, HibernateSqlType> getSqlTypeToJdbcTypeCode() {
        return this.sqlTypeToJdbcTypeCode;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        Pair[] pairArray = new Pair[10];
        Object[] objectArray = new String[]{"long", "long identity", "bigint identity"};
        pairArray[0] = TuplesKt.to((Object)"bigint", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"integer", "int identity", "integer identity"};
        pairArray[1] = TuplesKt.to((Object)"int", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[2] = TuplesKt.to((Object)"char", (Object)CollectionsKt.listOf((Object)"character"));
        pairArray[3] = TuplesKt.to((Object)"nchar", (Object)CollectionsKt.listOf((Object)"ncharacter"));
        pairArray[4] = TuplesKt.to((Object)"varchar", (Object)CollectionsKt.listOf((Object)"character varying"));
        pairArray[5] = TuplesKt.to((Object)"nvarchar", (Object)CollectionsKt.listOf((Object)"ncharacter varying"));
        pairArray[6] = TuplesKt.to((Object)"varbinary", (Object)CollectionsKt.listOf((Object)"binary varying"));
        objectArray = new String[]{"numeric", "dec"};
        pairArray[7] = TuplesKt.to((Object)"decimal", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"double precision", "double"};
        pairArray[8] = TuplesKt.to((Object)"float", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[9] = TuplesKt.to((Object)"timestamp", (Object)CollectionsKt.listOf((Object)"rowversion"));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public boolean isLobStringType(@NotNull DataType dataType) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
                Integer columnSize = dataType.getColumnSize();
                if (super.isLobStringType(dataType)) break block2;
                if (columnSize == null) break block3;
                int n = -1;
                if (columnSize != n) break block3;
            }
            return true;
        }
        String string = dataType.getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String sqlType = string2;
        Object[] objectArray = new String[]{"text", "ntext"};
        return ArraysKt.contains((Object[])objectArray, (Object)sqlType);
    }

    @Override
    @NotNull
    public DbDialect getDbDialect() {
        MssqlDbDialect mssqlDbDialect = MssqlDbDialect.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)mssqlDbDialect, (String)"INSTANCE");
        return (DbDialect)mssqlDbDialect;
    }

    @Override
    @NotNull
    public Map<EntityAttribute.TemporalType, String[]> getTemporalTypeMappings() {
        Pair[] pairArray = new Pair[3];
        String[] stringArray = new String[]{"date"};
        pairArray[0] = TuplesKt.to((Object)EntityAttribute.TemporalType.DATE, (Object)stringArray);
        stringArray = new String[]{"time"};
        pairArray[1] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIME, (Object)stringArray);
        stringArray = new String[]{"datetime", "datetime2", "smalldatetime", "datetimeoffset"};
        pairArray[2] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIMESTAMP, (Object)stringArray);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public boolean useColumnDefinition(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        return super.useColumnDefinition(sqlType) || StringsKt.equals((String)"tinyint", (String)sqlType, (boolean)true);
    }

    @Override
    @NotNull
    protected String[] getLengthUnlessTypes() {
        String[] stringArray = new String[]{"tinyint"};
        return stringArray;
    }
}

