/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.util;

import com.intellij.liquibase.common.util.AbstractPresentableProcessor;
import com.intellij.liquibase.common.util.LiquibaseChangelogItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/liquibase/common/util/RenamePresentableProcessor;", "Lcom/intellij/liquibase/common/util/AbstractPresentableProcessor;", "tagName", "", "oldName", "newName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getOldName", "()Ljava/lang/String;", "getNewName", "process", "item", "Lcom/intellij/liquibase/common/util/LiquibaseChangelogItem;", "intellij.liquibase.common"})
final class RenamePresentableProcessor
extends AbstractPresentableProcessor {
    @NotNull
    private final String oldName;
    @NotNull
    private final String newName;

    public RenamePresentableProcessor(@NotNull String tagName, @NotNull String oldName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        String[] stringArray = new String[]{tagName};
        super(stringArray);
        this.oldName = oldName;
        this.newName = newName;
    }

    @NotNull
    public final String getOldName() {
        return this.oldName;
    }

    @NotNull
    public final String getNewName() {
        return this.newName;
    }

    @Override
    @Nullable
    public String process(@NotNull LiquibaseChangelogItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        String oldNameValue = item.getAttributeValue(this.oldName);
        String newNameValue = item.getAttributeValue(this.newName);
        CharSequence charSequence = oldNameValue;
        if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)newNameValue) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return null;
        }
        return oldNameValue + " -> " + newNameValue;
    }
}

