/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.database;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.liquibase.common.UltimateDatabaseFactory;
import com.intellij.liquibase.database.DataStoreUtilsKt;
import com.intellij.liquibase.database.ext.intellij.das.DasDatabase;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.MockDatabaseConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\r0\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/liquibase/database/DasDatabaseFactory;", "Lcom/intellij/liquibase/common/UltimateDatabaseFactory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createDatabase", "Lliquibase/database/Database;", "dbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "refreshDataSource", "", "dataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "refreshedConsumer", "Lkotlin/Function1;", "", "intellij.liquibase.database"})
@SourceDebugExtension(value={"SMAP\nDasDatabaseFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DasDatabaseFactory.kt\ncom/intellij/liquibase/database/DasDatabaseFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n295#2,2:59\n1#3:61\n*S KotlinDebug\n*F\n+ 1 DasDatabaseFactory.kt\ncom/intellij/liquibase/database/DasDatabaseFactory\n*L\n25#1:59,2\n*E\n"})
public final class DasDatabaseFactory
implements UltimateDatabaseFactory {
    @NotNull
    private final Project project;

    public DasDatabaseFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public Database createDatabase(@NotNull DbProperties dbProperties) {
        DasDatabase dasDatabase;
        block4: {
            Object v4;
            block3: {
                Intrinsics.checkNotNullParameter((Object)dbProperties, (String)"dbProperties");
                String string = dbProperties.getUrlWithoutParams();
                if (string == null) {
                    return null;
                }
                String propsUrl = string;
                List list = DbPsiFacade.getInstance((Project)this.project).getDataSources();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DbDataSource it = (DbDataSource)element$iv;
                    boolean bl = false;
                    Object object = it.getConnectionConfig();
                    boolean bl2 = object != null && (object = object.getUrl()) != null ? StringsKt.startsWith$default((String)object, (String)propsUrl, (boolean)false, (int)2, null) : false;
                    if (!bl2) continue;
                    v4 = element$iv;
                    break block3;
                }
                v4 = null;
            }
            DbDataSource dataSource = v4;
            if (dataSource == null) {
                return null;
            }
            dasDatabase = new DasDatabase(dataSource, dbProperties);
            dasDatabase.setConnection((DatabaseConnection)new MockDatabaseConnection());
            String string = dbProperties.getCurrentSchema();
            if (string == null) break block4;
            String it = string;
            boolean bl = false;
            dasDatabase.setDefaultSchemaName(it);
        }
        return dasDatabase;
    }

    @Override
    public void refreshDataSource(@NotNull AbstractRdbmsStore dataStore, @NotNull Function1<? super Throwable, Unit> refreshedConsumer) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
            Intrinsics.checkNotNullParameter(refreshedConsumer, (String)"refreshedConsumer");
            List list = DataSourceStorage.getProjectStorage((Project)this.project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                LocalDataSource it = (LocalDataSource)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!DataStoreUtilsKt.isSame((DasDataSource)it, dataStore)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        LocalDataSource localDataSource = v1;
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ideaDataSource = localDataSource;
        DataSourceUtil.performManualSyncTask((LoaderContext)LoaderContext.selectGeneralTask((Project)this.project, (LocalDataSource)ideaDataSource)).whenComplete(AsyncUtil.getPoolExecutor(), (arg_0, arg_1) -> DasDatabaseFactory.refreshDataSource$lambda$5((arg_0, arg_1) -> DasDatabaseFactory.refreshDataSource$lambda$4(refreshedConsumer, arg_0, arg_1), arg_0, arg_1));
    }

    private static final Unit refreshDataSource$lambda$4$lambda$3(Function1 $refreshedConsumer, Throwable $ex) {
        $refreshedConsumer.invoke((Object)$ex);
        return Unit.INSTANCE;
    }

    private static final Unit refreshDataSource$lambda$4(Function1 $refreshedConsumer, SyncQueue.SyncResult syncResult, Throwable ex) {
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> DasDatabaseFactory.refreshDataSource$lambda$4$lambda$3($refreshedConsumer, ex));
        return Unit.INSTANCE;
    }

    private static final void refreshDataSource$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

