/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.database;

import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbUtil;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.common.service.OpenDbConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/liquibase/database/OpenDbConsoleImpl;", "Lcom/intellij/liquibase/common/service/OpenDbConsole;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "openConsole", "", "url", "", "username", "text", "intellij.liquibase.database"})
@SourceDebugExtension(value={"SMAP\nOpenDbConsoleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenDbConsoleImpl.kt\ncom/intellij/liquibase/database/OpenDbConsoleImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n230#2,2:71\n1#3:73\n*S KotlinDebug\n*F\n+ 1 OpenDbConsoleImpl.kt\ncom/intellij/liquibase/database/OpenDbConsoleImpl\n*L\n25#1:71,2\n*E\n"})
public final class OpenDbConsoleImpl
implements OpenDbConsole {
    @NotNull
    private final Project project;

    public OpenDbConsoleImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void openConsole(@NotNull String url, @NotNull String username, @NotNull String text) {
        Object v7;
        block6: {
            Object element$iv;
            boolean bl;
            void $this$first$iv;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            JBIterable jBIterable = DbUtil.getDataSources((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getDataSources(...)");
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$first = false;
            Iterator iterator = $this$first$iv.iterator();
            do {
                if (!iterator.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
                element$iv = iterator.next();
                DbDataSource it = (DbDataSource)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                LocalDataSource localDataSource = DataSourceFun.getLocalDataSource((DasDataSource)((DasDataSource)it));
                if (Intrinsics.areEqual((Object)(localDataSource != null ? localDataSource.getUrl() : null), (Object)url)) {
                    LocalDataSource localDataSource2 = DataSourceFun.getLocalDataSource((DasDataSource)((DasDataSource)it));
                    if (Intrinsics.areEqual((Object)(localDataSource2 != null ? localDataSource2.getUsername() : null), (Object)username)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            DbDataSource dataSource = (DbDataSource)element$iv;
            if (dataSource == null) {
                return;
            }
            LightVirtualFile virtualFile = new LightVirtualFile();
            virtualFile.setContent(null, (CharSequence)text, false);
            PairConsumer consumer = (arg_0, arg_1) -> OpenDbConsoleImpl.openConsole$lambda$3(this, text, arg_0, arg_1);
            element$iv = DatabaseRunners.createDataSourceConsolesRunner((DbDataSource)dataSource, arg_0 -> OpenDbConsoleImpl.openConsole$lambda$5(arg_0 -> OpenDbConsoleImpl.openConsole$lambda$4(consumer, dataSource, arg_0), arg_0)).getSubRunners();
            Intrinsics.checkNotNullExpressionValue(element$iv, (String)"getSubRunners(...)");
            Object runners = element$iv;
            Object e = runners.get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.intellij.database.script.PersistenceConsoleProvider.Runner");
            PersistenceConsoleProvider.Runner runner = (PersistenceConsoleProvider.Runner)e;
            List list = runner.getSubRunners();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSubRunners(...)");
            List subRunners = list;
            if (subRunners.isEmpty()) {
                Object e2 = runners.get(0);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type com.intellij.database.script.PersistenceConsoleProvider.Runner");
                ((PersistenceConsoleProvider.Runner)e2).run();
                return;
            }
            Iterable iterable2 = subRunners;
            for (Object t : iterable2) {
                PersistenceConsoleProvider.Runner it = (PersistenceConsoleProvider.Runner)t;
                boolean bl3 = false;
                if (!it.isDefaultSubRunner()) continue;
                v7 = t;
                break block6;
            }
            v7 = null;
        }
        PersistenceConsoleProvider.Runner runner = v7;
        if (runner == null) return;
        runner.run();
    }

    private static final void openConsole$lambda$3$lambda$2$lambda$1(Document $doc, String $text) {
        int length;
        $doc.insertString(length, (CharSequence)((length = $doc.getTextLength()) == 0 ? $text : "\n" + $text));
    }

    private static final void openConsole$lambda$3$lambda$2(OpenDbConsoleImpl this$0, Document $doc, String $text) {
        CommandProcessor.getInstance().executeCommand(this$0.project, () -> OpenDbConsoleImpl.openConsole$lambda$3$lambda$2$lambda$1($doc, $text), LiquibaseResourceBundle.message("copy.query.to.console", new Object[0]), null);
    }

    private static final void openConsole$lambda$3(OpenDbConsoleImpl this$0, String $text, DbElement element, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DasNamespace namespace = element instanceof DasNamespace ? (DasNamespace)element : null;
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        if (doc != null) {
            ApplicationManager.getApplication().runWriteAction(() -> OpenDbConsoleImpl.openConsole$lambda$3$lambda$2(this$0, doc, $text));
        }
        FileEditorManager.getInstance((Project)this$0.project).openFile(file, true);
        DatabaseEditorHelper.openConsoleForFile((Project)this$0.project, (DasDataSource)((DasDataSource)element.getDataSource()), (DasNamespace)namespace, (VirtualFile)file);
    }

    private static final Unit openConsole$lambda$4(PairConsumer $consumer, DbDataSource $dataSource, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        $consumer.consume((Object)$dataSource, (Object)file);
        return Unit.INSTANCE;
    }

    private static final void openConsole$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

