/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.database;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.jpa.jpb.model.backend.ds.DbDriversManagerExtension;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.liquibase.database.DataStoreUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/liquibase/database/UDbDriversManagerExtension;", "Lcom/intellij/jpa/jpb/model/backend/ds/DbDriversManagerExtension;", "<init>", "()V", "getActualDriverURLs", "", "Ljava/net/URL;", "driverClassName", "", "(Ljava/lang/String;)[Ljava/net/URL;", "getClasspathElements", "", "Lcom/intellij/util/ui/classpath/SimpleClasspathElement;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "downloadDriversAndSaveState", "", "project", "Lcom/intellij/openapi/project/Project;", "dbTypes", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "successCallback", "Ljava/lang/Runnable;", "getCustomDataStores", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "getReverseEngineeringDataStores", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "intellij.liquibase.database"})
@SourceDebugExtension(value={"SMAP\nUDbDriversManagerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UDbDriversManagerExtension.kt\ncom/intellij/liquibase/database/UDbDriversManagerExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,89:1\n774#2:90\n865#2,2:91\n1368#2:93\n1454#2,5:94\n1368#2:99\n1454#2,5:100\n1368#2:107\n1454#2,5:108\n1368#2:113\n1454#2,5:114\n37#3,2:105\n*S KotlinDebug\n*F\n+ 1 UDbDriversManagerExtension.kt\ncom/intellij/liquibase/database/UDbDriversManagerExtension\n*L\n27#1:90\n27#1:91,2\n28#1:93\n28#1:94,5\n29#1:99\n29#1:100,5\n82#1:107\n82#1:108,5\n87#1:113\n87#1:114,5\n41#1:105,2\n*E\n"})
public final class UDbDriversManagerExtension
implements DbDriversManagerExtension {
    @NotNull
    public URL[] getActualDriverURLs(@NotNull String driverClassName) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        DatabaseDriver it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
        Collection collection = DatabaseDriverManager.getInstance().getDrivers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDrivers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DatabaseDriver)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getDriverClass(), (Object)driverClassName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DatabaseDriver driver = (DatabaseDriver)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)driver);
            list$iv$iv = this.getClasspathElements(driver);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SimpleClasspathElement)element$iv$iv;
            boolean bl = false;
            List list = it.getClassesRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getClassesRootUrls(...)");
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List classesRootUrls = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        for (String rootUrl : classesRootUrls) {
            File file;
            String path;
            Intrinsics.checkNotNullExpressionValue((Object)PathUtil.toPresentableUrl((String)rootUrl), (String)"toPresentableUrl(...)");
            if (!StringUtil.endsWithIgnoreCase((String)path, (String)".jar") || !(file = new File(path)).exists()) continue;
            result.add(file.toURI().toURL());
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new URL[0]);
    }

    private final List<SimpleClasspathElement> getClasspathElements(DatabaseDriver driver) {
        List list;
        if (driver instanceof DatabaseDriverImpl) {
            List list2 = ((DatabaseDriverImpl)driver).getAdditionalClasspathElements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAdditionalClasspathElements(...)");
            Collection collection = list2;
            List list3 = ((DatabaseDriverImpl)driver).getArtifactClasspathElements();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getArtifactClasspathElements(...)");
            list = CollectionsKt.plus((Collection)collection, (Iterable)list3);
        } else {
            List list4 = driver.getClasspathElements();
            Intrinsics.checkNotNull((Object)list4);
            list = list4;
        }
        return list;
    }

    public void downloadDriversAndSaveState(@NotNull Project project, @NotNull List<? extends DbType> dbTypes, @NotNull Runnable successCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dbTypes, (String)"dbTypes");
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        String driverClassMsg = (dbTypes.size() == 1 ? "class " : "classes ") + CollectionsKt.joinToString$default((Iterable)dbTypes, (CharSequence)", ", null, null, (int)0, null, UDbDriversManagerExtension::downloadDriversAndSaveState$lambda$3, (int)30, null);
        Object object = new Object[]{driverClassMsg};
        int res = Messages.showYesNoDialog((Project)project, (String)JpaModelBundle.message((String)"driver.0.not.found", (Object[])object), (String)JpaModelBundle.message((String)"driver.files.not.found", (Object[])new Object[0]), (String)JpaModelBundle.message((String)"download.driver.files", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
        if (res != 0) {
            return;
        }
        object = JpaModelBundle.message((String)"downloading.driver.files", (Object[])new Object[0]);
        new Task.Modal(project, dbTypes, successCallback, (String)object){
            final /* synthetic */ List<DbType> $dbTypes;
            final /* synthetic */ Runnable $successCallback;
            {
                this.$dbTypes = $dbTypes;
                this.$successCallback = $successCallback;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Application application = ApplicationManager.getApplication();
                for (DbType dbType : this.$dbTypes) {
                    NamedProgressive task;
                    LocalDataSource localDataSource = DataStoreUtils.Companion.createLocalDataSource(dbType);
                    Intrinsics.checkNotNullExpressionValue((Object)DatabaseDriverValidator.createDownloaderTask((LocalDataSource)localDataSource, null), (String)"createDownloaderTask(...)");
                    task.run(indicator);
                }
                application.invokeLater(this.$successCallback);
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DataStore> getCustomDataStores(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list = DataSourceStorage.getProjectStorage((Project)project).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LocalDataSource it = (LocalDataSource)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = DataStoreUtils.Companion.createDataStores(project, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DataStore> getReverseEngineeringDataStores(@NotNull Project project, @NotNull OrmFramework ormFramework) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        List list = DataSourceStorage.getProjectStorage((Project)project).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LocalDataSource it = (LocalDataSource)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = DataStoreUtils.Companion.createReverseEngineeringDataStores(project, it, ormFramework.getSupportedDbTypes());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final CharSequence downloadDriversAndSaveState$lambda$3(DbType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getDriverClass();
        if (string == null) {
            string = it.getClass().getName();
        }
        return "'" + string + "'";
    }
}

