/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij;

import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.CachedEntityAttributeModel;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.audit.AuditEntityAttribute;
import com.intellij.jpa.jpb.model.reference.TableAttributesInfo;
import com.intellij.liquibase.common.ColumnDefinitionType;
import com.intellij.liquibase.common.JavaType;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.HSqlUtil;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.UniqueConstraint;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LiquibaseUtils {
    public static final String SEQUENCE_ATTR = "sequence";
    public static final String SEQUENCE_OWNED_ATTR = "owned";

    @Nullable
    public static IntellijDatabase getIntellijDatabase(Database ... databases) {
        if (databases == null) {
            LiquibaseUtils.$$$reportNull$$$0(0);
        }
        return StreamEx.of((Object[])databases).select(IntellijDatabase.class).findFirst(intellijDatabase -> intellijDatabase.getConnection() instanceof JdbcConnection).orElse(null);
    }

    @Nullable
    public static IntellijDatabase getIntellijDatabase(@NotNull DatabaseSnapshot snapshot) {
        Database database;
        if (snapshot == null) {
            LiquibaseUtils.$$$reportNull$$$0(1);
        }
        return (database = snapshot.getDatabase()) instanceof IntellijDatabase ? (IntellijDatabase)database : null;
    }

    public static List<Relation> getTables(DatabaseObject object) {
        if (object instanceof ForeignKey) {
            return Arrays.asList(((ForeignKey)object).getForeignKeyTable(), ((ForeignKey)object).getPrimaryKeyTable());
        }
        if (object instanceof Column) {
            return Arrays.asList(((Column)object).getRelation());
        }
        if (object instanceof Relation) {
            return Collections.singletonList((Relation)object);
        }
        if (object instanceof Index) {
            return Arrays.asList(((Index)object).getRelation());
        }
        if (object instanceof PrimaryKey) {
            return Arrays.asList(((PrimaryKey)object).getTable());
        }
        if (object instanceof UniqueConstraint) {
            return Arrays.asList(((UniqueConstraint)object).getRelation());
        }
        return Collections.emptyList();
    }

    public static DbType getDatabaseType(Database database) {
        String productName = database.getDatabaseProductName();
        if (productName == null) {
            return null;
        }
        if (productName.startsWith("DB2")) {
            return DbType.DB2;
        }
        return switch (productName) {
            case "H2" -> DbType.H2;
            case "HyperSQL" -> DbType.HSQL;
            case "MySQL" -> DbType.MYSQL;
            case "PostgreSQL" -> DbType.POSTGRES;
            case "SQL Server" -> DbType.MSSQL;
            case "Oracle" -> DbType.ORACLE;
            case "MariaDB" -> DbType.MARIA;
            default -> null;
        };
    }

    public static void setColumnDatatype(Column column, IntellijDatabase database) {
        EntityAttribute idAttribute;
        LiquibaseGenerator liquibaseGenerator = database.getLiquibaseGenerator();
        Relation relation = column.getRelation();
        String tableName = relation.getName();
        Schema schema = relation.getSchema();
        String schemaName = schema == null || schema.isDefault() ? null : schema.getName();
        TableAttributesInfo tableAttributes = liquibaseGenerator.getTableAttributes(schemaName, tableName, database.getAllEntities());
        if (tableAttributes == null) {
            return;
        }
        Entity entity = tableAttributes.getEntity();
        String columnName = column.getName();
        EntityAttribute attribute = liquibaseGenerator.getAttributeByColumnName(entity, tableAttributes.getAttributes(), columnName);
        if (attribute == null) {
            return;
        }
        LiquibaseGenerationContext generationContext = database.getGenerationContext();
        DataTypeInfo dataTypeInfo = LiquibaseUtils.toLiquibaseDataType(liquibaseGenerator, entity, attribute, generationContext);
        DataType dataType = dataTypeInfo.dataType;
        column.setType(dataType);
        column.setAttribute("generationContext", (Object)generationContext.getId());
        JavaType javaType = dataTypeInfo.javaType;
        String defaultValue = javaType instanceof ColumnDefinitionType ? ((ColumnDefinitionType)javaType).getDefaultValue() : attribute.getDefaultValue();
        if (StringUtil.isNotEmpty((String)defaultValue)) {
            DataType parseType = javaType.toLiquibaseDataType(generationContext);
            String defaultValuesWithNoCasts = HSqlUtil.removeTypeCasts(defaultValue);
            if (!defaultValue.equals(defaultValuesWithNoCasts) || defaultValue.endsWith(")")) {
                column.setDefaultValue((Object)new DatabaseFunction(defaultValue));
            } else {
                column.setDefaultValue(HSqlUtil.parseValue((Database)database, defaultValue, parseType));
            }
        }
        if (javaType instanceof ColumnDefinitionType && ((ColumnDefinitionType)javaType).isNotNull()) {
            column.setNullable(Boolean.valueOf(false));
        } else {
            column.setNullable(Boolean.valueOf(!LiquibaseUtils.isNotNullColumn(entity, attribute)));
        }
        column.setCertainDataType(false);
        EntityAttribute entityAttribute = idAttribute = entity == null ? null : entity.getIdAttributeOrNull();
        if (idAttribute != null) {
            boolean isPrimaryKeyColumn;
            Datatype idEntity = idAttribute.getType();
            if (idEntity instanceof Entity) {
                List columnNames = entity.getColumnNames(database.getProject(), idAttribute);
                isPrimaryKeyColumn = ContainerUtil.exists((Iterable)columnNames, s -> StringUtil.equalsIgnoreCase((CharSequence)columnName, (CharSequence)s));
            } else {
                String idAttrColumnName = idAttribute.getColumn(entity);
                isPrimaryKeyColumn = DbIdentifierHelper.compareIdentifier((String)idAttrColumnName, (String)columnName);
            }
            if (isPrimaryKeyColumn) {
                EntityAttribute.GeneratedStrategy generatedStrategy;
                if (!(idEntity instanceof Entity) && (EntityDesignHelper.getInheritanceType((Entity)entity) != Entity.InheritanceType.JOINED || EntityDesignHelper.getPersistentParent((Entity)entity) == null) && (generatedStrategy = idAttribute.getGeneratedStrategy()) == EntityAttribute.GeneratedStrategy.IDENTITY && idEntity instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)idEntity).isSupportAutoIncrement() && database.supportsAutoIncrement()) {
                    Column.AutoIncrementInformation autoIncrementInformation = new Column.AutoIncrementInformation();
                    column.setAutoIncrementInformation(autoIncrementInformation);
                }
                column.setNullable(Boolean.valueOf(false));
            }
        }
    }

    private static boolean isNotNullColumn(@Nullable Entity entity, EntityAttribute attribute) {
        AttributeOverride attributeOverride;
        if (entity != null && (attributeOverride = entity.getAttributeOverrideEx(attribute.getName())) != null) {
            return Boolean.FALSE.equals(attributeOverride.isNullable());
        }
        if (attribute instanceof CachedEntityAttributeModel || attribute instanceof AuditEntityAttribute) {
            return attribute.isMandatory();
        }
        return attribute.isNotNullColumn(entity != null && entity.isEmbeddable());
    }

    @NotNull
    private static DataTypeInfo toLiquibaseDataType(LiquibaseGenerator liquibaseGenerator, @Nullable Entity entity, EntityAttribute attribute, LiquibaseGenerationContext generationContext) {
        JavaType javaType = liquibaseGenerator.getJavaType(entity, attribute);
        generationContext.registerType(javaType);
        DataType dataType = new DataType(javaType.getId());
        return new DataTypeInfo(dataType, javaType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "databases";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "snapshot";
                break;
            }
        }
        objectArray[1] = "liquibase/ext/intellij/LiquibaseUtils";
        objectArray[2] = "getIntellijDatabase";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DataTypeInfo {
        private final DataType dataType;
        private final JavaType javaType;

        public DataTypeInfo(DataType dataType, JavaType javaType) {
            this.dataType = dataType;
            this.javaType = javaType;
        }
    }
}

