/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import com.intellij.openapi.util.text.StringUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Sequence;

public class UnexpectedSequenceChangeGenerator
extends liquibase.diff.output.changelog.core.UnexpectedSequenceChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Sequence.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        if (unexpectedObject instanceof Sequence && referenceDatabase instanceof IntellijDatabase) {
            String seqName = unexpectedObject.getName();
            if (StringUtil.equalsIgnoreCase((CharSequence)seqName, (CharSequence)"hibernate_sequence") || StringUtil.equalsIgnoreCase((CharSequence)seqName, (CharSequence)"seq_gen")) {
                return new Change[0];
            }
            if (unexpectedObject.getAttribute("owned", String.class) != null) {
                return new Change[0];
            }
        }
        return super.fixUnexpected(unexpectedObject, control, referenceDatabase, comparisonDatabase, chain);
    }
}

