/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff.comparator;

import com.intellij.liquibase.common.JavaType;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseGenerationContextRegistry;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.core.ColumnComparator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import one.util.streamex.StreamEx;

public class HColumnComparator
extends ColumnComparator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Column.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database) + 5;
        }
        return -1;
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("generationContext");
        exclude.add("fillValue");
        ObjectDifferences differences = super.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, chain, exclude);
        Optional maybeGenerationContext = StreamEx.of((Object[])new DatabaseObject[]{databaseObject1, databaseObject2}).map(column -> (UUID)column.getAttribute("generationContext", UUID.class)).nonNull().map(LiquibaseGenerationContextRegistry.getInstance()::get).findFirst();
        if (maybeGenerationContext.isEmpty()) {
            return differences;
        }
        LiquibaseGenerationContext generationContext = (LiquibaseGenerationContext)maybeGenerationContext.get();
        differences.removeDifference("type");
        differences.compare("type", databaseObject1, databaseObject2, (referenceValue, compareToValue) -> {
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            if (!(referenceValue instanceof DataType) || !(compareToValue instanceof DataType)) {
                return false;
            }
            JavaType type = generationContext.getType(((DataType)referenceValue).getTypeName());
            return !type.isTypeChanged((DataType)compareToValue, generationContext);
        });
        return differences;
    }
}

