/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.core.model.dbtype.MysqlType;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.GenericGenerator;
import com.intellij.jpa.jpb.model.model.SequenceGenerator;
import com.intellij.jpa.jpb.model.service.JpabReferenceManager;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.LiquibaseModelObjectFactory;
import com.intellij.liquibase.common.StubLiquibaseModelObjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequenceSnapshotGenerator
extends IntellijSnapshotGenerator {
    public static final String HIBERNATE_SEQUENCE_NAME = "hibernate_sequence";
    public static final String HIBERNATE_SEQUENCE_DEFAULT_SUFFIX = "_seq";
    public static final String HIBERNATE_SEQUENCE_NAMING_STRATEGY_PROPERTY = "spring.jpa.properties.hibernate.id.db_structure_naming_strategy";
    public static final String ECLIPSE_SEQUENCE_NAME = "seq_gen";

    public SequenceSnapshotGenerator() {
        super(Sequence.class, new Class[]{Schema.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Sequence.class)) {
            return;
        }
        if (!(foundObject instanceof Schema)) {
            return;
        }
        Schema schema = (Schema)foundObject;
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        new SequenceGeneratorFactory(database, schema).compute(database.getProject(), database.getEntitiesToProcess(schema), !(database.getDbType() instanceof MysqlType)).forEach(arg_0 -> ((Schema)schema).addDatabaseObject(arg_0));
    }

    public static class SequenceGeneratorFactory {
        private final LiquibaseModelObjectFactory dbObjectFactory;
        private Schema schema;
        private final Collection<Sequence> result = new ArrayList<Sequence>();

        public SequenceGeneratorFactory() {
            this.dbObjectFactory = StubLiquibaseModelObjectFactory.INSTANCE;
        }

        public SequenceGeneratorFactory(IntellijDatabase database, Schema schema) {
            this.dbObjectFactory = database.getDbObjectFactory();
            this.schema = schema;
        }

        public Collection<Sequence> compute(Project project, List<Entity> entityList, Boolean dbCheckCondition) {
            HashSet<String> processedSequenceNames = new HashSet<String>();
            for (Entity entity : entityList) {
                EntityAttribute idAttribute;
                SequenceGenerator entitySequenceGenerator = entity.getSequenceGenerator();
                if (!entity.isPersistentEntity() || !SequenceGeneratorFactory.attributeTypeIsNumber(idAttribute = entity.getIdAttributeOrNull(), entity)) continue;
                String attrSequenceGeneratorName = null;
                if (idAttribute instanceof EntityAttributePsi) {
                    attrSequenceGeneratorName = EntityUtil.getSequenceGeneratorName((PsiMember)((EntityAttributePsi)idAttribute).getMember());
                }
                if (!SequenceGeneratorFactory.isSequenceGenerator(idAttribute, entitySequenceGenerator, attrSequenceGeneratorName, project, dbCheckCondition)) continue;
                boolean isSuitableGenerator = JpabReferenceManager.getInstance((Project)project).isSuitableGenerator(entity);
                SequenceGenerator targetSequenceGenerator = entitySequenceGenerator != null && StringUtil.isEmpty((String)attrSequenceGeneratorName) && isSuitableGenerator ? entitySequenceGenerator : Optional.ofNullable(idAttribute.getGeneratorName()).map(it -> EntityUtil.getEntityWithGenerator((Project)project, (String)it)).map(EntityPsi::getSequenceGenerator).orElseGet(() -> SequenceGeneratorFactory.createAttrSeqGen(idAttribute, entity, project));
                String sequenceName = targetSequenceGenerator.getSequenceName();
                if (StringUtil.isEmpty((String)sequenceName)) {
                    sequenceName = targetSequenceGenerator.getName();
                }
                Schema entitySchema = null;
                if (this.schema == null && StringUtil.isNotEmpty((String)entity.getSchema())) {
                    String entityCatalog = entity.getCatalog();
                    Catalog catalog = StringUtil.isNotEmpty((String)entityCatalog) ? new Catalog(entityCatalog) : new Catalog();
                    entitySchema = new Schema(catalog, entity.getSchema());
                }
                if (!processedSequenceNames.add(sequenceName)) continue;
                Sequence sequence = this.createSequence(project, sequenceName, targetSequenceGenerator.getInitialValue(), targetSequenceGenerator.getAllocationSize(), targetSequenceGenerator.isSystemIdx(), entitySchema);
                this.result.add(sequence);
            }
            return this.result;
        }

        private static boolean attributeTypeIsNumber(EntityAttribute attribute, Entity entity) {
            Datatype datatype;
            if (attribute == null || !((datatype = attribute.getType()) instanceof Datatypes.BasicDatatype)) {
                return false;
            }
            Datatypes.BasicDatatype attributeType = (Datatypes.BasicDatatype)datatype;
            if (attributeType.isNumber()) {
                return true;
            }
            if (!attributeType.isKnownType() && attribute instanceof EntityAttributePsi && ((EntityAttributePsi)attribute).isValid()) {
                PsiClass entityPsiClass;
                PsiMember attrMember = ((EntityAttributePsi)attribute).getMember();
                PsiClass psiClass = entityPsiClass = entity instanceof EntityPsi ? ((EntityPsi)entity).getPsiClass() : null;
                if (entityPsiClass == null) {
                    return false;
                }
                Datatype resolvedGenericAttrType = AttributeUtil.getResolvedGenericAttrType((PsiClass)entityPsiClass, (PsiMember)attrMember);
                return resolvedGenericAttrType instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)resolvedGenericAttrType).isNumber();
            }
            return false;
        }

        @NotNull
        private static SequenceGenerator createAttrSeqGen(EntityAttribute idAttribute, Entity entity, Project project) {
            Object sequenceName = null;
            String generatorName = idAttribute.getGeneratorName();
            boolean isSystemIdx = false;
            if (StringUtil.isNotEmpty((String)generatorName) && StringUtil.isEmpty((String)(sequenceName = idAttribute.getSequenceOrTableGeneratorName()))) {
                sequenceName = generatorName;
                if (idAttribute.getGeneratedStrategy() == EntityAttribute.GeneratedStrategy.AUTO) {
                    isSystemIdx = true;
                }
            }
            if (StringUtil.isEmpty(sequenceName)) {
                sequenceName = EntityUtil.isSequencePerEntityStrategy((Project)project) ? PhysicalNamingStrategy.getInstance((Project)project).toTableName(entity.getTable()) + SequenceSnapshotGenerator.HIBERNATE_SEQUENCE_DEFAULT_SUFFIX : (JpaUtils.isHibernateProject((Project)project) ? SequenceSnapshotGenerator.HIBERNATE_SEQUENCE_NAME : SequenceSnapshotGenerator.ECLIPSE_SEQUENCE_NAME);
                isSystemIdx = true;
            }
            SequenceGenerator targetSequenceGenerator = new SequenceGenerator(StringUtil.notNullize((String)generatorName), (String)sequenceName, idAttribute.getInitialValue(), idAttribute.getAllocationSize());
            targetSequenceGenerator.setSystemIdx(isSystemIdx);
            SequenceGenerator sequenceGenerator = targetSequenceGenerator;
            if (sequenceGenerator == null) {
                SequenceGeneratorFactory.$$$reportNull$$$0(0);
            }
            return sequenceGenerator;
        }

        private static boolean isSequenceGenerator(@NotNull EntityAttribute idAttribute, @Nullable SequenceGenerator entitySequenceGenerator, @Nullable String attrSequenceGeneratorName, Project project, Boolean dbCheckCondition) {
            String sequenceGeneratorName;
            EntityAttributePsi entityAttributePsi;
            String generationStrategy;
            EntityAttribute.GeneratedStrategy generatedStrategy;
            if (idAttribute == null) {
                SequenceGeneratorFactory.$$$reportNull$$$0(1);
            }
            if ((generatedStrategy = idAttribute.getGeneratedStrategy()) == EntityAttribute.GeneratedStrategy.SEQUENCE) {
                return true;
            }
            String generatorName = idAttribute.getGeneratorName();
            if (StringUtil.isEmpty((String)generatorName)) {
                return generatedStrategy == EntityAttribute.GeneratedStrategy.AUTO && JpaUtils.isHibernateProject((Project)project) && dbCheckCondition != false;
            }
            if (generatedStrategy == EntityAttribute.GeneratedStrategy.AUTO && idAttribute instanceof EntityAttributePsi && (generationStrategy = (String)Optional.ofNullable(EntityUtil.getGenericGenerator((PsiModifierListOwner)(entityAttributePsi = (EntityAttributePsi)idAttribute).getMember())).or(() -> Optional.ofNullable(entityAttributePsi.getEntity().getGenericGenerator())).filter(generator -> generatorName.equals(generator.getName())).map(GenericGenerator::getStrategy).orElse(null)) != null && !EntityAttribute.GENERIC_GENERATOR_SEQUENCE_STRATEGIES.contains(generationStrategy)) {
                return false;
            }
            String string = sequenceGeneratorName = entitySequenceGenerator == null ? null : entitySequenceGenerator.getName();
            if (StringUtil.isNotEmpty((String)attrSequenceGeneratorName)) {
                sequenceGeneratorName = attrSequenceGeneratorName;
            } else if (sequenceGeneratorName == null && generatedStrategy == EntityAttribute.GeneratedStrategy.AUTO) {
                return true;
            }
            return StringUtil.equals((CharSequence)sequenceGeneratorName, (CharSequence)generatorName);
        }

        private Sequence createSequence(Project project, String sequenceName, int initialValue, int incrementBy, boolean isSystemIdx, Schema entitySchema) {
            Sequence sequence = this.dbObjectFactory.createSequence(sequenceName);
            sequence.setSchema(this.schema != null ? this.schema : entitySchema);
            if (isSystemIdx) {
                sequence.setStartValue(BigInteger.valueOf(1L));
                sequence.setIncrementBy(BigInteger.valueOf(EntityUtil.getHibernateDefaultIncrementSize((Project)project)));
            } else {
                sequence.setStartValue(BigInteger.valueOf(initialValue));
                sequence.setIncrementBy(BigInteger.valueOf(incrementBy));
            }
            return sequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "liquibase/ext/intellij/snapshot/SequenceSnapshotGenerator$SequenceGeneratorFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAttrSeqGen";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "liquibase/ext/intellij/snapshot/SequenceSnapshotGenerator$SequenceGeneratorFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSequenceGenerator";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

