/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.ide.TypePresentationService;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringPresentationProvider
extends PresentationProvider {
    public String getName(Object o) {
        if (o instanceof CommonSpringBean) {
            return SpringPresentationProvider.getSpringBeanName((CommonSpringBean)o);
        }
        if (o instanceof SpringBeanPointer) {
            return SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)o);
        }
        if (o instanceof SpringImport) {
            return ((SpringImport)o).getResource().getStringValue();
        }
        return null;
    }

    @Nullable
    public Icon getIcon(Object o) {
        return SpringPresentationProvider.getSpringIcon(o);
    }

    @NotNull
    @NlsSafe
    public static String getSpringBeanName(SpringBeanPointer<?> springBeanPointer) {
        String pointerName = springBeanPointer.getName();
        return pointerName != null ? pointerName : SpringPresentationProvider.getSpringBeanName(springBeanPointer.getSpringBean());
    }

    @NotNull
    @Nls
    @NlsSafe
    public static String getSpringBeanName(CommonSpringBean springBean) {
        String name;
        PsiElement target;
        PsiType beanClass;
        if (!springBean.isValid()) {
            String string = SpringApiBundle.message("spring.bean.invalid", new Object[0]);
            if (string == null) {
                SpringPresentationProvider.$$$reportNull$$$0(0);
            }
            return string;
        }
        String beanName = springBean.getBeanName();
        if (beanName != null) {
            String string = beanName;
            if (string == null) {
                SpringPresentationProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (springBean instanceof SpringBean && (beanClass = springBean.getBeanType()) != null) {
            String string = beanClass.getPresentableText();
            if (string == null) {
                SpringPresentationProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        String typeName = TypePresentationService.getService().getTypeName((Object)springBean);
        if (typeName != null) {
            String string = typeName;
            if (string == null) {
                SpringPresentationProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        PsiElement identifyingPsiElement = springBean.getIdentifyingPsiElement();
        if (identifyingPsiElement instanceof PomTargetPsiElement && (target = identifyingPsiElement.getNavigationElement()) instanceof XmlTag && !StringUtil.isEmptyOrSpaces((String)(name = ((XmlTag)target).getName()))) {
            String string = "<" + name + " ... />";
            if (string == null) {
                SpringPresentationProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = SpringApiBundle.message("spring.bean.with.unknown.name", new Object[0]);
        if (string == null) {
            SpringPresentationProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String getSpringBeanLocation(SpringBeanPointer<?> springBeanPointer) {
        Object commonSpringBean;
        if (springBeanPointer instanceof JamSpringBeanPointer && (commonSpringBean = springBeanPointer.getSpringBean()) instanceof SpringImplicitBeanMarker) {
            return ((SpringImplicitBeanMarker)commonSpringBean).getProviderName();
        }
        return springBeanPointer.getContainingFile().getName();
    }

    @Nullable
    public static Icon getSpringIcon(@Nullable Object o) {
        SpringBean springBean;
        if (o instanceof SpringBeanPointer) {
            o = ((SpringBeanPointer)o).getSpringBean();
        } else if (o instanceof SpringBeanPsiTarget) {
            o = ((SpringBeanPsiTarget)o).getSpringBean();
        }
        if (!(o instanceof CommonSpringBean)) {
            return null;
        }
        if (o instanceof Iconable) {
            return ((Iconable)o).getIcon(0);
        }
        if (o instanceof SpringBean && (springBean = (SpringBean)o).isValid()) {
            if (springBean.isAbstract()) {
                return SpringApiIcons.AbstractBean;
            }
            GenericAttributeValue scope = springBean.getScope();
            if (DomUtil.hasXml((DomElement)scope) && Objects.equals(scope.getStringValue(), SpringBeanScope.PROTOTYPE_SCOPE.getValue())) {
                return SpringApiIcons.PrototypeBean;
            }
        }
        return SpringApiIcons.SpringBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/SpringPresentationProvider", "getSpringBeanName"));
    }
}

