/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.code;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.index.SpringBeanIndexType;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomManager;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final List<String> WRITE_ANNOTATIONS = List.of("org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Required", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Value", "org.springframework.jmx.export.annotation.ManagedOperation", "org.springframework.jmx.export.annotation.ManagedAttribute", "org.springframework.scheduling.annotation.Scheduled", "org.springframework.scheduling.annotation.Schedules", "org.springframework.test.context.transaction.BeforeTransaction", "org.springframework.test.context.transaction.AfterTransaction");
    private static final List<String> ENTRY_POINTS = List.of("org.springframework.context.annotation.Bean", "org.springframework.jmx.export.annotation.ManagedOperation", "org.springframework.jmx.export.annotation.ManagedAttribute", "org.springframework.scheduling.annotation.Scheduled", "org.springframework.scheduling.annotation.Schedules", "org.springframework.context.event.EventListener", "javax.annotation.PostConstruct", "jakarta.annotation.PostConstruct", "javax.annotation.PreDestroy", "jakarta.annotation.PreDestroy");
    private static final List<String> META_ENTRY_POINTS = List.of("org.springframework.context.event.EventListener");
    private static final List<String> NON_SPRING_WRITE_ANNOTATIONS = List.of("javax.inject.Inject", "jakarta.inject.Inject", "javax.annotation.Resource", "jakarta.annotation.Resource");
    private static final List<String> READ_ANNOTATIONS = List.of("org.springframework.beans.factory.annotation.Value");
    private static final List<String> REGULAR_COMPONENT_ANNOTATIONS = List.of("org.springframework.stereotype.Service", "org.springframework.stereotype.Component");
    private static final List<String> WRITE_META_ANNOTATIONS = List.of("org.springframework.scheduling.annotation.Scheduled", "org.springframework.beans.factory.annotation.Autowired", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Value");

    SpringImplicitUsageProvider() {
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return SpringImplicitUsageProvider.hasWriteAnnotation(element) || SpringImplicitUsageProvider.isBeanSetterOrLifeCycleMethod(element) || SpringImplicitUsageProvider.isBeanClassOrConstructor(element) || SpringImplicitUsageProvider.isDynamicPropertySource(element) || SpringImplicitUsageProvider.isJsonComponentClass(element);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return element instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)element), READ_ANNOTATIONS, (int)0);
    }

    private static boolean isMetaAnnotated(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiClass) {
            return false;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)element, WRITE_META_ANNOTATIONS);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        return SpringImplicitUsageProvider.hasWriteAnnotation(element) || SpringImplicitUsageProvider.isBeanSetterOrLifeCycleMethod(element) || element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), NON_SPRING_WRITE_ANNOTATIONS, (int)0);
    }

    private static boolean hasWriteAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
        if (element instanceof PsiParameter || element instanceof PsiLocalVariable) {
            return false;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null || modifierList.getAnnotations().length == 0) {
            return false;
        }
        if (SpringCommonUtils.isSpringConfigured(element.getProject())) {
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, WRITE_ANNOTATIONS, (int)0) || SpringImplicitUsageProvider.isMetaAnnotated(modifierListOwner);
        }
        return false;
    }

    private static boolean isBeanSetterOrLifeCycleMethod(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (SpringImplicitUsageProvider.isEntryPoint(psiMethod)) {
                return true;
            }
            int parametersCount = psiMethod.getParameterList().getParametersCount();
            if (parametersCount > 1) {
                return false;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            PsiIdentifier identifier = psiMethod.getNameIdentifier();
            if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass) && identifier != null && !SpringCommonUtils.isStereotypeComponentOrMeta(psiClass)) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                if (module == null) {
                    return false;
                }
                return PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod) && SpringImplicitUsageProvider.hasBeanClassInSpringXmlIndex(psiClass);
            }
        }
        return false;
    }

    private static boolean hasBeanClassInSpringXmlIndex(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(6);
        }
        return (Boolean)CachedValuesManager.getManager((Project)aClass.getProject()).getCachedValue((UserDataHolder)aClass, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (module == null) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            }
            CommonProcessors.FindFirstProcessor findFirst = new CommonProcessors.FindFirstProcessor();
            FileBasedIndex.getInstance().getFilesWithKey(SpringXmlBeansIndex.NAME, Set.of(Pair.create((Object)((Object)SpringBeanIndexType.BEAN_CLASS), (Object)aClass.getQualifiedName())), (Processor)findFirst, module.getModuleWithDependenciesScope());
            return CachedValueProvider.Result.create((Object)findFirst.isFound(), (Object[])new Object[]{DomManager.getDomManager((Project)aClass.getProject()), aClass});
        });
    }

    private static boolean isBeanClassOrConstructor(PsiElement element) {
        if (element instanceof PsiClass) {
            return SpringImplicitUsageProvider.isMappedBeanClass((PsiClass)element, false);
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            return SpringImplicitUsageProvider.isMappedBeanClass(((PsiMethod)element).getContainingClass(), true);
        }
        return false;
    }

    private static boolean isMappedBeanClass(@Nullable PsiClass element, boolean forMembers) {
        if (element == null) {
            return false;
        }
        if (element.isInterface()) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)element, REGULAR_COMPONENT_ANNOTATIONS, (int)0)) {
            if (SpringImplicitUsageProvider.hasSuperClasses(element) || ContainerUtil.exists((Object[])element.getMethods(), SpringImplicitUsageProvider::isEntryPoint)) {
                return true;
            }
            if (!forMembers) {
                return false;
            }
        }
        return SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(element) && SpringCommonUtils.isStereotypeComponentOrMeta(element);
    }

    private static boolean isEntryPoint(@NotNull PsiMethod method) {
        if (method == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(7);
        }
        return !method.hasModifier(JvmModifier.ABSTRACT) && (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, ENTRY_POINTS, (int)0) || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)method, META_ENTRY_POINTS));
    }

    private static boolean hasSuperClasses(@NotNull PsiClass element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(8);
        }
        for (PsiClass superClass : element.getSupers()) {
            if (superClass == null || "java.lang.Record".equals(superClass.getQualifiedName()) || "java.lang.Object".equals(superClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDynamicPropertySource(@NotNull PsiElement element) {
        PsiMethod psiMethod;
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(9);
        }
        return element instanceof PsiMethod && (psiMethod = (PsiMethod)element).hasModifier(JvmModifier.STATIC) && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"org.springframework.test.context.DynamicPropertySource", (int)0);
    }

    private static boolean isJsonComponentClass(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(10);
        }
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)element;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            return false;
        }
        PsiClass targetClass = psiClass.getContainingClass();
        if (targetClass == null) {
            targetClass = psiClass;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)targetClass, (String)"org.springframework.boot.jackson.JsonComponent", (int)0)) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.fasterxml.jackson.databind.JsonDeserializer") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.fasterxml.jackson.databind.JsonSerializer");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/code/SpringImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMetaAnnotated";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWriteAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isBeanSetterOrLifeCycleMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasBeanClassInSpringXmlIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isEntryPoint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isDynamicPropertySource";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isJsonComponentClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

