/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.completion;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.ModelTraverse;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.actions.generate.autowire.AutowireBeanUtilsKt;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u001c\u0010\u0006\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u0012\u0004\u0012\u00020\u00010\u0007\u001a=\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\r\u001a\u00020\u00032\u0017\u0010\u000e\u001a\u0013\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u0011\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a6\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00102\u0010\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u000fH\u0002\u00a8\u0006\u0018"}, d2={"traverseAutowiringCandidates", "", "injectionTargetClass", "Lcom/intellij/psi/PsiClass;", "batchSize", "", "processor", "Lkotlin/Function1;", "", "Lcom/intellij/spring/model/SpringBeanPointer;", "filterBean", "", "beanPointer", "targetClass", "alreadyAutowiredBeans", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/psi/PsiType;", "resolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "alreadyAutowired", "beanName", "beanTypes", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeanInjectionCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanInjectionCompletionContributor.kt\ncom/intellij/spring/completion/SpringBeanInjectionCompletionContributorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n8506#2,2:167\n9188#2,4:169\n1755#3,3:173\n1863#3,2:176\n*S KotlinDebug\n*F\n+ 1 SpringBeanInjectionCompletionContributor.kt\ncom/intellij/spring/completion/SpringBeanInjectionCompletionContributorKt\n*L\n112#1:167,2\n112#1:169,4\n164#1:173,3\n137#1:176,2\n*E\n"})
public final class SpringBeanInjectionCompletionContributorKt {
    /*
     * WARNING - void declaration
     */
    public static final void traverseAutowiringCandidates(@NotNull PsiClass injectionTargetClass, int batchSize, @NotNull Function1<? super Collection<? extends SpringBeanPointer<?>>, Unit> processor2) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)injectionTargetClass, (String)"injectionTargetClass");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        GlobalSearchScope globalSearchScope = injectionTargetClass.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
        GlobalSearchScope resolveScope = globalSearchScope;
        PsiClass targetClass = injectionTargetClass;
        PsiField[] psiFieldArray = injectionTargetClass.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
        Object[] $this$associate$iv = psiFieldArray;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        Object[] objectArray = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            PsiField it = (PsiField)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getType());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map alreadyAutowiredBeans = destination$iv$iv;
        ArrayList candidates = new ArrayList(batchSize);
        Ref.IntRef itemsCount = new Ref.IntRef();
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getPsiClassSpringModel(injectionTargetClass);
        Intrinsics.checkNotNullExpressionValue((Object)commonSpringModel, (String)"getPsiClassSpringModel(...)");
        CommonSpringModel model = commonSpringModel;
        Processor candidateProcessor = arg_0 -> SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$lambda$1(targetClass, alreadyAutowiredBeans, resolveScope, candidates, itemsCount, batchSize, processor2, arg_0);
        ModelTraverse.traverseModelBreadthFirst(model, arg_0 -> SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$lambda$4(candidateProcessor, arg_0));
        processor2.invoke(candidates);
    }

    public static /* synthetic */ void traverseAutowiringCandidates$default(PsiClass psiClass, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates(psiClass, n, function1);
    }

    private static final boolean filterBean(SpringBeanPointer<?> beanPointer, PsiClass targetClass, Map<String, ? extends PsiType> alreadyAutowiredBeans, GlobalSearchScope resolveScope) {
        String string = beanPointer.getName();
        if (string == null) {
            return false;
        }
        String beanName = string;
        return beanPointer.getBeanClass() != null && !SpringBeanInjectionCompletionContributorKt.alreadyAutowired(beanName, beanPointer.getEffectiveBeanTypes(), alreadyAutowiredBeans) && !Intrinsics.areEqual((Object)beanPointer.getBeanClass(), (Object)targetClass) && resolveScope.contains(beanPointer.getContainingFile().getVirtualFile());
    }

    private static final boolean alreadyAutowired(String beanName, Collection<? extends PsiType> beanTypes, Map<String, ? extends PsiType> alreadyAutowiredBeans) {
        boolean bl;
        block5: {
            PsiType psiType = alreadyAutowiredBeans.get(beanName);
            if (psiType == null) {
                return false;
            }
            PsiType autowiredPsiType = psiType;
            if (beanTypes == null) {
                return false;
            }
            Iterable $this$any$iv = CollectionsKt.filterNotNull((Iterable)beanTypes);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiType p0 = (PsiType)element$iv;
                    boolean $i$f$alreadyAutowired$stub_for_inlining = false;
                    boolean bl2 = false;
                    if (!autowiredPsiType.isConvertibleFrom(p0)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean traverseAutowiringCandidates$lambda$1(PsiClass $targetClass, Map $alreadyAutowiredBeans, GlobalSearchScope $resolveScope, ArrayList $candidates, Ref.IntRef $itemsCount, int $batchSize, Function1 $processor, SpringBeanPointer t) {
        if (t.getName() == null) {
            return true;
        }
        Intrinsics.checkNotNull((Object)t);
        if (SpringBeanInjectionCompletionContributorKt.filterBean(t, $targetClass, $alreadyAutowiredBeans, $resolveScope)) {
            $candidates.add(t);
        }
        int n = $itemsCount.element;
        $itemsCount.element = n + 1;
        if ($itemsCount.element > $batchSize) {
            $processor.invoke((Object)$candidates);
            $candidates.clear();
            $itemsCount.element = 0;
        }
        return true;
    }

    private static final boolean traverseAutowiringCandidates$lambda$4$lambda$2(Processor $candidateProcessor, SpringBeanPointer it) {
        if ($candidateProcessor.process((Object)it)) {
            Intrinsics.checkNotNull((Object)it);
            Iterable $this$forEach$iv = AutowireBeanUtilsKt.getBaseClassesAndInterfaces(it);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SpringBeanPointer p0 = (SpringBeanPointer)element$iv;
                boolean bl = false;
                $candidateProcessor.process((Object)p0);
            }
        }
        return true;
    }

    private static final boolean traverseAutowiringCandidates$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Direction traverseAutowiringCandidates$lambda$4(Processor $candidateProcessor, CommonSpringModel relatedModel) {
        Intrinsics.checkNotNullParameter((Object)relatedModel, (String)"relatedModel");
        relatedModel.processLocalBeans(arg_0 -> SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$lambda$4$lambda$3(arg_0 -> SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$lambda$4$lambda$2($candidateProcessor, arg_0), arg_0));
        return Direction.TRAVERSE;
    }
}

