/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.microservices.jvm.completion.beans.BeanInjectionCompletionProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.completion.SpringBeanInjectionCompletionContributorKt;
import com.intellij.spring.completion.SpringBeanInjectionInsertHandler;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.actions.generate.GenerateAutowiredDependenciesUtil;
import com.intellij.spring.model.actions.generate.autowire.AutowireBeanUtilsKt;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0014J\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001c\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J8\u0010\u001a\u001a\u00020\u00122\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/spring/completion/SpringBeanInjectionCompletionProvider;", "Lcom/intellij/microservices/jvm/completion/beans/BeanInjectionCompletionProvider;", "Lcom/intellij/spring/model/SpringBeanPointer;", "<init>", "()V", "isAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "getBeanTypeName", "", "beanToInject", "getLookupElementIcon", "Ljavax/swing/Icon;", "canInjectIntoClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "addCompletionsForBeans", "", "injectionTargetClass", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "isBeanNameMatches", "matcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "beanPointer", "createLookupItems", "candidates", "", "injectionTargetClassPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "createLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "beanName", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeanInjectionCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanInjectionCompletionContributor.kt\ncom/intellij/spring/completion/SpringBeanInjectionCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1611#2,9:167\n1863#2:176\n1864#2:178\n1620#2:179\n1755#2,3:180\n1863#2,2:183\n774#2:185\n865#2,2:186\n1#3:177\n*S KotlinDebug\n*F\n+ 1 SpringBeanInjectionCompletionContributor.kt\ncom/intellij/spring/completion/SpringBeanInjectionCompletionProvider\n*L\n62#1:167,9\n62#1:176\n62#1:178\n62#1:179\n62#1:180,3\n73#1:183,2\n57#1:185\n57#1:186,2\n62#1:177\n*E\n"})
final class SpringBeanInjectionCompletionProvider
extends BeanInjectionCompletionProvider<SpringBeanPointer<?>> {
    protected boolean isAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SpringGeneralSettings.getInstance(module.getProject()).isSmartCompletionAvailability() && SpringCommonUtils.isSpringConfigured(module);
    }

    @NotNull
    protected String getBeanTypeName(@NotNull SpringBeanPointer<?> beanToInject) {
        Intrinsics.checkNotNullParameter(beanToInject, (String)"beanToInject");
        Object object = beanToInject.getBeanClass();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        return " " + (String)object;
    }

    @Nullable
    protected Icon getLookupElementIcon(@NotNull SpringBeanPointer<?> beanToInject) {
        Intrinsics.checkNotNullParameter(beanToInject, (String)"beanToInject");
        return SpringPresentationProvider.getSpringIcon(beanToInject);
    }

    protected boolean canInjectIntoClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return GenerateAutowiredDependenciesUtil.isAnnotatedComponent(psiClass);
    }

    protected void addCompletionsForBeans(@NotNull PsiClass injectionTargetClass, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)injectionTargetClass, (String)"injectionTargetClass");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        SmartPsiElementPointer injectionTargetClassPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)injectionTargetClass));
        SpringBeanInjectionCompletionContributorKt.traverseAutowiringCandidates$default(injectionTargetClass, 0, arg_0 -> SpringBeanInjectionCompletionProvider.addCompletionsForBeans$lambda$1(this, injectionTargetClass, injectionTargetClassPointer, result, arg_0), 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBeanNameMatches(PrefixMatcher matcher, SpringBeanPointer<?> beanPointer) {
        String p0;
        void $this$any$iv;
        void $this$mapNotNullTo$iv$iv;
        String string = beanPointer.getName();
        if (string == null) {
            return false;
        }
        String beanName = string;
        if (matcher.prefixMatches(beanName)) return true;
        Collection<SpringQualifier> collection = beanPointer.getSpringBean().getSpringQualifiers();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSpringQualifiers(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpringQualifier it = (SpringQualifier)element$iv$iv;
            boolean bl2 = false;
            if (it.getQualifierValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        object = $this$any$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            p0 = (String)element$iv;
            boolean $i$f$isBeanNameMatches$stub_for_inlining = false;
            boolean bl = false;
        } while (!matcher.prefixMatches(p0));
        return true;
    }

    private final void createLookupItems(Collection<? extends SpringBeanPointer<?>> candidates, PsiClass injectionTargetClass, SmartPsiElementPointer<PsiElement> injectionTargetClassPointer, CompletionResultSet result) {
        ProgressManager.checkCanceled();
        List lookupElements = new ArrayList();
        Iterable $this$forEach$iv = candidates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpringBeanPointer springBeanPointer = (SpringBeanPointer)element$iv;
            boolean bl = false;
            if (!AutowireBeanUtilsKt.checkAutowireCandidate(injectionTargetClass, springBeanPointer)) continue;
            if (SpringBeanInjectionCompletionProvider.createLookupElement$default(this, injectionTargetClassPointer, springBeanPointer, null, 4, null) != null) {
                LookupElement it;
                boolean bl2 = false;
                lookupElements.add(it);
            }
            for (SpringQualifier qualifier : springBeanPointer.getSpringBean().getSpringQualifiers()) {
                LookupElement it;
                if (this.createLookupElement(injectionTargetClassPointer, springBeanPointer, qualifier.getQualifierValue()) == null) continue;
                boolean bl3 = false;
                lookupElements.add(it);
            }
        }
        result.addAllElements((Iterable)lookupElements);
    }

    private final LookupElement createLookupElement(SmartPsiElementPointer<PsiElement> injectionTargetClassPointer, SpringBeanPointer<?> beanToInject, String beanName) {
        if (beanName == null) {
            return null;
        }
        PsiClass psiClass = beanToInject.getBeanClass();
        if (psiClass == null) {
            return null;
        }
        PsiClass beanClass = psiClass;
        SmartPsiElementPointer beanClassPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)beanClass));
        String injectedName = this.getInjectedName(beanName, beanClassPointer);
        SpringBeanInjectionInsertHandler insertHandler = new SpringBeanInjectionInsertHandler(injectionTargetClassPointer, beanToInject, (Function0<String>)((Function0)() -> SpringBeanInjectionCompletionProvider.createLookupElement$lambda$6(injectedName)));
        return this.createLookupElement(injectedName, beanClass, beanToInject, (InsertHandler)insertHandler);
    }

    static /* synthetic */ LookupElement createLookupElement$default(SpringBeanInjectionCompletionProvider springBeanInjectionCompletionProvider, SmartPsiElementPointer smartPsiElementPointer, SpringBeanPointer springBeanPointer, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = springBeanPointer.getName();
        }
        return springBeanInjectionCompletionProvider.createLookupElement((SmartPsiElementPointer<PsiElement>)smartPsiElementPointer, springBeanPointer, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addCompletionsForBeans$lambda$1(SpringBeanInjectionCompletionProvider this$0, PsiClass $injectionTargetClass, SmartPsiElementPointer $injectionTargetClassPointer, CompletionResultSet $result, Collection it) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = it;
        SpringBeanInjectionCompletionProvider springBeanInjectionCompletionProvider = this$0;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpringBeanPointer it2 = (SpringBeanPointer)element$iv$iv;
            boolean bl = false;
            PrefixMatcher prefixMatcher = $result.getPrefixMatcher();
            Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"getPrefixMatcher(...)");
            if (!this$0.isBeanNameMatches(prefixMatcher, it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        springBeanInjectionCompletionProvider.createLookupItems((List)destination$iv$iv, $injectionTargetClass, (SmartPsiElementPointer<PsiElement>)$injectionTargetClassPointer, $result);
        return Unit.INSTANCE;
    }

    private static final String createLookupElement$lambda$6(String $injectedName) {
        return $injectedName;
    }
}

