/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.microservices.jvm.completion.beans.BeanInjectionInsertHandler;
import com.intellij.microservices.jvm.inject.InjectionGeneratorContext;
import com.intellij.microservices.jvm.inject.InjectionGeneratorHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.completion.SpringBeanInjectionInsertHandler;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.actions.generate.SpringAutowiredGeneratorService;
import com.intellij.spring.model.actions.generate.SpringBeanDependencyGeneratorHelper;
import com.intellij.spring.model.actions.generate.autowire.AutowireBeanUtilsKt;
import com.intellij.spring.model.actions.generate.autowire.SpringBeanPointerWrapper;
import com.intellij.spring.model.jam.stereotype.SuperClassSpringComponentStub;
import com.intellij.spring.model.utils.SpringModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J.\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019\u00b2\u0006\u000f\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u008a\u0084\u0002\u00b2\u0006\u000f\u0010\u001d\u001a\u00070\t\u00a2\u0006\u0002\b\u001eX\u008a\u0084\u0002"}, d2={"Lcom/intellij/spring/completion/SpringBeanInjectionInsertHandler;", "Lcom/intellij/microservices/jvm/completion/beans/BeanInjectionInsertHandler;", "injectionTargetClassPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "beanInjectionCandidate", "Lcom/intellij/spring/model/SpringBeanPointer;", "nameProvider", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/spring/model/SpringBeanPointer;Lkotlin/jvm/functions/Function0;)V", "getCommandContextScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "getInjectionGeneratorHelper", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorHelper;", "elementAtCaret", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "generatorContext", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.spring.core", "lazyModel", "Lcom/intellij/spring/CommonSpringModel;", "Lorg/jetbrains/annotations/NotNull;", "injectedName", "Lcom/intellij/openapi/util/NlsSafe;"})
@SourceDebugExtension(value={"SMAP\nSpringBeanInjectionInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanInjectionInsertHandler.kt\ncom/intellij/spring/completion/SpringBeanInjectionInsertHandler\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,117:1\n171#2:118\n*S KotlinDebug\n*F\n+ 1 SpringBeanInjectionInsertHandler.kt\ncom/intellij/spring/completion/SpringBeanInjectionInsertHandler\n*L\n42#1:118\n*E\n"})
public final class SpringBeanInjectionInsertHandler
extends BeanInjectionInsertHandler {
    @NotNull
    private final SpringBeanPointer<?> beanInjectionCandidate;

    public SpringBeanInjectionInsertHandler(@NotNull SmartPsiElementPointer<PsiElement> injectionTargetClassPointer, @NotNull SpringBeanPointer<?> beanInjectionCandidate, @NotNull Function0<String> nameProvider) {
        Intrinsics.checkNotNullParameter(injectionTargetClassPointer, (String)"injectionTargetClassPointer");
        Intrinsics.checkNotNullParameter(beanInjectionCandidate, (String)"beanInjectionCandidate");
        Intrinsics.checkNotNullParameter(nameProvider, (String)"nameProvider");
        super(injectionTargetClassPointer, nameProvider);
        this.beanInjectionCandidate = beanInjectionCandidate;
    }

    @NotNull
    protected CoroutineScope getCommandContextScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SpringAutowiredGeneratorService.Companion.getInstance(project).getScope();
    }

    @Nullable
    protected InjectionGeneratorHelper<?> getInjectionGeneratorHelper(@NotNull PsiElement elementAtCaret, @NotNull LookupElement item, @NotNull InjectionGeneratorContext generatorContext, @NotNull Module module) {
        PsiElement psiElement;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)elementAtCaret, (String)"elementAtCaret");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)generatorContext, (String)"generatorContext");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                psiElement = this.getInjectionTargetClassPointer().getElement();
                if (psiElement == null) break block2;
                PsiElement $this$toUElementOfType$iv = psiElement;
                boolean $i$f$toUElementOfType = false;
                psiElement = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
                if (psiElement != null) break block3;
            }
            return null;
        }
        PsiElement uClass = psiElement;
        Lazy lazyModel$delegate = LazyKt.lazy(() -> SpringBeanInjectionInsertHandler.getInjectionGeneratorHelper$lambda$0((UClass)uClass));
        Lazy injectedName$delegate = LazyKt.lazy(() -> SpringBeanInjectionInsertHandler.getInjectionGeneratorHelper$lambda$2(this));
        SmartPsiElementPointer smartPsiElementPointer = SmartPointersKt.createSmartPointer((PsiElement)elementAtCaret);
        String string = SpringBeanInjectionInsertHandler.getInjectionGeneratorHelper$lambda$3((Lazy<String>)injectedName$delegate);
        Function0 function0 = () -> SpringBeanInjectionInsertHandler.getInjectionGeneratorHelper$lambda$4(lazyModel$delegate);
        return new SpringBeanDependencyGeneratorHelper(generatorContext, (Lazy<String>)injectedName$delegate, this, (Lazy<? extends CommonSpringModel>)lazyModel$delegate, (SmartPsiElementPointer<PsiElement>)smartPsiElementPointer, string, (Function0<? extends CommonSpringModel>)function0){
            final /* synthetic */ Lazy<String> $injectedName$delegate;
            final /* synthetic */ SpringBeanInjectionInsertHandler this$0;
            final /* synthetic */ Lazy<CommonSpringModel> $lazyModel$delegate;
            {
                this.$injectedName$delegate = $injectedName$delegate;
                this.this$0 = $receiver;
                this.$lazyModel$delegate = $lazyModel$delegate;
                super($super_call_param$1, $super_call_param$2, $generatorContext, $super_call_param$3);
            }

            protected String getElementIdentifier(PsiElement psiElement) {
                Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
                return SpringBeanInjectionInsertHandler.access$getInjectionGeneratorHelper$lambda$3(this.$injectedName$delegate);
            }

            protected List<SpringBeanPointerWrapper> findMatchingBeans(String prefix) {
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                PsiClass psiClass = SpringBeanInjectionInsertHandler.access$getBeanInjectionCandidate$p(this.this$0).getBeanClass();
                if (psiClass == null) {
                    return CollectionsKt.emptyList();
                }
                PsiClass beanClass = psiClass;
                Set beans = new LinkedHashSet<E>();
                SpringBeanPointerWrapper candidateWrapper = new SpringBeanPointerWrapper(SpringBeanInjectionInsertHandler.access$getBeanInjectionCandidate$p(this.this$0), SpringBeanInjectionInsertHandler.access$getInjectionGeneratorHelper$lambda$3(this.$injectedName$delegate), null, null, false, null, 60, null);
                beans.add(candidateWrapper);
                if (!(SpringBeanInjectionInsertHandler.access$getBeanInjectionCandidate$p(this.this$0).getSpringBean() instanceof SuperClassSpringComponentStub)) {
                    return CollectionsKt.toList((Iterable)beans);
                }
                SpringBeanInjectionInsertHandler.access$getInjectionGeneratorHelper$lambda$1(this.$lazyModel$delegate).processByClass(SpringModelSearchParameters.byClass(beanClass), arg_0 -> getInjectionGeneratorHelper.1.findMatchingBeans$lambda$0(beans, this.this$0, this.$injectedName$delegate, arg_0));
                Set<CommonSpringBean> commonSpringBeans = this.findUniqueBeans(beans);
                if (commonSpringBeans.size() == 1) {
                    return CollectionsKt.listOf((Object)candidateWrapper);
                }
                if (commonSpringBeans.size() > 1) {
                    Collection<PsiType> collection = SpringBeanInjectionInsertHandler.access$getBeanInjectionCandidate$p(this.this$0).getEffectiveBeanTypes();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"getEffectiveBeanTypes(...)");
                    PsiType beanType = (PsiType)CollectionsKt.firstOrNull((Iterable)collection);
                    if (beanType != null) {
                        PsiType collectionType = AutowireBeanUtilsKt.createCollectionType((PsiElement)beanClass, beanType);
                        SpringBeanPointer springBeanPointer = SpringBeanInjectionInsertHandler.access$getBeanInjectionCandidate$p(this.this$0);
                        String string = StringUtil.pluralize((String)SpringBeanInjectionInsertHandler.access$getInjectionGeneratorHelper$lambda$3(this.$injectedName$delegate), (int)commonSpringBeans.size());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
                        SpringBeanPointerWrapper wrapper = new SpringBeanPointerWrapper(springBeanPointer, string, SpringPresentationProvider.getSpringIcon(SpringBeanInjectionInsertHandler.access$getBeanInjectionCandidate$p(this.this$0)), collectionType, true, null, 32, null);
                        beans.add(wrapper);
                    }
                }
                Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)beans);
                boolean $i$f$sortedByDescending = false;
                return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SpringBeanPointerWrapper it = (SpringBeanPointerWrapper)b;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(it.getBean().getSpringBean().isPrimary());
                        it = (SpringBeanPointerWrapper)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getBean().getSpringBean().isPrimary()));
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            private final Set<CommonSpringBean> findUniqueBeans(Set<SpringBeanPointerWrapper> beans) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = beans;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    ? springBean;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    SpringBeanPointerWrapper it = (SpringBeanPointerWrapper)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it.getBean().getSpringBean(), (String)"getSpringBean(...)");
                    if (springBean instanceof SuperClassSpringComponentStub) {
                        ? $this$asSafely$iv = springBean;
                        boolean $i$f$asSafely = false;
                        ? obj = $this$asSafely$iv;
                        if (!(obj instanceof SuperClassSpringComponentStub)) {
                            obj = null;
                        }
                        SuperClassSpringComponentStub superClassSpringComponentStub = (SuperClassSpringComponentStub)obj;
                        object = superClassSpringComponentStub != null ? superClassSpringComponentStub.getOriginalBean() : null;
                    } else {
                        object = springBean;
                    }
                    if (object == null) continue;
                    ? it$iv$iv = object;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Set uniqueBeans = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                return uniqueBeans;
            }

            protected String getBeanLocation(SpringBeanPointerWrapper bean) {
                Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
                return bean.getLocation();
            }

            private static final boolean findMatchingBeans$lambda$0(Set $beans, SpringBeanInjectionInsertHandler this$0, Lazy $injectedName$delegate, SpringBeanPointer it) {
                Intrinsics.checkNotNull((Object)it);
                $beans.add(new SpringBeanPointerWrapper(it, SpringBeanInjectionInsertHandler.access$getInjectionGeneratorHelper$lambda$3($injectedName$delegate), null, AutowireBeanUtilsKt.effectiveBeanType(SpringBeanInjectionInsertHandler.access$getBeanInjectionCandidate$p(this$0), it), false, null, 52, null));
                return true;
            }
        };
    }

    private static final CommonSpringModel getInjectionGeneratorHelper$lambda$0(UClass $uClass) {
        return SpringModelUtils.getInstance().getPsiClassSpringModel($uClass.getJavaPsi());
    }

    private static final CommonSpringModel getInjectionGeneratorHelper$lambda$1(Lazy<? extends CommonSpringModel> $lazyModel$delegate) {
        Lazy<? extends CommonSpringModel> lazy = $lazyModel$delegate;
        return (CommonSpringModel)lazy.getValue();
    }

    private static final String getInjectionGeneratorHelper$lambda$2(SpringBeanInjectionInsertHandler this$0) {
        return (String)this$0.getNameProvider().invoke();
    }

    private static final String getInjectionGeneratorHelper$lambda$3(Lazy<String> $injectedName$delegate) {
        Lazy<String> lazy = $injectedName$delegate;
        return (String)lazy.getValue();
    }

    private static final CommonSpringModel getInjectionGeneratorHelper$lambda$4(Lazy $lazyModel$delegate) {
        return SpringBeanInjectionInsertHandler.getInjectionGeneratorHelper$lambda$1((Lazy<? extends CommonSpringModel>)$lazyModel$delegate);
    }

    public static final /* synthetic */ String access$getInjectionGeneratorHelper$lambda$3(Lazy $injectedName$delegate) {
        return SpringBeanInjectionInsertHandler.getInjectionGeneratorHelper$lambda$3((Lazy<String>)$injectedName$delegate);
    }

    public static final /* synthetic */ SpringBeanPointer access$getBeanInjectionCandidate$p(SpringBeanInjectionInsertHandler $this) {
        return $this.beanInjectionCandidate;
    }

    public static final /* synthetic */ CommonSpringModel access$getInjectionGeneratorHelper$lambda$1(Lazy $lazyModel$delegate) {
        return SpringBeanInjectionInsertHandler.getInjectionGeneratorHelper$lambda$1((Lazy<? extends CommonSpringModel>)$lazyModel$delegate);
    }
}

