/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.beans;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.diagrams.beans.SpringDiagramBeansProcessingModel;
import com.intellij.spring.diagrams.beans.SpringDiagramCategoryManager;
import com.intellij.spring.diagrams.beans.SpringDiagramDataModelUpdater;
import com.intellij.spring.diagrams.perspectives.beans.SpringBeanPointerWrapper;
import com.intellij.spring.diagrams.perspectives.beans.SpringElementWrapper;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SpringDiagramDataModel
extends SpringDiagramBeansProcessingModel {
    private final SpringElementWrapper<?> myElement;
    private final ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter;

    public SpringDiagramDataModel(Project project, DiagramProvider<SpringElementWrapper<?>> springBaseBeanPointerDiagramProvider, @Nullable SpringElementWrapper<?> element) {
        super(project, springBaseBeanPointerDiagramProvider);
        this.myElement = element;
        DomEventListener domEventListener = new DomEventListener(){

            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/diagrams/beans/SpringDiagramDataModel$1", "eventOccured"));
            }
        };
        DomManager.getDomManager((Project)project).addDomEventListener(domEventListener, (Disposable)this);
        this.myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetConfigurationChanged(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            public void facetRemoved(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(1);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            public void facetAdded(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(2);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/spring/diagrams/beans/SpringDiagramDataModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).registerListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter, (Disposable)this);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.setDefaultHandler(() -> this.incModificationCount());
        messageBusConnection.subscribe(ModuleRootListener.TOPIC);
        messageBusConnection.subscribe(ModuleListener.TOPIC);
    }

    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)this.getProject())) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                SpringDiagramDataModel.$$$reportNull$$$0(1);
            }
            return completableFuture;
        }
        this.clearAll();
        boolean includeLibraries = this.getNodeContentManager().isCategoryEnabled(SpringDiagramCategoryManager.LIBRARIES);
        CancellablePromise promise = ReadAction.nonBlocking(() -> {
            CommonSpringModel model = this.getActualModel();
            if (model == null) {
                return null;
            }
            SpringDiagramDataModelUpdater updater = new SpringDiagramDataModelUpdater(model, this.getProvider(), includeLibraries);
            updater.performUpdate();
            return updater;
        }).expireWith((Disposable)this).inSmartMode(this.getProject()).wrapProgress(indicator).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.any(), updater -> {
            if (updater == null) {
                return;
            }
            this.getNodes().addAll(updater.getNodes());
            this.getEdges().addAll(updater.getEdges());
            this.finishDataModelRefresh((SpringDiagramDataModelUpdater)updater);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        CompletableFuture completableFuture = Promises.asCompletableFuture((Promise)promise.then(updater -> null));
        if (completableFuture == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    protected void finishDataModelRefresh(@Nullable SpringDiagramDataModelUpdater updater) {
        if (this.isSelectionMode()) {
            DiagramAlgorithmsService.getInstance().removeNonSelectedDependencies((DiagramDataModel)this);
        }
    }

    @Override
    protected CommonSpringModel getActualModel() {
        return this.getApplicationModel(Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(SpringDiagramCategoryManager.LOCAL));
    }

    @Nullable
    public CommonSpringModel getApplicationModel(boolean isLocalModel) {
        return this.myElement == null ? null : this.myElement.getProcessingSpringModel(isLocalModel);
    }

    protected boolean isSelectionMode() {
        return CommonDiagramExtras.isSelectionMode((DiagramBuilder)this.getBuilder());
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SpringDiagramDataModel springDiagramDataModel = this;
        if (springDiagramDataModel == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(3);
        }
        return springDiagramDataModel;
    }

    public void dispose() {
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).unregisterListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter);
    }

    @Override
    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<SpringElementWrapper<?>> n) {
        SpringElementWrapper identifyingElement;
        if (n == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(4);
        }
        if ((identifyingElement = (SpringElementWrapper)n.getIdentifyingElement()) instanceof SpringBeanPointerWrapper) {
            SpringBeanPointer beanPointer = (SpringBeanPointer)((SpringBeanPointerWrapper)identifyingElement).getWrapped();
            return beanPointer.isValid() ? SpringPresentationProvider.getSpringBeanName(beanPointer) : "";
        }
        String string = identifyingElement.getName();
        if (string == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/diagrams/beans/SpringDiagramDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/diagrams/beans/SpringDiagramDataModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModelAsync";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refreshDataModelAsync";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

