/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom.namespaces;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpringBeanNamespaceDescriptor<T extends PsiElement>
extends XmlNSDescriptorImpl {
    static final String REF_SUFFIX = "-ref";

    public XmlAttributeDescriptor getAttribute(String localName, String namespace, XmlTag context) {
        if (this.getNamespace().equals(namespace)) {
            String sanitizedLocalName = AbstractSpringBeanNamespaceDescriptor.attributeNameToPropertyName(localName);
            for (XmlAttributeDescriptor descriptor : this.getAttributeDescriptors(context)) {
                if (!descriptor.getName().equals(sanitizedLocalName)) continue;
                return descriptor;
            }
        }
        return super.getAttribute(localName, namespace, context);
    }

    public static String attributeNameToPropertyName(String attributeName) {
        String realAttributeName = StringUtil.trimEnd((String)attributeName, (String)REF_SUFFIX);
        if (!realAttributeName.contains("-")) {
            return realAttributeName;
        }
        char[] chars = realAttributeName.toCharArray();
        char[] result = new char[chars.length - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        for (char c : chars) {
            if (c == '-') {
                upperCaseNext = true;
                continue;
            }
            if (upperCaseNext) {
                result[currPos++] = Character.toUpperCase(c);
                upperCaseNext = false;
                continue;
            }
            result[currPos++] = c;
        }
        return new String(result, 0, currPos);
    }

    protected abstract String getNamespace();

    @Nullable
    protected static SpringBean getSpringBean(@NotNull XmlTag tag) {
        DomElement element;
        if (tag == null) {
            AbstractSpringBeanNamespaceDescriptor.$$$reportNull$$$0(0);
        }
        if ((element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) instanceof SpringBean) {
            return (SpringBean)element;
        }
        return null;
    }

    @Nullable
    protected static PsiClass getClass(@NotNull XmlTag tag) {
        DomElement element;
        if (tag == null) {
            AbstractSpringBeanNamespaceDescriptor.$$$reportNull$$$0(1);
        }
        if ((element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) instanceof SpringBean) {
            SpringBean bean = (SpringBean)element;
            return PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType(true));
        }
        return null;
    }

    private XmlAttributeDescriptor[] getAttributeDescriptors(@NotNull XmlTag tag) {
        SpringBean springBean;
        if (tag == null) {
            AbstractSpringBeanNamespaceDescriptor.$$$reportNull$$$0(2);
        }
        if ((springBean = AbstractSpringBeanNamespaceDescriptor.getSpringBean(tag)) == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        Map<String, T> properties = this.getAttributesWithoutRecursion(springBean);
        if (properties.isEmpty()) {
            return XmlAttributeDescriptor.EMPTY;
        }
        ArrayList result = new ArrayList(properties.size() * 2);
        for (String attrName : properties.keySet()) {
            PsiElement t = (PsiElement)properties.get(attrName);
            result.add(this.createAttributeDescriptor(attrName, t, ""));
            PsiType attributeType = this.getAttributeType(t);
            if (!(attributeType instanceof PsiClassType) && !(attributeType instanceof PsiArrayType)) continue;
            result.add(this.createAttributeDescriptor(attrName, t, REF_SUFFIX));
        }
        return result.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @NotNull
    private Map<String, T> getAttributesWithoutRecursion(@NotNull SpringBean springBean) {
        PsiElement identifyingPsiElement;
        if (springBean == null) {
            AbstractSpringBeanNamespaceDescriptor.$$$reportNull$$$0(3);
        }
        if ((identifyingPsiElement = springBean.getIdentifyingPsiElement()) == null || !identifyingPsiElement.isValid()) {
            Map map = Collections.emptyMap();
            if (map == null) {
                AbstractSpringBeanNamespaceDescriptor.$$$reportNull$$$0(4);
            }
            return map;
        }
        Map map = (Map)RecursionManager.doPreventingRecursion((Object)identifyingPsiElement, (boolean)false, () -> this.getAttributes(springBean));
        Map map2 = map != null ? map : Collections.emptyMap();
        if (map2 == null) {
            AbstractSpringBeanNamespaceDescriptor.$$$reportNull$$$0(5);
        }
        return map2;
    }

    protected abstract PsiType getAttributeType(T var1);

    protected abstract SpringBeanAttributeDescriptor<?> createAttributeDescriptor(String var1, T var2, String var3);

    protected abstract Map<String, T> getAttributes(@NotNull SpringBean var1);

    public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        if (XmlElementDescriptor.EMPTY_ARRAY == null) {
            AbstractSpringBeanNamespaceDescriptor.$$$reportNull$$$0(6);
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    public XmlAttributeDescriptor[] getRootAttributeDescriptors(XmlTag context) {
        return this.getAttributeDescriptors(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesWithoutRecursion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBean";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesWithoutRecursion";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    protected static abstract class SpringBeanAttributeDescriptor<T extends PsiElement>
    implements XmlAttributeDescriptorEx,
    PsiPresentableMetaData {
        protected final String myAttributeName;
        protected final String mySuffix;
        protected final T myPsiElement;
        protected final String myNamespace;

        public SpringBeanAttributeDescriptor(@NonNls String attributeName, @NonNls String suffix, T t, String namespace) {
            this.myAttributeName = attributeName;
            this.mySuffix = suffix;
            this.myPsiElement = t;
            this.myNamespace = namespace;
        }

        public String getName() {
            return this.myAttributeName + this.mySuffix;
        }

        public void init(PsiElement element) {
            throw new UnsupportedOperationException("Method init is not yet implemented in " + this.getClass().getName());
        }

        public PsiElement getDeclaration() {
            return this.myPsiElement;
        }

        @NonNls
        public String getName(PsiElement context) {
            Object name = this.getName();
            String prefix = ((XmlTag)context).getPrefixByNamespace(this.myNamespace);
            name = (String)(StringUtil.isNotEmpty((String)prefix) ? prefix + ":" : "") + (String)name;
            return name;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isFixed() {
            return false;
        }

        public boolean hasIdType() {
            return false;
        }

        public boolean hasIdRefType() {
            return false;
        }

        @Nullable
        public String getDefaultValue() {
            return null;
        }

        public boolean isEnumerated() {
            return false;
        }

        public String[] getEnumeratedValues() {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        @Nullable
        public String validateValue(XmlElement context, String value) {
            return null;
        }

        public String getTypeName() {
            return null;
        }

        @Nullable
        public Icon getIcon() {
            return SpringApiIcons.SpringProperty;
        }
    }

    protected static class CAttributeDescriptor
    extends SpringBeanAttributeDescriptor<PsiParameter> {
        public CAttributeDescriptor(@NonNls String attributeName, @NonNls String suffix, PsiParameter psiMethod, String namespace) {
            super(attributeName, suffix, psiMethod, namespace);
        }

        @NonNls
        public String handleTargetRename(@NotNull @NonNls String newTargetName) {
            if (newTargetName == null) {
                CAttributeDescriptor.$$$reportNull$$$0(0);
            }
            return newTargetName + this.mySuffix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetName", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor$CAttributeDescriptor", "handleTargetRename"));
        }
    }

    protected static class PAttributeDescriptor
    extends SpringBeanAttributeDescriptor<PsiMethod> {
        public PAttributeDescriptor(@NonNls String attributeName, @NonNls String suffix, PsiMethod psiMethod, String namespace) {
            super(attributeName, suffix, psiMethod, namespace);
        }

        @NonNls
        public String handleTargetRename(@NotNull @NonNls String newTargetName) {
            String propertyName;
            if (newTargetName == null) {
                PAttributeDescriptor.$$$reportNull$$$0(0);
            }
            return (propertyName = PropertyUtilBase.getPropertyName((String)newTargetName)) == null ? null : propertyName + this.mySuffix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetName", "com/intellij/spring/dom/namespaces/AbstractSpringBeanNamespaceDescriptor$PAttributeDescriptor", "handleTargetRename"));
        }
    }
}

