/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSetData;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringFileSet
implements Disposable {
    private final SpringFileSetData myData;
    private final SpringFacet myFacet;
    private final List<VirtualFilePointer> myFiles = new SmartList();
    private boolean myAutodetected;

    protected SpringFileSet(String id, String name, SpringFacet parent) {
        this(SpringFileSetData.create(id, name), parent);
    }

    protected SpringFileSet(SpringFileSetData data, SpringFacet facet) {
        this.myData = data;
        this.myFacet = facet;
        for (String url : data.getFiles()) {
            this.myFiles.add(this.createVirtualFilePointer(url));
        }
    }

    protected SpringFileSet(SpringFileSet original) {
        this.myFacet = original.getFacet();
        this.myData = SpringFileSetData.create(original.getData());
        this.myFiles.addAll(original.getFiles());
        this.myAutodetected = original.isAutodetected();
        this.myData.setActiveProfiles(original.getActiveProfiles());
    }

    @NotNull
    public String getId() {
        String string = this.myData.getId();
        if (string == null) {
            SpringFileSet.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsSafe
    public String getName() {
        return this.myData.getName();
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            SpringFileSet.$$$reportNull$$$0(1);
        }
        this.myData.setName(name);
    }

    public String getQualifiedName() {
        return SpringFileSetService.getInstance().getQualifiedName(this);
    }

    public abstract Icon getIcon();

    public boolean isNew() {
        return false;
    }

    public boolean isAutodetected() {
        return this.myAutodetected;
    }

    public void setAutodetected(boolean autodetected) {
        this.myAutodetected = autodetected;
    }

    public boolean isRemoved() {
        return this.myData.isRemoved();
    }

    void setRemoved(boolean removed) {
        this.myData.setRemoved(removed);
    }

    public SpringFacet getFacet() {
        return this.myFacet;
    }

    SpringFileSetData getData() {
        return this.myData;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myData.getActiveProfiles();
        if (set == null) {
            SpringFileSet.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            SpringFileSet.$$$reportNull$$$0(3);
        }
        this.myData.setActiveProfiles(activeProfiles);
    }

    public Set<SpringFileSet> getDependencyFileSets() {
        LinkedHashSet<SpringFileSet> sets = new LinkedHashSet<SpringFileSet>();
        for (String dependencyId : this.myData.getDependencies()) {
            SpringFileSet fileSet = SpringFileSetService.getInstance().findDependencyFileSet(this, dependencyId);
            ContainerUtil.addIfNotNull(sets, (Object)fileSet);
        }
        return sets;
    }

    public void setDependencies(List<SpringFileSet> springFileSets) {
        this.myData.getDependencies().clear();
        for (SpringFileSet dependency : springFileSets) {
            this.addDependency(dependency);
        }
    }

    public void addDependency(@NotNull SpringFileSet springFileSet) {
        if (springFileSet == null) {
            SpringFileSet.$$$reportNull$$$0(4);
        }
        this.myData.addDependency(this.getDependencyIdFor(springFileSet));
    }

    public void removeDependency(@NotNull SpringFileSet springFileSet) {
        if (springFileSet == null) {
            SpringFileSet.$$$reportNull$$$0(5);
        }
        this.myData.getDependencies().remove(this.getDependencyIdFor(springFileSet));
    }

    private String getDependencyIdFor(SpringFileSet other) {
        return SpringFileSetService.getInstance().getDependencyIdFor(this, other);
    }

    @NotNull
    public List<VirtualFilePointer> getFiles() {
        List<VirtualFilePointer> list = this.myFiles;
        if (list == null) {
            SpringFileSet.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Set<VirtualFilePointer> getXmlFiles() {
        Set<VirtualFilePointer> set = this.getConfigFiles((FileType)StdFileTypes.XML);
        if (set == null) {
            SpringFileSet.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFilePointer> getCodeConfigurationFiles() {
        LinkedHashSet<VirtualFilePointer> filePointers = new LinkedHashSet<VirtualFilePointer>();
        for (VirtualFilePointer virtualFilePointer : this.myFiles) {
            PsiFile psiFile;
            VirtualFile virtualFile;
            if (!virtualFilePointer.isValid() || (virtualFile = virtualFilePointer.getFile()) == null || !virtualFile.isValid() || SpringFileSet.isFileType((FileType)StdFileTypes.XML, virtualFile) || SpringFileSet.isFileType((FileType)PropertiesFileType.INSTANCE, virtualFile) || !((psiFile = PsiManager.getInstance((Project)this.getFacet().getModule().getProject()).findFile(virtualFile)) instanceof PsiClassOwner)) continue;
            filePointers.add(virtualFilePointer);
        }
        LinkedHashSet<VirtualFilePointer> linkedHashSet = filePointers;
        if (linkedHashSet == null) {
            SpringFileSet.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    private Set<VirtualFilePointer> getConfigFiles(@NotNull FileType fileType) {
        if (fileType == null) {
            SpringFileSet.$$$reportNull$$$0(9);
        }
        LinkedHashSet<VirtualFilePointer> filePointers = new LinkedHashSet<VirtualFilePointer>();
        for (VirtualFilePointer virtualFilePointer : this.myFiles) {
            VirtualFile virtualFile;
            if (!virtualFilePointer.isValid() || (virtualFile = virtualFilePointer.getFile()) == null || !SpringFileSet.isFileType(fileType, virtualFile)) continue;
            filePointers.add(virtualFilePointer);
        }
        return filePointers;
    }

    private static boolean isFileType(@NotNull FileType fileType, @NotNull VirtualFile file) {
        if (fileType == null) {
            SpringFileSet.$$$reportNull$$$0(10);
        }
        if (file == null) {
            SpringFileSet.$$$reportNull$$$0(11);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, fileType);
    }

    @NotNull
    public Set<VirtualFilePointer> getPropertiesFiles() {
        Set<VirtualFilePointer> set = this.getConfigFiles((FileType)PropertiesFileType.INSTANCE);
        if (set == null) {
            SpringFileSet.$$$reportNull$$$0(12);
        }
        return set;
    }

    public boolean hasFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        for (VirtualFilePointer virtualFilePointer : this.myFiles) {
            VirtualFile virtualFile;
            if (!virtualFilePointer.isValid() || (virtualFile = virtualFilePointer.getFile()) == null || !file.equals(virtualFile)) continue;
            return true;
        }
        return false;
    }

    protected VirtualFilePointer createVirtualFilePointer(@NotNull String url) {
        if (url == null) {
            SpringFileSet.$$$reportNull$$$0(13);
        }
        return VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
    }

    public void addFile(@NotNull VirtualFile file) {
        if (file == null) {
            SpringFileSet.$$$reportNull$$$0(14);
        }
        this.addFile(file.getUrl());
    }

    public void addFile(@NonNls String url) {
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            this.myFiles.add(this.createVirtualFilePointer(url));
            this.myData.addFile(url);
        }
    }

    public void removeFile(VirtualFilePointer file) {
        this.myFiles.remove(file);
        this.myData.removeFile(file.getUrl());
    }

    public void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringFileSet set = (SpringFileSet)o;
        if (this.getData() != null ? !this.getData().equals(set.getData()) : set.getData() != null) {
            return false;
        }
        return !(this.getFacet() != null ? !this.getFacet().equals((Object)set.getFacet()) : set.getFacet() != null);
    }

    public int hashCode() {
        int result = this.getFacet() != null ? this.getFacet().hashCode() : 0;
        result = 31 * result + (this.getData() != null ? this.getData().hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 9, 10, 11, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringFileSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springFileSet";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringFileSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeConfigurationFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setActiveProfiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDependency";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFiles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFileType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualFilePointer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 9, 10, 11, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

