/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDomAnnotator
extends LineMarkerProviderDescriptor {
    private static final NotNullFunction<CommonSpringBean, Collection<? extends PsiElement>> STEREOTYPES_CONVERTER = commonSpringBean -> Collections.singleton(commonSpringBean.getIdentifyingPsiElement());
    private static final NotNullFunction<? super SpringBeanPointer<?>, ? extends Collection<? extends PsiElement>> CONVERTER = pointer -> {
        Object springBean = pointer.getSpringBean();
        if (springBean instanceof DomSpringBean) {
            return ContainerUtil.createMaybeSingletonList((Object)((DomSpringBean)springBean).getXmlElement());
        }
        return ContainerUtil.createMaybeSingletonList((Object)pointer.getPsiElement());
    };

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringDomAnnotator.$$$reportNull$$$0(0);
        }
        if (!DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS) {
            return null;
        }
        if (!(psiElement instanceof XmlTag)) {
            return null;
        }
        if (!SpringDomAnnotator.isSpringXml(psiElement.getContainingFile())) {
            return null;
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)psiElement);
        if (!(domElement instanceof Beans)) {
            return null;
        }
        if (domElement.equals(DomUtil.getFileElement((DomElement)domElement).getRootElement())) {
            return null;
        }
        XmlToken identifier = XmlTagUtil.getStartTagNameElement((XmlTag)domElement.getXmlTag());
        if (identifier == null) {
            return null;
        }
        return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)identifier, (EditorColorsManager)EditorColorsManager.getInstance());
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            SpringDomAnnotator.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SpringDomAnnotator.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (!SpringDomAnnotator.isSpringXml(file)) {
            return;
        }
        SpringModel model = SpringManager.getInstance(file.getProject()).getSpringModelByFile(file);
        if (model == null) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ProgressManager.checkCanceled();
            PsiElement element = elements.get(i);
            SpringDomAnnotator.annotate(model, element, result);
        }
    }

    public String getId() {
        return "SpringDomAnnotator";
    }

    @NotNull
    public String getName() {
        String string = SpringBundle.message("spring.core.dom.annotator.name", new Object[0]);
        if (string == null) {
            SpringDomAnnotator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.SpringConfig;
    }

    private static boolean isSpringXml(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        return SpringDomUtils.isSpringXml(xmlFile);
    }

    private static void annotateSpringBeanChildren(SpringModel model, SpringBean bean, Collection<? super LineMarkerInfo<?>> result) {
        XmlTag beanXmlTag = bean.getXmlTag();
        if (beanXmlTag == null) {
            return;
        }
        SpringBeanPointer<?> pointer = BeanService.getInstance().createSpringBeanPointer(bean);
        if (SpringDomAnnotator.getChildren(model, pointer).isEmpty()) {
            return;
        }
        SpringGutterIconBuilder<? super SpringBeanPointer<?>> iconBuilder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.ParentBeanGutter, CONVERTER, null);
        iconBuilder.setTargets(NotNullLazyValue.lazy(() -> {
            SmartList children = new SmartList();
            children.addAll(SpringDomAnnotator.getChildren(model, pointer));
            children.sort(SpringBeanPointer.DISPLAY_COMPARATOR);
            return children;
        })).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setTargetRenderer(SpringBeansPsiElementCellRenderer::new).setTooltipText(SpringBundle.message("spring.parent.bean.tooltip", new Object[0]));
        XmlToken identifier = XmlTagUtil.getStartTagNameElement((XmlTag)beanXmlTag);
        if (identifier != null) {
            result.add((LineMarkerInfo<?>)iconBuilder.createSpringRelatedMergeableLineMarkerInfo((PsiElement)identifier));
        }
    }

    @NotNull
    private static List<SpringBeanPointer<?>> getChildren(SpringModel model, @NotNull SpringBeanPointer<?> parent) {
        if (parent == null) {
            SpringDomAnnotator.$$$reportNull$$$0(4);
        }
        List<SpringBeanPointer<?>> list = SpringModelVisitorUtils.getDescendants(model, parent);
        if (list == null) {
            SpringDomAnnotator.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void annotate(SpringModel model, @NotNull PsiElement psiElement, Collection<? super LineMarkerInfo<?>> result) {
        if (psiElement == null) {
            SpringDomAnnotator.$$$reportNull$$$0(6);
        }
        if (!(psiElement instanceof XmlToken)) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof XmlTag)) {
            return;
        }
        XmlTag tag = (XmlTag)parent;
        if (XmlTagUtil.getStartTagNameElement((XmlTag)tag) != psiElement) {
            return;
        }
        DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(tag);
        if (element instanceof SpringBean) {
            SpringDomAnnotator.annotateSpringBeanChildren(model, (SpringBean)element, result);
            SpringDomAnnotator.annotateAutowiredBeans(model, (SpringBean)element, result);
        } else if (element instanceof SpringBeansPackagesScanBean) {
            SpringDomAnnotator.annotateComponentScan((SpringBeansPackagesScanBean)element, result);
        }
    }

    private static void annotateComponentScan(@NotNull SpringBeansPackagesScanBean componentScan, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        XmlTag tag;
        if (componentScan == null) {
            SpringDomAnnotator.$$$reportNull$$$0(7);
        }
        if (result == null) {
            SpringDomAnnotator.$$$reportNull$$$0(8);
        }
        if ((tag = componentScan.getXmlTag()) == null) {
            return;
        }
        SpringGutterIconBuilder<CommonSpringBean> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.SpringScan, STEREOTYPES_CONVERTER, null);
        builder.setPopupTitle(SpringBundle.message("spring.dom.component.scan.stereotypes", new Object[0])).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setTooltipText(SpringBundle.message("spring.dom.component.scan.stereotypes.title", new Object[0])).setTargetRenderer(SpringBeansPsiElementCellRenderer::new).setTargets(NotNullLazyValue.lazy(() -> SpringDomAnnotator.getSortedByName(SpringDomAnnotator.getScannedStereotypesFromAllModels(componentScan))));
        XmlToken identifier = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        if (identifier != null) {
            result.add((LineMarkerInfo<?>)builder.createSpringRelatedMergeableLineMarkerInfo((PsiElement)identifier));
        }
    }

    @NotNull
    private static Set<CommonSpringBean> getScannedStereotypesFromAllModels(@NotNull SpringBeansPackagesScanBean componentScan) {
        if (componentScan == null) {
            SpringDomAnnotator.$$$reportNull$$$0(9);
        }
        XmlTag tag = componentScan.getXmlTag();
        Module module = componentScan.getModule();
        if (tag == null || module == null) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                SpringDomAnnotator.$$$reportNull$$$0(10);
            }
            return set;
        }
        XmlFile xmlFile = DomUtil.getFile((DomElement)componentScan);
        LinkedHashSet<CommonSpringBean> stereotypeElements = new LinkedHashSet<CommonSpringBean>();
        Set<SpringModel> models = SpringManager.getInstance(xmlFile.getProject()).getSpringModelsByFile((PsiFile)xmlFile);
        for (CommonSpringModel commonSpringModel : models) {
            Set scannedElements;
            Module springModelModule = commonSpringModel.getModule();
            if (springModelModule == null || (scannedElements = componentScan.getScannedElements(springModelModule, true)).isEmpty()) continue;
            ArrayList elements = new ArrayList(scannedElements);
            stereotypeElements.addAll(SpringProfileUtils.filterBeansInActiveProfiles(new SmartList(elements), commonSpringModel.getActiveProfiles()));
        }
        LinkedHashSet<CommonSpringBean> linkedHashSet = stereotypeElements;
        if (linkedHashSet == null) {
            SpringDomAnnotator.$$$reportNull$$$0(11);
        }
        return linkedHashSet;
    }

    private static SortedList<CommonSpringBean> getSortedByName(Set<? extends CommonSpringBean> stereotypeElements) {
        SortedList sortedList = new SortedList((o1, o2) -> {
            String beanName1 = o1.getBeanName();
            String beanName2 = o2.getBeanName();
            if (beanName1 != null && beanName2 != null) {
                return beanName1.compareTo(beanName2);
            }
            return 0;
        });
        sortedList.addAll(stereotypeElements);
        return sortedList;
    }

    private static void annotateAutowiredBeans(SpringModel model, @NotNull SpringBean springBean, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        XmlToken identifier;
        XmlTag tag;
        if (springBean == null) {
            SpringDomAnnotator.$$$reportNull$$$0(12);
        }
        if (result == null) {
            SpringDomAnnotator.$$$reportNull$$$0(13);
        }
        if ((tag = springBean.getXmlTag()) == null) {
            return;
        }
        Collection<SpringBeanPointer<?>> autowiredBeans = SpringDomAnnotator.getAutowiredBeans(model, springBean);
        if (!autowiredBeans.isEmpty() && (identifier = XmlTagUtil.getStartTagNameElement((XmlTag)tag)) != null) {
            NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(() -> autowiredBeans, result, (PsiElement)identifier);
        }
    }

    @NotNull
    private static Collection<SpringBeanPointer<?>> getAutowiredBeans(SpringModel model, SpringBean springBean) {
        if (SpringAutowireUtil.isByTypeAutowired(springBean)) {
            return SpringDomAnnotator.collectAllPointers(SpringAutowireUtil.getByTypeAutowiredProperties(springBean, model).values());
        }
        if (SpringAutowireUtil.isByNameAutowired(springBean)) {
            Collection<SpringBeanPointer<?>> collection = SpringAutowireUtil.getByNameAutowiredProperties(springBean).values();
            if (collection == null) {
                SpringDomAnnotator.$$$reportNull$$$0(14);
            }
            return collection;
        }
        if (SpringAutowireUtil.isConstructorAutowire(springBean)) {
            return SpringDomAnnotator.collectAllPointers(SpringAutowireUtil.getConstructorAutowiredProperties(springBean, model).values());
        }
        Set<SpringBeanPointer<?>> set = Collections.emptySet();
        if (set == null) {
            SpringDomAnnotator.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    private static Set<SpringBeanPointer<?>> collectAllPointers(@NotNull Collection<? extends Collection<SpringBeanPointer<?>>> values) {
        if (values == null) {
            SpringDomAnnotator.$$$reportNull$$$0(16);
        }
        LinkedHashSet beanPointers = new LinkedHashSet();
        for (Collection<SpringBeanPointer<?>> pointers : values) {
            beanPointers.addAll(pointers);
        }
        LinkedHashSet linkedHashSet = beanPointers;
        if (linkedHashSet == null) {
            SpringDomAnnotator.$$$reportNull$$$0(17);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 10, 11, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/gutter/SpringDomAnnotator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentScan";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/gutter/SpringDomAnnotator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScannedStereotypesFromAllModels";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutowiredBeans";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "annotateComponentScan";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScannedStereotypesFromAllModels";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "annotateAutowiredBeans";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectAllPointers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 10, 11, 14, 15, 17 -> new IllegalStateException(string);
        };
    }
}

